/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.fs.hdfs;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.runtime.fs.hdfs.HadoopFileSystem;
import org.apache.flink.runtime.fs.hdfs.HadoopFsRecoverable;
import org.apache.flink.runtime.fs.hdfs.HadoopRecoverableFsDataOutputStream;
import org.apache.flink.runtime.fs.hdfs.HadoopRecoverableSerializer;
import org.apache.flink.runtime.util.HadoopUtils;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.util.VersionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class HadoopRecoverableWriter
implements RecoverableWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopRecoverableWriter.class);
    private final FileSystem fs;

    public HadoopRecoverableWriter(FileSystem fs) {
        this.fs = Preconditions.checkNotNull(fs);
        if (!"hdfs".equalsIgnoreCase(fs.getScheme()) && !"viewfs".equalsIgnoreCase(fs.getScheme())) {
            throw new UnsupportedOperationException("Recoverable writers on Hadoop are only supported for HDFS");
        }
        if (!HadoopUtils.isMinHadoopVersion(2, 7)) {
            LOG.warn("WARNING: You are running on hadoop version " + VersionInfo.getVersion() + ". If your RollingPolicy does not roll on every checkpoint/savepoint, the StreamingFileSink will throw an exception upon recovery.");
        }
    }

    @Override
    public RecoverableFsDataOutputStream open(Path filePath) throws IOException {
        org.apache.hadoop.fs.Path targetFile = HadoopFileSystem.toHadoopPath(filePath);
        org.apache.hadoop.fs.Path tempFile = HadoopRecoverableWriter.generateStagingTempFilePath(this.fs, targetFile);
        return new HadoopRecoverableFsDataOutputStream(this.fs, targetFile, tempFile);
    }

    @Override
    public RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable recoverable) throws IOException {
        if (recoverable instanceof HadoopFsRecoverable) {
            return new HadoopRecoverableFsDataOutputStream(this.fs, (HadoopFsRecoverable)recoverable);
        }
        throw new IllegalArgumentException("Hadoop File System cannot recover a recoverable for another file system: " + recoverable);
    }

    @Override
    public boolean requiresCleanupOfRecoverableState() {
        return false;
    }

    @Override
    public boolean cleanupRecoverableState(RecoverableWriter.ResumeRecoverable resumable) throws IOException {
        return false;
    }

    @Override
    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable recoverable) throws IOException {
        if (recoverable instanceof HadoopFsRecoverable) {
            return new HadoopRecoverableFsDataOutputStream.HadoopFsCommitter(this.fs, (HadoopFsRecoverable)recoverable);
        }
        throw new IllegalArgumentException("Hadoop File System  cannot recover a recoverable for another file system: " + recoverable);
    }

    @Override
    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        HadoopRecoverableSerializer typedSerializer = HadoopRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    @Override
    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        HadoopRecoverableSerializer typedSerializer = HadoopRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    @Override
    public boolean supportsResume() {
        return true;
    }

    @VisibleForTesting
    static org.apache.hadoop.fs.Path generateStagingTempFilePath(FileSystem fs, org.apache.hadoop.fs.Path targetFile) throws IOException {
        org.apache.hadoop.fs.Path candidate;
        Preconditions.checkArgument(targetFile.isAbsolute(), "targetFile must be absolute");
        org.apache.hadoop.fs.Path parent = targetFile.getParent();
        String name = targetFile.getName();
        Preconditions.checkArgument(parent != null, "targetFile must not be the root directory");
        while (fs.exists(candidate = new org.apache.hadoop.fs.Path(parent, "." + name + ".inprogress." + UUID.randomUUID().toString()))) {
        }
        return candidate;
    }
}

