/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.base.table.sink.options;

import java.util.Properties;
import java.util.function.Predicate;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.connector.base.table.AsyncSinkConnectorOptions;
import org.apache.flink.connector.base.table.options.ConfigurationValidator;

@PublicEvolving
public class AsyncSinkConfigurationValidator
implements ConfigurationValidator {
    protected final ReadableConfig tableOptions;

    public AsyncSinkConfigurationValidator(ReadableConfig tableOptions) {
        this.tableOptions = tableOptions;
    }

    @Override
    public Properties getValidatedConfigurations() {
        Properties asyncProps = new Properties();
        this.validatePositiveIntegerValue(AsyncSinkConnectorOptions.MAX_BATCH_SIZE);
        this.tableOptions.getOptional(AsyncSinkConnectorOptions.MAX_BATCH_SIZE).ifPresent(val -> asyncProps.put(AsyncSinkConnectorOptions.MAX_BATCH_SIZE.key(), val));
        this.validatePositiveLongValue(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE);
        this.tableOptions.getOptional(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE).ifPresent(val -> asyncProps.put(AsyncSinkConnectorOptions.FLUSH_BUFFER_SIZE.key(), val));
        this.validatePositiveIntegerValue(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS);
        this.tableOptions.getOptional(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS).ifPresent(val -> asyncProps.put(AsyncSinkConnectorOptions.MAX_BUFFERED_REQUESTS.key(), val));
        this.validatePositiveIntegerValue(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS);
        this.tableOptions.getOptional(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS).ifPresent(val -> asyncProps.put(AsyncSinkConnectorOptions.MAX_IN_FLIGHT_REQUESTS.key(), val));
        this.validatePositiveLongValue(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT);
        this.tableOptions.getOptional(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT).ifPresent(val -> asyncProps.put(AsyncSinkConnectorOptions.FLUSH_BUFFER_TIMEOUT.key(), val));
        return asyncProps;
    }

    private void validatePositiveIntegerValue(ConfigOption<Integer> option) {
        this.validateOptionValue(option, intVal -> intVal > 0, String.format("Invalid option %s. Must be a positive integer.", option.key()));
    }

    private void validatePositiveLongValue(ConfigOption<Long> option) {
        this.validateOptionValue(option, longVal -> longVal > 0L, String.format("Invalid option %s. Must be a positive integer.", option.key()));
    }

    private <T> void validateOptionValue(ConfigOption<T> option, Predicate<T> valueValidator, String errorMessage) {
        this.tableOptions.getOptional(option).ifPresent(val -> {
            if (!valueValidator.test(val)) {
                throw new IllegalArgumentException(errorMessage);
            }
        });
    }
}

