/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.strategies;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.TypeStrategy;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeFamily;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.types.logical.utils.LogicalTypeMerging;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
class StringConcatTypeStrategy
implements TypeStrategy {
    StringConcatTypeStrategy() {
    }

    @Override
    public Optional<DataType> inferType(CallContext callContext) {
        LogicalType minimumType;
        List<DataType> argumentDataTypes = callContext.getArgumentDataTypes();
        LogicalType type1 = argumentDataTypes.get(0).getLogicalType();
        LogicalType type2 = argumentDataTypes.get(1).getLogicalType();
        int length = LogicalTypeChecks.getLength(type1) + LogicalTypeChecks.getLength(type2);
        if (length < 0) {
            length = Integer.MAX_VALUE;
        }
        if (type1.is(LogicalTypeFamily.CHARACTER_STRING) || type2.is(LogicalTypeFamily.CHARACTER_STRING)) {
            minimumType = new CharType(false, length);
        } else if (type1.is(LogicalTypeFamily.BINARY_STRING) || type2.is(LogicalTypeFamily.BINARY_STRING)) {
            minimumType = new BinaryType(false, length);
        } else {
            return Optional.empty();
        }
        return LogicalTypeMerging.findCommonType(Arrays.asList(type1, type2, minimumType)).map(TypeConversions::fromLogicalToDataType);
    }
}

