/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.Preconditions;

@Internal
public interface SequenceNumber
extends Comparable<SequenceNumber>,
Serializable {
    public SequenceNumber next();

    public static SequenceNumber of(long number) {
        return new GenericSequenceNumber(number);
    }

    public static final class GenericSequenceNumber
    implements SequenceNumber {
        private static final long serialVersionUID = 1L;
        public final long number;

        GenericSequenceNumber(long number) {
            Preconditions.checkArgument(number >= 0L);
            this.number = number;
        }

        @Override
        public int compareTo(SequenceNumber o) {
            Preconditions.checkArgument(o instanceof GenericSequenceNumber);
            return Long.compare(this.number, ((GenericSequenceNumber)o).number);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GenericSequenceNumber)) {
                return false;
            }
            return this.number == ((GenericSequenceNumber)o).number;
        }

        public int hashCode() {
            return Objects.hash(this.number);
        }

        @Override
        public SequenceNumber next() {
            Preconditions.checkState(this.number < Long.MAX_VALUE);
            return SequenceNumber.of(this.number + 1L);
        }

        public String toString() {
            return Long.toString(this.number);
        }
    }
}

