/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.shaded.org.apache.flink.formats.avro;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.avro.shaded.org.apache.avro.generic.GenericFixed;
import org.apache.flink.avro.shaded.org.apache.avro.generic.IndexedRecord;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.JodaConverter;
import org.apache.flink.table.store.shaded.org.apache.flink.formats.avro.typeutils.AvroSchemaConverter;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;

@Internal
public class AvroToRowDataConverters {
    public static AvroToRowDataConverter createRowConverter(RowType rowType) {
        AvroToRowDataConverter[] fieldConverters = (AvroToRowDataConverter[])rowType.getFields().stream().map(RowType.RowField::getType).map(AvroToRowDataConverters::createNullableConverter).toArray(AvroToRowDataConverter[]::new);
        int arity = rowType.getFieldCount();
        return avroObject -> {
            IndexedRecord record = (IndexedRecord)avroObject;
            GenericRowData row = new GenericRowData(arity);
            for (int i = 0; i < arity; ++i) {
                row.setField(i, fieldConverters[i].convert(record.get(i)));
            }
            return row;
        };
    }

    private static AvroToRowDataConverter createNullableConverter(LogicalType type) {
        AvroToRowDataConverter converter = AvroToRowDataConverters.createConverter(type);
        return avroObject -> {
            if (avroObject == null) {
                return null;
            }
            return converter.convert(avroObject);
        };
    }

    private static AvroToRowDataConverter createConverter(LogicalType type) {
        switch (type.getTypeRoot()) {
            case NULL: {
                return avroObject -> null;
            }
            case TINYINT: {
                return avroObject -> ((Integer)avroObject).byteValue();
            }
            case SMALLINT: {
                return avroObject -> ((Integer)avroObject).shortValue();
            }
            case BOOLEAN: 
            case INTEGER: 
            case INTERVAL_YEAR_MONTH: 
            case BIGINT: 
            case INTERVAL_DAY_TIME: 
            case FLOAT: 
            case DOUBLE: {
                return avroObject -> avroObject;
            }
            case DATE: {
                return AvroToRowDataConverters::convertToDate;
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return AvroToRowDataConverters::convertToTime;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return AvroToRowDataConverters::convertToTimestamp;
            }
            case CHAR: 
            case VARCHAR: {
                return avroObject -> StringData.fromString((String)avroObject.toString());
            }
            case BINARY: 
            case VARBINARY: {
                return AvroToRowDataConverters::convertToBytes;
            }
            case DECIMAL: {
                return AvroToRowDataConverters.createDecimalConverter((DecimalType)type);
            }
            case ARRAY: {
                return AvroToRowDataConverters.createArrayConverter((ArrayType)type);
            }
            case ROW: {
                return AvroToRowDataConverters.createRowConverter((RowType)type);
            }
            case MAP: 
            case MULTISET: {
                return AvroToRowDataConverters.createMapConverter(type);
            }
        }
        throw new UnsupportedOperationException("Unsupported type: " + type);
    }

    private static AvroToRowDataConverter createDecimalConverter(DecimalType decimalType) {
        int precision = decimalType.getPrecision();
        int scale = decimalType.getScale();
        return avroObject -> {
            byte[] bytes;
            if (avroObject instanceof GenericFixed) {
                bytes = ((GenericFixed)avroObject).bytes();
            } else if (avroObject instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)avroObject;
                bytes = new byte[byteBuffer.remaining()];
                byteBuffer.get(bytes);
            } else {
                bytes = (byte[])avroObject;
            }
            return DecimalData.fromUnscaledBytes((byte[])bytes, (int)precision, (int)scale);
        };
    }

    private static AvroToRowDataConverter createArrayConverter(ArrayType arrayType) {
        AvroToRowDataConverter elementConverter = AvroToRowDataConverters.createNullableConverter(arrayType.getElementType());
        Class elementClass = LogicalTypeUtils.toInternalConversionClass((LogicalType)arrayType.getElementType());
        return avroObject -> {
            List list = (List)avroObject;
            int length = list.size();
            Object[] array = (Object[])Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                array[i] = elementConverter.convert(list.get(i));
            }
            return new GenericArrayData(array);
        };
    }

    private static AvroToRowDataConverter createMapConverter(LogicalType type) {
        AvroToRowDataConverter keyConverter = AvroToRowDataConverters.createConverter(DataTypes.STRING().getLogicalType());
        AvroToRowDataConverter valueConverter = AvroToRowDataConverters.createNullableConverter(AvroSchemaConverter.extractValueTypeToAvroMap(type));
        return avroObject -> {
            Map map = (Map)avroObject;
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Map.Entry entry : map.entrySet()) {
                Object key = keyConverter.convert(entry.getKey());
                Object value = valueConverter.convert(entry.getValue());
                result.put(key, value);
            }
            return new GenericMapData(result);
        };
    }

    private static TimestampData convertToTimestamp(Object object) {
        long millis;
        if (object instanceof Long) {
            millis = (Long)object;
        } else if (object instanceof Instant) {
            millis = ((Instant)object).toEpochMilli();
        } else {
            JodaConverter jodaConverter = JodaConverter.getConverter();
            if (jodaConverter != null) {
                millis = jodaConverter.convertTimestamp(object);
            } else {
                throw new IllegalArgumentException("Unexpected object type for TIMESTAMP logical type. Received: " + object);
            }
        }
        return TimestampData.fromEpochMillis((long)millis);
    }

    private static int convertToDate(Object object) {
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof LocalDate) {
            return (int)((LocalDate)object).toEpochDay();
        }
        JodaConverter jodaConverter = JodaConverter.getConverter();
        if (jodaConverter != null) {
            return (int)jodaConverter.convertDate(object);
        }
        throw new IllegalArgumentException("Unexpected object type for DATE logical type. Received: " + object);
    }

    private static int convertToTime(Object object) {
        int millis;
        if (object instanceof Integer) {
            millis = (Integer)object;
        } else if (object instanceof LocalTime) {
            millis = ((LocalTime)object).get(ChronoField.MILLI_OF_DAY);
        } else {
            JodaConverter jodaConverter = JodaConverter.getConverter();
            if (jodaConverter != null) {
                millis = jodaConverter.convertTime(object);
            } else {
                throw new IllegalArgumentException("Unexpected object type for TIME logical type. Received: " + object);
            }
        }
        return millis;
    }

    private static byte[] convertToBytes(Object object) {
        if (object instanceof GenericFixed) {
            return ((GenericFixed)object).bytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer byteBuffer = (ByteBuffer)object;
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes);
            return bytes;
        }
        return (byte[])object;
    }

    @FunctionalInterface
    public static interface AvroToRowDataConverter
    extends Serializable {
        public Object convert(Object var1);
    }
}

