/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.format.orc;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.store.format.FieldStats;
import org.apache.flink.table.store.format.FileStatsExtractor;
import org.apache.flink.table.store.format.orc.OrcShimImpl;
import org.apache.flink.table.store.shaded.org.apache.orc.BooleanColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.ColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.DateColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.DecimalColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.DoubleColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.IntegerColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.Reader;
import org.apache.flink.table.store.shaded.org.apache.orc.StringColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.TimestampColumnStatistics;
import org.apache.flink.table.store.shaded.org.apache.orc.TypeDescription;
import org.apache.flink.table.store.utils.DateTimeUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.Preconditions;
import org.apache.hadoop.conf.Configuration;

public class OrcFileStatsExtractor
implements FileStatsExtractor {
    private final RowType rowType;

    public OrcFileStatsExtractor(RowType rowType) {
        this.rowType = rowType;
    }

    public FieldStats[] extract(Path path) throws IOException {
        try (Reader reader = OrcShimImpl.createReader(new Configuration(), path);){
            long rowCount = reader.getNumberOfRows();
            ColumnStatistics[] columnStatistics = reader.getStatistics();
            TypeDescription schema = reader.getSchema();
            List<String> columnNames = schema.getFieldNames();
            List<TypeDescription> columnTypes = schema.getChildren();
            FieldStats[] fieldStatsArray = (FieldStats[])IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> {
                RowType.RowField field = (RowType.RowField)this.rowType.getFields().get(i);
                int fieldIdx = columnNames.indexOf(field.getName());
                int colId = ((TypeDescription)columnTypes.get(fieldIdx)).getId();
                return this.toFieldStats(field, columnStatistics[colId], rowCount);
            }).toArray(FieldStats[]::new);
            return fieldStatsArray;
        }
    }

    private FieldStats toFieldStats(RowType.RowField field, ColumnStatistics stats, long rowCount) {
        long nullCount = rowCount - stats.getNumberOfValues();
        if (nullCount == rowCount) {
            return new FieldStats(null, null, nullCount);
        }
        Preconditions.checkState((nullCount > 0L == stats.hasNull() ? 1 : 0) != 0, (Object)("Bug in OrcFileStatsExtractor: nullCount is " + nullCount + " while stats.hasNull() is " + stats.hasNull() + "!"));
        switch (field.getType().getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                this.assertStatsClass(field, stats, StringColumnStatistics.class);
                StringColumnStatistics stringStats = (StringColumnStatistics)stats;
                return new FieldStats((Object)StringData.fromString((String)stringStats.getMinimum()), (Object)StringData.fromString((String)stringStats.getMaximum()), nullCount);
            }
            case BOOLEAN: {
                this.assertStatsClass(field, stats, BooleanColumnStatistics.class);
                BooleanColumnStatistics boolStats = (BooleanColumnStatistics)stats;
                return new FieldStats((Object)(boolStats.getFalseCount() == 0L ? 1 : 0), (Object)(boolStats.getTrueCount() != 0L ? 1 : 0), nullCount);
            }
            case DECIMAL: {
                this.assertStatsClass(field, stats, DecimalColumnStatistics.class);
                DecimalColumnStatistics decimalStats = (DecimalColumnStatistics)stats;
                DecimalType decimalType = (DecimalType)field.getType();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                return new FieldStats((Object)DecimalData.fromBigDecimal((BigDecimal)decimalStats.getMinimum().bigDecimalValue(), (int)precision, (int)scale), (Object)DecimalData.fromBigDecimal((BigDecimal)decimalStats.getMaximum().bigDecimalValue(), (int)precision, (int)scale), nullCount);
            }
            case TINYINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics byteStats = (IntegerColumnStatistics)stats;
                return new FieldStats((Object)((byte)byteStats.getMinimum()), (Object)((byte)byteStats.getMaximum()), nullCount);
            }
            case SMALLINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics shortStats = (IntegerColumnStatistics)stats;
                return new FieldStats((Object)((short)shortStats.getMinimum()), (Object)((short)shortStats.getMaximum()), nullCount);
            }
            case INTEGER: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics intStats = (IntegerColumnStatistics)stats;
                return new FieldStats((Object)Long.valueOf(intStats.getMinimum()).intValue(), (Object)Long.valueOf(intStats.getMaximum()).intValue(), nullCount);
            }
            case BIGINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics longStats = (IntegerColumnStatistics)stats;
                return new FieldStats((Object)longStats.getMinimum(), (Object)longStats.getMaximum(), nullCount);
            }
            case FLOAT: {
                this.assertStatsClass(field, stats, DoubleColumnStatistics.class);
                DoubleColumnStatistics floatStats = (DoubleColumnStatistics)stats;
                return new FieldStats((Object)Float.valueOf((float)floatStats.getMinimum()), (Object)Float.valueOf((float)floatStats.getMaximum()), nullCount);
            }
            case DOUBLE: {
                this.assertStatsClass(field, stats, DoubleColumnStatistics.class);
                DoubleColumnStatistics doubleStats = (DoubleColumnStatistics)stats;
                return new FieldStats((Object)doubleStats.getMinimum(), (Object)doubleStats.getMaximum(), nullCount);
            }
            case DATE: {
                this.assertStatsClass(field, stats, DateColumnStatistics.class);
                DateColumnStatistics dateStats = (DateColumnStatistics)stats;
                return new FieldStats((Object)DateTimeUtils.toInternal((Date)new Date(dateStats.getMinimum().getTime())), (Object)DateTimeUtils.toInternal((Date)new Date(dateStats.getMaximum().getTime())), nullCount);
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                this.assertStatsClass(field, stats, TimestampColumnStatistics.class);
                TimestampColumnStatistics timestampStats = (TimestampColumnStatistics)stats;
                return new FieldStats((Object)TimestampData.fromTimestamp((Timestamp)timestampStats.getMinimum()), (Object)TimestampData.fromTimestamp((Timestamp)timestampStats.getMaximum()), nullCount);
            }
        }
        return new FieldStats(null, null, nullCount);
    }

    private void assertStatsClass(RowType.RowField field, ColumnStatistics stats, Class<? extends ColumnStatistics> expectedClass) {
        if (!expectedClass.isInstance(stats)) {
            throw new IllegalArgumentException("Expecting " + expectedClass.getName() + " for field " + field.asSummaryString() + " but found " + stats.getClass().getName());
        }
    }
}

