/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.wmassigners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.RowData;
import org.junit.Assert;

public abstract class WatermarkAssignerOperatorTestBase {
    protected Tuple2<Long, Long> validateElement(Object element, long nextElementValue, long currentWatermark) {
        if (element instanceof StreamRecord) {
            StreamRecord record = (StreamRecord)element;
            Assert.assertEquals((long)nextElementValue, (long)((RowData)record.getValue()).getLong(0));
            return new Tuple2((Object)(nextElementValue + 1L), (Object)currentWatermark);
        }
        if (element instanceof Watermark) {
            long wt = ((Watermark)element).getTimestamp();
            TestCase.assertTrue((wt > currentWatermark ? 1 : 0) != 0);
            return new Tuple2((Object)nextElementValue, (Object)wt);
        }
        throw new IllegalArgumentException("unrecognized element: " + element);
    }

    protected List<Watermark> extractWatermarks(Collection<Object> collection) {
        ArrayList<Watermark> watermarks = new ArrayList<Watermark>();
        for (Object obj : collection) {
            if (!(obj instanceof Watermark)) continue;
            watermarks.add((Watermark)obj);
        }
        return watermarks;
    }

    protected List<Object> filterOutRecords(Collection<Object> collection) {
        return collection.stream().filter(obj -> !(obj instanceof StreamElement) || !((StreamElement)obj).isRecord()).collect(Collectors.toList());
    }
}

