/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.slicing;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.shaded.guava30.com.google.common.collect.Lists;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.operators.window.slicing.ClockService;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceSharedAssigner;
import org.hamcrest.Matcher;
import org.junit.Assert;

public abstract class SliceAssignerTestBase {
    private static final ClockService CLOCK_SERVICE = System::currentTimeMillis;
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");

    protected static void assertErrorMessage(Runnable runnable, String errorMessage) {
        try {
            runnable.run();
            Assert.fail((String)"should fail.");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)FlinkMatchers.containsMessage((String)errorMessage));
        }
    }

    protected static long assignSliceEnd(SliceAssigner assigner, long timestamp) {
        return assigner.assignSliceEnd(SliceAssignerTestBase.row(timestamp), CLOCK_SERVICE);
    }

    protected static List<Long> expiredSlices(SliceAssigner assigner, long sliceEnd) {
        return Lists.newArrayList((Iterable)assigner.expiredSlices(sliceEnd));
    }

    protected static Long mergeResultSlice(SliceSharedAssigner assigner, long sliceEnd) throws Exception {
        TestingMergingCallBack callBack = new TestingMergingCallBack();
        assigner.mergeSlices(sliceEnd, (SliceSharedAssigner.MergeCallback)callBack);
        return callBack.mergeResult;
    }

    protected static List<Long> toBeMergedSlices(SliceSharedAssigner assigner, long sliceEnd) throws Exception {
        TestingMergingCallBack callBack = new TestingMergingCallBack();
        assigner.mergeSlices(sliceEnd, (SliceSharedAssigner.MergeCallback)callBack);
        return callBack.toBeMerged;
    }

    protected static RowData row(long timestamp) {
        BinaryRowData binaryRowData = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(binaryRowData);
        writer.writeTimestamp(0, TimestampData.fromEpochMillis((long)timestamp), 3);
        writer.complete();
        return binaryRowData;
    }

    protected static void assertSliceStartEnd(String start, String end, long epochMills, SliceAssigner assigner) {
        Assert.assertEquals((Object)start, (Object)SliceAssignerTestBase.localTimestampStr(assigner.getWindowStart(SliceAssignerTestBase.assignSliceEnd(assigner, epochMills))));
        Assert.assertEquals((Object)end, (Object)SliceAssignerTestBase.localTimestampStr(SliceAssignerTestBase.assignSliceEnd(assigner, epochMills)));
    }

    public static String localTimestampStr(long epochMills) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMills), UTC_ZONE_ID).toString();
    }

    protected long utcMills(String timestampStr) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampStr);
        return localDateTime.atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
    }

    protected long localMills(String timestampStr, ZoneId shiftTimeZone) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampStr);
        return localDateTime.atZone(shiftTimeZone).toInstant().toEpochMilli();
    }

    private static final class TestingMergingCallBack
    implements SliceSharedAssigner.MergeCallback {
        private Long mergeResult;
        private List<Long> toBeMerged;

        private TestingMergingCallBack() {
        }

        public void merge(Long mergeResult, Iterable<Long> toBeMerged) throws Exception {
            this.mergeResult = mergeResult;
            this.toBeMerged = Lists.newArrayList(toBeMerged);
        }
    }
}

