/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.assigners;

import java.time.Duration;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.operators.window.TimeWindow;
import org.apache.flink.table.runtime.operators.window.WindowTestUtils;
import org.apache.flink.table.runtime.operators.window.assigners.CumulativeWindowAssigner;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class CumulativeWindowAssignerTest {
    private static final RowData ELEMENT = GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"String")});
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testWindowAssignment() {
        CumulativeWindowAssigner assigner = CumulativeWindowAssigner.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 0L), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(0L, 1000L), WindowTestUtils.timeWindow(0L, 2000L), WindowTestUtils.timeWindow(0L, 3000L), WindowTestUtils.timeWindow(0L, 4000L), WindowTestUtils.timeWindow(0L, 5000L)}));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 4999L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(0L, 5000L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5000L), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(5000L, 6000L), WindowTestUtils.timeWindow(5000L, 7000L), WindowTestUtils.timeWindow(5000L, 8000L), WindowTestUtils.timeWindow(5000L, 9000L), WindowTestUtils.timeWindow(5000L, 10000L)}));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 0L), (Object)new TimeWindow(0L, 1000L));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 4999L), (Object)new TimeWindow(4000L, 5000L));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 2000L), (Object)new TimeWindow(2000L, 3000L));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 5000L), (Object)new TimeWindow(5000L, 6000L));
        Assert.assertThat((Object)assigner.splitIntoPanes(new TimeWindow(0L, 5000L)), (Matcher)Matchers.contains((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(0L, 1000L), WindowTestUtils.timeWindow(1000L, 2000L), WindowTestUtils.timeWindow(2000L, 3000L), WindowTestUtils.timeWindow(3000L, 4000L), WindowTestUtils.timeWindow(4000L, 5000L)}));
        Assert.assertThat((Object)assigner.splitIntoPanes(new TimeWindow(5000L, 8000L)), (Matcher)Matchers.contains((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(5000L, 6000L), WindowTestUtils.timeWindow(6000L, 7000L), WindowTestUtils.timeWindow(7000L, 8000L)}));
        Assert.assertEquals((Object)assigner.getLastWindow(new TimeWindow(4000L, 5000L)), (Object)new TimeWindow(0L, 5000L));
        Assert.assertEquals((Object)assigner.getLastWindow(new TimeWindow(2000L, 3000L)), (Object)new TimeWindow(0L, 5000L));
        Assert.assertEquals((Object)assigner.getLastWindow(new TimeWindow(7000L, 8000L)), (Object)new TimeWindow(5000L, 10000L));
    }

    @Test
    public void testWindowAssignmentWithOffset() {
        CumulativeWindowAssigner assigner = CumulativeWindowAssigner.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L)).withOffset(Duration.ofMillis(100L));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 100L), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(100L, 1100L), WindowTestUtils.timeWindow(100L, 2100L), WindowTestUtils.timeWindow(100L, 3100L), WindowTestUtils.timeWindow(100L, 4100L), WindowTestUtils.timeWindow(100L, 5100L)}));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5099L), (Matcher)Matchers.contains(WindowTestUtils.timeWindow(100L, 5100L)));
        Assert.assertThat((Object)assigner.assignWindows(ELEMENT, 5100L), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(5100L, 6100L), WindowTestUtils.timeWindow(5100L, 7100L), WindowTestUtils.timeWindow(5100L, 8100L), WindowTestUtils.timeWindow(5100L, 9100L), WindowTestUtils.timeWindow(5100L, 10100L)}));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 100L), (Object)new TimeWindow(100L, 1100L));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 5099L), (Object)new TimeWindow(4100L, 5100L));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 2100L), (Object)new TimeWindow(2100L, 3100L));
        Assert.assertEquals((Object)assigner.assignPane((Object)ELEMENT, 5100L), (Object)new TimeWindow(5100L, 6100L));
        Assert.assertThat((Object)assigner.splitIntoPanes(new TimeWindow(100L, 5100L)), (Matcher)Matchers.contains((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(100L, 1100L), WindowTestUtils.timeWindow(1100L, 2100L), WindowTestUtils.timeWindow(2100L, 3100L), WindowTestUtils.timeWindow(3100L, 4100L), WindowTestUtils.timeWindow(4100L, 5100L)}));
        Assert.assertThat((Object)assigner.splitIntoPanes(new TimeWindow(5100L, 8100L)), (Matcher)Matchers.contains((Matcher[])new Matcher[]{WindowTestUtils.timeWindow(5100L, 6100L), WindowTestUtils.timeWindow(6100L, 7100L), WindowTestUtils.timeWindow(7100L, 8100L)}));
        Assert.assertEquals((Object)assigner.getLastWindow(new TimeWindow(4100L, 5100L)), (Object)new TimeWindow(100L, 5100L));
        Assert.assertEquals((Object)assigner.getLastWindow(new TimeWindow(2100L, 3100L)), (Object)new TimeWindow(100L, 5100L));
        Assert.assertEquals((Object)assigner.getLastWindow(new TimeWindow(7100L, 8100L)), (Object)new TimeWindow(5100L, 10100L));
    }

    @Test
    public void testInvalidParameters1() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("step > 0 and size > 0");
        CumulativeWindowAssigner.of((Duration)Duration.ofSeconds(-2L), (Duration)Duration.ofSeconds(1L));
    }

    @Test
    public void testInvalidParameters2() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("step > 0 and size > 0");
        CumulativeWindowAssigner.of((Duration)Duration.ofSeconds(2L), (Duration)Duration.ofSeconds(-1L));
    }

    @Test
    public void testInvalidParameters3() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("size must be an integral multiple of step.");
        CumulativeWindowAssigner.of((Duration)Duration.ofSeconds(5000L), (Duration)Duration.ofSeconds(2000L));
    }

    @Test
    public void testProperties() {
        CumulativeWindowAssigner assigner = CumulativeWindowAssigner.of((Duration)Duration.ofMillis(5000L), (Duration)Duration.ofMillis(1000L));
        Assert.assertTrue((boolean)assigner.isEventTime());
        Assert.assertEquals((Object)new TimeWindow.Serializer(), (Object)assigner.getWindowSerializer(new ExecutionConfig()));
        Assert.assertTrue((boolean)assigner.withEventTime().isEventTime());
        Assert.assertFalse((boolean)assigner.withProcessingTime().isEventTime());
    }
}

