/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector;

import java.nio.charset.StandardCharsets;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.vector.Dictionary;
import org.apache.flink.table.data.vector.heap.AbstractHeapVector;
import org.apache.flink.table.data.vector.heap.HeapBooleanVector;
import org.apache.flink.table.data.vector.heap.HeapByteVector;
import org.apache.flink.table.data.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.vector.heap.HeapDoubleVector;
import org.apache.flink.table.data.vector.heap.HeapFloatVector;
import org.apache.flink.table.data.vector.heap.HeapIntVector;
import org.apache.flink.table.data.vector.heap.HeapLongVector;
import org.apache.flink.table.data.vector.heap.HeapShortVector;
import org.apache.flink.table.data.vector.heap.HeapTimestampVector;
import org.apache.flink.table.data.vector.writable.WritableColumnVector;
import org.junit.Assert;
import org.junit.Test;

public class ColumnVectorTest {
    private static final int SIZE = 10;

    @Test
    public void testNulls() {
        int i;
        HeapBooleanVector vector = new HeapBooleanVector(10);
        for (i = 0; i < 10; ++i) {
            if (i % 2 != 0) continue;
            vector.setNullAt(i);
        }
        for (i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                Assert.assertTrue((boolean)vector.isNullAt(i));
                continue;
            }
            Assert.assertFalse((boolean)vector.isNullAt(i));
        }
        vector.fillWithNulls();
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)vector.isNullAt(i));
        }
        vector.reset();
        for (i = 0; i < 10; ++i) {
            Assert.assertFalse((boolean)vector.isNullAt(i));
        }
        vector.setNulls(0, 5);
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((boolean)vector.isNullAt(i));
        }
    }

    @Test
    public void testBoolean() {
        int i;
        HeapBooleanVector vector = new HeapBooleanVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setBoolean(i, i % 2 == 0);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)(i % 2 == 0 ? 1 : 0), (Object)vector.getBoolean(i));
        }
        vector.fill(true);
        for (i = 0; i < 10; ++i) {
            Assert.assertTrue((boolean)vector.getBoolean(i));
        }
    }

    @Test
    public void testByte() {
        int i;
        HeapByteVector vector = new HeapByteVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setByte(i, (byte)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getByte(i));
        }
        vector.fill((byte)22);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)22L, (long)vector.getByte(i));
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getByte(i));
        }
    }

    @Test
    public void testShort() {
        int i;
        HeapShortVector vector = new HeapShortVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setShort(i, (short)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getShort(i));
        }
        vector.fill((short)22);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)22L, (long)vector.getShort(i));
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getShort(i));
        }
    }

    @Test
    public void testInt() {
        int i;
        HeapIntVector vector = new HeapIntVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setInt(i, i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getInt(i));
        }
        vector.fill(22);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)22L, (long)vector.getInt(i));
        }
        vector = new HeapIntVector(10);
        vector.setInts(0, 10, 22);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)22L, (long)vector.getInt(i));
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getInt(i));
        }
        int[] ints = IntStream.range(0, 10).toArray();
        byte[] binary = new byte[80];
        AbstractHeapVector.UNSAFE.copyMemory(ints, AbstractHeapVector.INT_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapIntVector(10);
        vector.setIntsFromBinary(0, 10, binary, 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((long)i2, (long)vector.getInt(i2));
        }
    }

    @Test
    public void testLong() {
        int i;
        HeapLongVector vector = new HeapLongVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setLong(i, (long)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getLong(i));
        }
        vector.fill(22L);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)22L, (long)vector.getLong(i));
        }
        vector.setDictionary((Dictionary)new TestDictionary(LongStream.range(0L, 10L).boxed().toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((long)i, (long)vector.getLong(i));
        }
        long[] longs = LongStream.range(0L, 10L).toArray();
        byte[] binary = new byte[80];
        AbstractHeapVector.UNSAFE.copyMemory(longs, AbstractHeapVector.LONG_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapLongVector(10);
        vector.setLongsFromBinary(0, 10, binary, 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((long)i2, (long)vector.getLong(i2));
        }
    }

    @Test
    public void testFloat() {
        int i;
        HeapFloatVector vector = new HeapFloatVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setFloat(i, (float)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((float)i, (float)vector.getFloat(i), (float)0.0f);
        }
        vector.fill(22.0f);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((float)22.0f, (float)vector.getFloat(i), (float)0.0f);
        }
        vector.setDictionary((Dictionary)new TestDictionary(LongStream.range(0L, 10L).boxed().map(Number::floatValue).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((float)i, (float)vector.getFloat(i), (float)0.0f);
        }
        float[] floats = new float[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            floats[i2] = i2;
        }
        byte[] binary = new byte[40];
        AbstractHeapVector.UNSAFE.copyMemory(floats, AbstractHeapVector.FLOAT_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapFloatVector(10);
        vector.setFloatsFromBinary(0, 10, binary, 0);
        for (int i3 = 0; i3 < 10; ++i3) {
            Assert.assertEquals((float)i3, (float)vector.getFloat(i3), (float)0.0f);
        }
    }

    @Test
    public void testDouble() {
        int i;
        HeapDoubleVector vector = new HeapDoubleVector(10);
        for (i = 0; i < 10; ++i) {
            vector.setDouble(i, (double)i);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)i, (double)vector.getDouble(i), (double)0.0);
        }
        vector.fill(22.0);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)22.0, (double)vector.getDouble(i), (double)0.0);
        }
        vector.setDictionary((Dictionary)new TestDictionary(LongStream.range(0L, 10L).boxed().map(Number::doubleValue).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertEquals((double)i, (double)vector.getDouble(i), (double)0.0);
        }
        double[] doubles = LongStream.range(0L, 10L).boxed().mapToDouble(Number::doubleValue).toArray();
        byte[] binary = new byte[80];
        AbstractHeapVector.UNSAFE.copyMemory(doubles, AbstractHeapVector.DOUBLE_ARRAY_OFFSET, binary, AbstractHeapVector.BYTE_ARRAY_OFFSET, binary.length);
        vector = new HeapDoubleVector(10);
        vector.setDoublesFromBinary(0, 10, binary, 0);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((double)i2, (double)vector.getDouble(i2), (double)0.0);
        }
    }

    private byte[] produceBytes(int i) {
        return (i + "").getBytes(StandardCharsets.UTF_8);
    }

    @Test
    public void testBytes() {
        byte[] bytes;
        int i;
        HeapBytesVector vector = new HeapBytesVector(10);
        for (i = 0; i < 10; ++i) {
            bytes = this.produceBytes(i);
            vector.appendBytes(i, bytes, 0, bytes.length);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])this.produceBytes(i), (byte[])vector.getBytes(i).getBytes());
        }
        vector.reset();
        for (i = 0; i < 10; ++i) {
            bytes = this.produceBytes(i);
            vector.appendBytes(i, bytes, 0, bytes.length);
        }
        for (i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])this.produceBytes(i), (byte[])vector.getBytes(i).getBytes());
        }
        vector.fill(this.produceBytes(22));
        for (i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])this.produceBytes(22), (byte[])vector.getBytes(i).getBytes());
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).mapToObj(this::produceBytes).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i = 0; i < 10; ++i) {
            Assert.assertArrayEquals((byte[])this.produceBytes(i), (byte[])vector.getBytes(i).getBytes());
        }
    }

    @Test
    public void testTimestamp() {
        int i2;
        HeapTimestampVector vector = new HeapTimestampVector(10);
        for (i2 = 0; i2 < 10; ++i2) {
            vector.setTimestamp(i2, TimestampData.fromEpochMillis((long)i2, (int)i2));
        }
        for (i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((Object)TimestampData.fromEpochMillis((long)i2, (int)i2), (Object)vector.getTimestamp(i2, 9));
        }
        vector.fill(TimestampData.fromEpochMillis((long)22L, (int)22));
        for (i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((Object)TimestampData.fromEpochMillis((long)22L, (int)22), (Object)vector.getTimestamp(i2, 9));
        }
        vector.setDictionary((Dictionary)new TestDictionary(IntStream.range(0, 10).mapToObj(i -> TimestampData.fromEpochMillis((long)i, (int)i)).toArray()));
        this.setRangeDictIds((WritableColumnVector)vector);
        for (i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((Object)TimestampData.fromEpochMillis((long)i2, (int)i2), (Object)vector.getTimestamp(i2, 9));
        }
    }

    @Test
    public void testReserveDictIds() {
        HeapIntVector vector = new HeapIntVector(10);
        Assert.assertTrue((vector.reserveDictionaryIds((int)2).vector.length >= 2 ? 1 : 0) != 0);
        Assert.assertTrue((vector.reserveDictionaryIds((int)5).vector.length >= 5 ? 1 : 0) != 0);
        Assert.assertTrue((vector.reserveDictionaryIds((int)2).vector.length >= 2 ? 1 : 0) != 0);
    }

    private void setRangeDictIds(WritableColumnVector vector) {
        vector.reserveDictionaryIds(10).setInts(0, 10, IntStream.range(0, 10).toArray(), 0);
    }

    static final class TestDictionary
    implements Dictionary {
        private Object[] intDictionary;

        TestDictionary(Object[] dictionary) {
            this.intDictionary = dictionary;
        }

        public int decodeToInt(int id) {
            return (Integer)this.intDictionary[id];
        }

        public long decodeToLong(int id) {
            return (Long)this.intDictionary[id];
        }

        public float decodeToFloat(int id) {
            return ((Float)this.intDictionary[id]).floatValue();
        }

        public double decodeToDouble(int id) {
            return (Double)this.intDictionary[id];
        }

        public byte[] decodeToBinary(int id) {
            return (byte[])this.intDictionary[id];
        }

        public TimestampData decodeToTimestamp(int id) {
            return (TimestampData)this.intDictionary[id];
        }
    }
}

