/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.LocalTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.PrimitiveArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.SqlTimeTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.MapTypeInfo;
import org.apache.flink.api.java.typeutils.ObjectArrayTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalDataUtils;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.runtime.functions.SqlDateTimeUtils;
import org.apache.flink.table.runtime.typeutils.DecimalDataTypeInfo;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.typeutils.LegacyTimestampTypeInfo;
import org.apache.flink.table.runtime.typeutils.StringDataTypeInfo;
import org.apache.flink.table.types.AtomicDataType;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;
import org.apache.flink.types.RowKind;
import org.junit.Assert;
import org.junit.Test;

public class DataFormatConvertersTest {
    private TypeInformation[] simpleTypes = new TypeInformation[]{BasicTypeInfo.STRING_TYPE_INFO, BasicTypeInfo.BOOLEAN_TYPE_INFO, BasicTypeInfo.INT_TYPE_INFO, BasicTypeInfo.LONG_TYPE_INFO, BasicTypeInfo.FLOAT_TYPE_INFO, BasicTypeInfo.DOUBLE_TYPE_INFO, BasicTypeInfo.SHORT_TYPE_INFO, BasicTypeInfo.BYTE_TYPE_INFO, BasicTypeInfo.CHAR_TYPE_INFO, PrimitiveArrayTypeInfo.BOOLEAN_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.INT_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.LONG_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.FLOAT_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.DOUBLE_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.SHORT_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.BYTE_PRIMITIVE_ARRAY_TYPE_INFO, PrimitiveArrayTypeInfo.CHAR_PRIMITIVE_ARRAY_TYPE_INFO, LocalTimeTypeInfo.LOCAL_DATE, LocalTimeTypeInfo.LOCAL_TIME, LocalTimeTypeInfo.LOCAL_DATE_TIME, StringDataTypeInfo.INSTANCE};
    private Object[] simpleValues = new Object[]{"haha", true, 22, 1111L, Float.valueOf(0.5f), 0.5, (short)1, (byte)1, Character.valueOf('\u0001'), new boolean[]{true, false}, new int[]{5, 1}, new long[]{5L, 1L}, new float[]{5.0f, 1.0f}, new double[]{5.0, 1.0}, new short[]{5, 1}, new byte[]{5, 1}, new char[]{'\u0005', '\u0001'}, SqlDateTimeUtils.unixDateToLocalDate((int)5), SqlDateTimeUtils.unixTimeToLocalTime((int)11), SqlDateTimeUtils.unixTimestampToLocalDateTime((long)11L), StringData.fromString((String)"hahah")};
    private DataType[] dataTypes = new DataType[]{(DataType)DataTypes.TIMESTAMP((int)9).bridgedTo(LocalDateTime.class), (DataType)DataTypes.TIMESTAMP((int)9).bridgedTo(Timestamp.class), DataTypes.TIMESTAMP((int)3), (DataType)DataTypes.TIMESTAMP_LTZ((int)3).bridgedTo(Timestamp.class), (DataType)DataTypes.TIMESTAMP_LTZ((int)9).bridgedTo(Timestamp.class), new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, (TypeInformation)SqlTimeTypeInfo.TIMESTAMP)), new AtomicDataType((LogicalType)new LegacyTypeInformationType(LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE, (TypeInformation)new LegacyTimestampTypeInfo(7))), (DataType)DataTypes.TIMESTAMP((int)3).bridgedTo(TimestampData.class)};
    private Object[] dataValues = new Object[]{LocalDateTime.of(1970, 1, 1, 0, 0, 0, 123456789), Timestamp.valueOf("1970-01-01 00:00:00.123456789"), LocalDateTime.of(1970, 1, 1, 0, 0, 0, 123), DataFormatConvertersTest.buildTimestamp(4000L, 123), DataFormatConvertersTest.buildTimestamp(4000L, 123456789), Timestamp.valueOf("1970-01-01 00:00:00.123"), Timestamp.valueOf("1970-01-01 00:00:00.1234567"), TimestampData.fromEpochMillis((long)1000L)};

    private static Timestamp buildTimestamp(long mills, int nanos) {
        Timestamp ts = new Timestamp(mills);
        ts.setNanos(nanos);
        return ts;
    }

    private static DataFormatConverters.DataFormatConverter getConverter(TypeInformation typeInfo) {
        return DataFormatConverters.getConverterForDataType((DataType)TypeConversions.fromLegacyInfoToDataType((TypeInformation)typeInfo));
    }

    private static void test(TypeInformation typeInfo, Object value) {
        DataFormatConvertersTest.test(typeInfo, value, null);
    }

    private static void test(TypeInformation typeInfo, Object value, Object anotherValue) {
        DataFormatConverters.DataFormatConverter converter = DataFormatConvertersTest.getConverter(typeInfo);
        Object innerValue = converter.toInternal(value);
        if (anotherValue != null) {
            converter.toInternal(anotherValue);
        }
        Assert.assertTrue((boolean)Arrays.deepEquals(new Object[]{converter.toExternal(innerValue)}, new Object[]{value}));
    }

    private static DataFormatConverters.DataFormatConverter getConverter(DataType dataType) {
        return DataFormatConverters.getConverterForDataType((DataType)dataType);
    }

    private static void testDataType(DataType dataType, Object value) {
        DataFormatConverters.DataFormatConverter converter = DataFormatConvertersTest.getConverter(dataType);
        Assert.assertTrue((boolean)Arrays.deepEquals(new Object[]{converter.toExternal(converter.toInternal(value))}, new Object[]{value}));
    }

    @Test
    public void testTypes() {
        for (int i = 0; i < this.simpleTypes.length; ++i) {
            DataFormatConvertersTest.test(this.simpleTypes[i], this.simpleValues[i]);
        }
        DataFormatConvertersTest.test((TypeInformation)new RowTypeInfo(this.simpleTypes), new Row(this.simpleTypes.length));
        DataFormatConvertersTest.test((TypeInformation)new RowTypeInfo(this.simpleTypes), Row.ofKind((RowKind)RowKind.DELETE, (Object[])this.simpleValues));
        DataFormatConvertersTest.test((TypeInformation)InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType()}), GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"hehe"), 111}));
        DataFormatConvertersTest.test((TypeInformation)InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType()}), GenericRowData.of((Object[])new Object[]{null, null}));
        DataFormatConvertersTest.test((TypeInformation)new DecimalDataTypeInfo(10, 5), null);
        DataFormatConvertersTest.test((TypeInformation)new DecimalDataTypeInfo(10, 5), DecimalDataUtils.castFrom((double)5.555, (int)10, (int)5));
        DataFormatConvertersTest.test(Types.BIG_DEC, null);
        DataFormatConverters.DataFormatConverter converter = DataFormatConvertersTest.getConverter(Types.BIG_DEC);
        Assert.assertTrue((boolean)Arrays.deepEquals(new Object[]{converter.toInternal(converter.toExternal((Object)DecimalDataUtils.castFrom((long)5L, (int)19, (int)18)))}, new Object[]{DecimalDataUtils.castFrom((long)5L, (int)19, (int)18)}));
        DataFormatConvertersTest.test((TypeInformation)new ListTypeInfo(Types.STRING), null);
        DataFormatConvertersTest.test((TypeInformation)new ListTypeInfo(Types.STRING), Arrays.asList("ahah", "xx"));
        DataFormatConvertersTest.test((TypeInformation)BasicArrayTypeInfo.DOUBLE_ARRAY_TYPE_INFO, new Double[]{1.0, 5.0});
        DataFormatConvertersTest.test((TypeInformation)BasicArrayTypeInfo.DOUBLE_ARRAY_TYPE_INFO, new Double[]{null, null});
        DataFormatConvertersTest.test((TypeInformation)ObjectArrayTypeInfo.getInfoFor((TypeInformation)Types.STRING), new String[]{null, null});
        DataFormatConvertersTest.test((TypeInformation)ObjectArrayTypeInfo.getInfoFor((TypeInformation)Types.STRING), new String[]{"haha", "hehe"});
        DataFormatConvertersTest.test((TypeInformation)ObjectArrayTypeInfo.getInfoFor((TypeInformation)Types.STRING), new String[]{"haha", "hehe"}, new String[]{"aa", "bb"});
        DataFormatConvertersTest.test((TypeInformation)new MapTypeInfo(Types.STRING, Types.INT), null);
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("haha", 1);
        map.put("hah1", 5);
        map.put(null, null);
        DataFormatConvertersTest.test((TypeInformation)new MapTypeInfo(Types.STRING, Types.INT), map);
        Tuple2 tuple2 = new Tuple2((Object)5, (Object)10);
        TupleTypeInfo tupleTypeInfo = new TupleTypeInfo(tuple2.getClass(), new TypeInformation[]{Types.INT, Types.INT});
        DataFormatConvertersTest.test((TypeInformation)tupleTypeInfo, tuple2);
        DataFormatConvertersTest.test(TypeExtractor.createTypeInfo(MyPojo.class), new MyPojo(1, 3));
    }

    @Test
    public void testDataTypes() {
        for (int i = 0; i < this.dataTypes.length; ++i) {
            DataFormatConvertersTest.testDataType(this.dataTypes[i], this.dataValues[i]);
        }
    }

    public static class MyPojo {
        public int f1 = 0;
        public int f2 = 0;

        public MyPojo() {
        }

        public MyPojo(int f1, int f2) {
            this.f1 = f1;
            this.f2 = f2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyPojo myPojo = (MyPojo)o;
            return this.f1 == myPojo.f1 && this.f2 == myPojo.f2;
        }
    }
}

