/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.lang.reflect.Proxy;
import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.ColumnarArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.testutils.DeeplyEqualsChecker;

public class ArrayDataSerializerTest
extends SerializerTestBase<ArrayData> {
    public ArrayDataSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof ArrayData && o2 instanceof ArrayData, (o1, o2, checker) -> {
            ArrayData array1 = (ArrayData)o1;
            ArrayData array2 = (ArrayData)o2;
            if (array1.size() != array2.size()) {
                return false;
            }
            for (int i = 0; i < array1.size(); ++i) {
                if (array1.isNullAt(i) && array2.isNullAt(i)) continue;
                if (array1.isNullAt(i) || array2.isNullAt(i)) {
                    return false;
                }
                if (array1.getString(i).equals(array2.getString(i))) continue;
                return false;
            }
            return true;
        }));
    }

    protected ArrayDataSerializer createSerializer() {
        return new ArrayDataSerializer(DataTypes.STRING().getLogicalType());
    }

    protected int getLength() {
        return -1;
    }

    protected Class<ArrayData> getTypeClass() {
        return ArrayData.class;
    }

    protected ArrayData[] getTestData() {
        return new ArrayData[]{new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"11"), null, StringData.fromString((String)"ke")}), ArrayDataSerializerTest.createArray("11", "haa"), ArrayDataSerializerTest.createArray("11", "haa", "ke"), ArrayDataSerializerTest.createArray("11", "haa", "ke"), ArrayDataSerializerTest.createArray("11", "lele", "haa", "ke"), ArrayDataSerializerTest.createColumnarArray("11", "lele", "haa", "ke"), ArrayDataSerializerTest.createCustomTypeArray("11", "lele", "haa", "ke")};
    }

    static BinaryArrayData createArray(String ... vs) {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, vs.length, 8);
        for (int i = 0; i < vs.length; ++i) {
            writer.writeString(i, StringData.fromString((String)vs[i]));
        }
        writer.complete();
        return array;
    }

    private static ColumnarArrayData createColumnarArray(String ... vs) {
        HeapBytesVector vector = new HeapBytesVector(vs.length);
        for (String v : vs) {
            vector.fill(v.getBytes(StandardCharsets.UTF_8));
        }
        return new ColumnarArrayData((ColumnVector)vector, 0, vs.length);
    }

    static ArrayData createCustomTypeArray(String ... vs) {
        BinaryArrayData binaryArrayData = ArrayDataSerializerTest.createArray(vs);
        Object customArrayData = Proxy.newProxyInstance(ArrayDataSerializerTest.class.getClassLoader(), new Class[]{ArrayData.class}, (proxy, method, args) -> method.invoke((Object)binaryArrayData, args));
        return (ArrayData)customArrayData;
    }
}

