/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.input;

import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputTestBase;
import org.apache.flink.table.runtime.operators.multipleinput.TestingOneInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.TestingTwoInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.input.FirstInputOfTwoInput;
import org.apache.flink.table.runtime.operators.multipleinput.input.OneInput;
import org.apache.flink.table.runtime.operators.multipleinput.input.SecondInputOfTwoInput;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InputTest
extends MultipleInputTestBase {
    private StreamRecord<RowData> element;
    private Watermark watermark;
    private LatencyMarker latencyMarker;

    @Before
    public void setup() {
        this.element = new StreamRecord((Object)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"123")}), 456L);
        this.watermark = new Watermark(1223456789L);
        this.latencyMarker = new LatencyMarker(122345678L, new OperatorID(123L, 456L), 1);
    }

    @Test
    public void testOneInput() throws Exception {
        TestingOneInputStreamOperator op = this.createOneInputStreamOperator();
        OneInput input = new OneInput((OneInputStreamOperator)op);
        input.processElement(this.element);
        Assert.assertEquals(this.element, op.getCurrentElement());
        input.processWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op.getCurrentWatermark());
        input.processLatencyMarker(this.latencyMarker);
        Assert.assertEquals((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker());
    }

    @Test
    public void testFirstInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        FirstInputOfTwoInput input = new FirstInputOfTwoInput((TwoInputStreamOperator)op);
        input.processElement(this.element);
        Assert.assertEquals(this.element, op.getCurrentElement1());
        Assert.assertNull(op.getCurrentElement2());
        input.processWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op.getCurrentWatermark1());
        Assert.assertNull((Object)op.getCurrentWatermark2());
        input.processLatencyMarker(this.latencyMarker);
        Assert.assertEquals((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker1());
        Assert.assertNull((Object)op.getCurrentLatencyMarker2());
    }

    @Test
    public void testSecondInputOfTwoInput() throws Exception {
        TestingTwoInputStreamOperator op = this.createTwoInputStreamOperator();
        SecondInputOfTwoInput input = new SecondInputOfTwoInput((TwoInputStreamOperator)op);
        input.processElement(this.element);
        Assert.assertEquals(this.element, op.getCurrentElement2());
        Assert.assertNull(op.getCurrentElement1());
        input.processWatermark(this.watermark);
        Assert.assertEquals((Object)this.watermark, (Object)op.getCurrentWatermark2());
        Assert.assertNull((Object)op.getCurrentWatermark1());
        input.processLatencyMarker(this.latencyMarker);
        Assert.assertEquals((Object)this.latencyMarker, (Object)op.getCurrentLatencyMarker2());
        Assert.assertNull((Object)op.getCurrentLatencyMarker1());
    }
}

