/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput.input;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.api.operators.InputSelection;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputTestBase;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSelectionHandler;
import org.apache.flink.table.runtime.operators.multipleinput.input.InputSpec;
import org.junit.Assert;
import org.junit.Test;

public class InputSelectionHandlerTest
extends MultipleInputTestBase {
    @Test
    public void testWithSamePriority() {
        List<InputSpec> inputSpecs = Arrays.asList(new InputSpec(1, 0, this.createOneInputOperatorWrapper("input1"), 1), new InputSpec(2, 0, this.createOneInputOperatorWrapper("input2"), 2), new InputSpec(3, 0, this.createTwoInputOperatorWrapper("input3"), 1), new InputSpec(4, 0, this.createTwoInputOperatorWrapper("input4"), 2), new InputSpec(5, 0, this.createOneInputOperatorWrapper("input5"), 1));
        InputSelectionHandler handler = new InputSelectionHandler(inputSpecs);
        Assert.assertEquals((Object)InputSelection.ALL, (Object)handler.getInputSelection());
        List<Integer> inputIds = Arrays.asList(1, 2, 3, 4, 5);
        Collections.shuffle(inputIds);
        for (int inputId : inputIds) {
            handler.endInput(inputId);
            Assert.assertEquals((Object)InputSelection.ALL, (Object)handler.getInputSelection());
        }
    }

    @Test
    public void testWithDifferentPriority() {
        List<InputSpec> inputSpecs = Arrays.asList(new InputSpec(1, 1, this.createOneInputOperatorWrapper("input1"), 1), new InputSpec(2, 1, this.createOneInputOperatorWrapper("input2"), 2), new InputSpec(3, 0, this.createTwoInputOperatorWrapper("input3"), 1), new InputSpec(4, 0, this.createTwoInputOperatorWrapper("input4"), 2), new InputSpec(5, 2, this.createOneInputOperatorWrapper("input5"), 1));
        InputSelectionHandler handler = new InputSelectionHandler(inputSpecs);
        Assert.assertEquals((Object)new InputSelection.Builder().select(3).select(4).build(5), (Object)handler.getInputSelection());
        handler.endInput(3);
        Assert.assertEquals((Object)new InputSelection.Builder().select(3).select(4).build(5), (Object)handler.getInputSelection());
        handler.endInput(4);
        Assert.assertEquals((Object)new InputSelection.Builder().select(1).select(2).build(5), (Object)handler.getInputSelection());
        handler.endInput(2);
        Assert.assertEquals((Object)new InputSelection.Builder().select(1).select(2).build(5), (Object)handler.getInputSelection());
        handler.endInput(1);
        Assert.assertEquals((Object)new InputSelection.Builder().select(5).build(5), (Object)handler.getInputSelection());
        handler.endInput(5);
        Assert.assertEquals((Object)InputSelection.ALL, (Object)handler.getInputSelection());
    }
}

