/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.io;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.runtime.io.compression.BlockCompressionFactory;
import org.apache.flink.runtime.io.compression.Lz4BlockCompressionFactory;
import org.apache.flink.runtime.io.disk.iomanager.BufferFileWriter;
import org.apache.flink.runtime.io.disk.iomanager.FileIOChannel;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelReaderInputView;
import org.apache.flink.table.runtime.io.CompressedHeaderlessChannelWriterOutputView;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class CompressedHeaderlessChannelTest {
    private static final int BUFFER_SIZE = 256;
    private IOManager ioManager;
    private BlockCompressionFactory compressionFactory = new Lz4BlockCompressionFactory();

    public CompressedHeaderlessChannelTest() {
        this.ioManager = new IOManagerAsync();
    }

    @After
    public void afterTest() throws Exception {
        this.ioManager.close();
    }

    @Test
    public void testCompressedView() throws IOException {
        for (int testTime = 0; testTime < 10; ++testTime) {
            int testRounds = new Random().nextInt(20000);
            FileIOChannel.ID channel = this.ioManager.createChannel();
            BufferFileWriter writer = this.ioManager.createBufferFileWriter(channel);
            CompressedHeaderlessChannelWriterOutputView outputView = new CompressedHeaderlessChannelWriterOutputView(writer, this.compressionFactory, 256);
            for (int i = 0; i < testRounds; ++i) {
                outputView.writeInt(i);
            }
            outputView.close();
            int blockCount = outputView.getBlockCount();
            CompressedHeaderlessChannelReaderInputView inputView = new CompressedHeaderlessChannelReaderInputView(channel, this.ioManager, this.compressionFactory, 256, blockCount);
            for (int i = 0; i < testRounds; ++i) {
                Assert.assertEquals((long)i, (long)inputView.readInt());
            }
            inputView.close();
        }
    }
}

