/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.util.List;
import org.apache.flink.api.common.serialization.Encoder;
import org.apache.flink.api.common.serialization.SimpleStringEncoder;
import org.apache.flink.core.fs.Path;
import org.apache.flink.streaming.api.functions.sink.filesystem.StreamingFileSink;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.filesystem.stream.compact.AbstractCompactTestBase;
import org.apache.flink.table.filesystem.stream.compact.CompactFileWriter;
import org.apache.flink.table.filesystem.stream.compact.CompactMessages;
import org.junit.Assert;
import org.junit.Test;

public class CompactFileWriterTest
extends AbstractCompactTestBase {
    @Test
    public void testEmitEndCheckpointAfterEndInput() throws Exception {
        CompactFileWriter compactFileWriter = new CompactFileWriter(1000L, (StreamingFileSink.BucketsBuilder)StreamingFileSink.forRowFormat((Path)this.folder, (Encoder)new SimpleStringEncoder()));
        try (OneInputStreamOperatorTestHarness harness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)compactFileWriter);){
            harness.setup();
            harness.open();
            harness.processElement((Object)CompactFileWriterTest.row("test"), 0L);
            harness.snapshot(1L, 1L);
            harness.notifyOfCompletedCheckpoint(1L);
            List coordinatorInputs = harness.extractOutputValues();
            Assert.assertEquals((long)2L, (long)coordinatorInputs.size());
            Assert.assertTrue((boolean)(coordinatorInputs.get(0) instanceof CompactMessages.InputFile));
            Assert.assertEquals((long)1L, (long)((CompactMessages.EndCheckpoint)coordinatorInputs.get(1)).getCheckpointId());
            harness.processElement((Object)CompactFileWriterTest.row("test1"), 0L);
            harness.processElement((Object)CompactFileWriterTest.row("test2"), 0L);
            harness.getOutput().clear();
            harness.endInput();
            coordinatorInputs = harness.extractOutputValues();
            CompactMessages.EndCheckpoint endCheckpoint = (CompactMessages.EndCheckpoint)coordinatorInputs.get(coordinatorInputs.size() - 1);
            Assert.assertEquals((long)Long.MAX_VALUE, (long)endCheckpoint.getCheckpointId());
        }
    }

    private static RowData row(String s) {
        return GenericRowData.of((Object[])new Object[]{StringData.fromString((String)s)});
    }
}

