/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.api.common.io.FileInputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.io.RowCsvInputFormat;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.fs.FileInputSplit;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.utils.PartitionPathUtils;
import org.apache.flink.types.Row;

public class TestRowDataCsvInputFormat
extends FileInputFormat<RowData> {
    private final List<String> partitionKeys;
    private final String defaultPartValue;
    private final int[] selectFields;
    private final long limit;
    private final RowCsvInputFormat inputFormat;
    private final List<DataType> fieldTypes;
    private final List<String> fieldNames;
    private final List<DataFormatConverters.DataFormatConverter> csvSelectConverters;
    private final int[] csvFieldMapping;
    private transient Row csvRow;
    private transient GenericRowData row;
    private transient long emitted;

    public TestRowDataCsvInputFormat(Path[] paths, TableSchema schema, List<String> partitionKeys, String defaultPartValue, int[] selectFields, long limit) {
        this.partitionKeys = partitionKeys;
        this.defaultPartValue = defaultPartValue;
        this.selectFields = selectFields;
        this.limit = limit;
        this.fieldTypes = Arrays.asList(schema.getFieldDataTypes());
        this.fieldNames = Arrays.asList(schema.getFieldNames());
        List csvFieldNames = this.fieldNames.stream().filter(name -> !partitionKeys.contains(name)).collect(Collectors.toList());
        List selectFieldNames = Arrays.stream(selectFields).mapToObj(this.fieldNames::get).collect(Collectors.toList());
        List csvSelectFieldNames = selectFieldNames.stream().filter(name -> !partitionKeys.contains(name)).collect(Collectors.toList());
        List csvSelectTypes = csvSelectFieldNames.stream().map(name -> this.fieldTypes.get(this.fieldNames.indexOf(name))).collect(Collectors.toList());
        RowTypeInfo rowType = (RowTypeInfo)schema.toRowType();
        TypeInformation[] fieldTypeInfos = rowType.getFieldTypes();
        TypeInformation[] csvSelectTypeInfos = (TypeInformation[])csvSelectFieldNames.stream().map(name -> fieldTypeInfos[this.fieldNames.indexOf(name)]).toArray(TypeInformation[]::new);
        this.csvSelectConverters = csvSelectTypes.stream().map(DataFormatConverters::getConverterForDataType).collect(Collectors.toList());
        int[] csvSelectFields = csvSelectFieldNames.stream().mapToInt(csvFieldNames::indexOf).toArray();
        this.inputFormat = new RowCsvInputFormat(null, csvSelectTypeInfos, csvSelectFields);
        this.inputFormat.setFilePaths(paths);
        this.csvFieldMapping = csvSelectFieldNames.stream().mapToInt(selectFieldNames::indexOf).toArray();
        this.emitted = 0L;
    }

    public void configure(Configuration parameters) {
        this.inputFormat.configure(parameters);
    }

    public FileInputSplit[] createInputSplits(int minNumSplits) throws IOException {
        return this.inputFormat.createInputSplits(minNumSplits);
    }

    public void open(FileInputSplit split) throws IOException {
        this.inputFormat.open(split);
        Path path = split.getPath();
        LinkedHashMap partSpec = PartitionPathUtils.extractPartitionSpecFromPath((Path)path);
        this.row = new GenericRowData(this.selectFields.length);
        for (int i = 0; i < this.selectFields.length; ++i) {
            int selectField = this.selectFields[i];
            String name = this.fieldNames.get(selectField);
            if (!this.partitionKeys.contains(name)) continue;
            String value = (String)partSpec.get(name);
            value = this.defaultPartValue.equals(value) ? null : value;
            this.row.setField(i, this.convertStringToInternal(value, this.fieldTypes.get(selectField)));
        }
        this.csvRow = new Row(this.csvSelectConverters.size());
    }

    private Object convertStringToInternal(String value, DataType dataType) {
        LogicalType logicalType = dataType.getLogicalType();
        if (LogicalTypeChecks.hasRoot((LogicalType)logicalType, (LogicalTypeRoot)LogicalTypeRoot.INTEGER)) {
            return Integer.parseInt(value);
        }
        if (LogicalTypeChecks.hasRoot((LogicalType)logicalType, (LogicalTypeRoot)LogicalTypeRoot.BIGINT)) {
            return Long.parseLong(value);
        }
        if (LogicalTypeChecks.hasRoot((LogicalType)logicalType, (LogicalTypeRoot)LogicalTypeRoot.CHAR) || LogicalTypeChecks.hasRoot((LogicalType)logicalType, (LogicalTypeRoot)LogicalTypeRoot.VARCHAR)) {
            return StringData.fromString((String)value);
        }
        throw new UnsupportedOperationException("Unsupported partition type: " + logicalType.getTypeRoot().name());
    }

    public boolean reachedEnd() {
        return this.emitted >= this.limit || this.inputFormat.reachedEnd();
    }

    public RowData nextRecord(RowData reuse) throws IOException {
        Row csvRow = (Row)this.inputFormat.nextRecord((Object)this.csvRow);
        if (csvRow == null) {
            return null;
        }
        for (int i = 0; i < this.csvSelectConverters.size(); ++i) {
            this.row.setField(this.csvFieldMapping[i], this.csvSelectConverters.get(i).toInternal(csvRow.getField(i)));
        }
        ++this.emitted;
        return this.row;
    }

    public void close() throws IOException {
        this.inputFormat.close();
    }
}

