/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.impl.StreamFormatAdapter;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.reader.StreamFormat;
import org.apache.flink.connector.file.src.reader.TextLineFormat;
import org.apache.flink.connector.file.src.util.Utils;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.filesystem.LimitableBulkFormat;
import org.apache.flink.util.FileUtils;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class LimitableBulkFormatTest {
    @ClassRule
    public static final TemporaryFolder TEMP_FOLDER = new TemporaryFolder();

    @Test
    public void test() throws IOException {
        File file = TEMP_FOLDER.newFile();
        file.createNewFile();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            builder.append(i).append("\n");
        }
        FileUtils.writeFileUtf8((File)file, (String)builder.toString());
        BulkFormat format = LimitableBulkFormat.create((BulkFormat)new StreamFormatAdapter((StreamFormat)new TextLineFormat()), (Long)22L);
        BulkFormat.Reader reader = format.createReader(new Configuration(), new FileSourceSplit("id", new Path(file.toURI()), 0L, file.length()));
        AtomicInteger i = new AtomicInteger(0);
        Utils.forEachRemaining((BulkFormat.Reader)reader, s -> i.incrementAndGet());
        Assert.assertEquals((long)22L, (long)i.get());
    }

    @Test
    public void testLimitOverBatches() throws IOException {
        File file = TEMP_FOLDER.newFile();
        file.createNewFile();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 10000; ++i) {
            builder.append(i).append("\n");
        }
        FileUtils.writeFileUtf8((File)file, (String)builder.toString());
        Long limit = 2048L;
        Configuration conf = new Configuration();
        conf.set(StreamFormat.FETCH_IO_SIZE, (Object)MemorySize.parse((String)"4k"));
        BulkFormat format = LimitableBulkFormat.create((BulkFormat)new StreamFormatAdapter((StreamFormat)new TextLineFormat()), (Long)limit);
        BulkFormat.Reader reader = format.createReader(conf, new FileSourceSplit("id", new Path(file.toURI()), 0L, file.length()));
        AtomicInteger i = new AtomicInteger(0);
        Utils.forEachRemaining((BulkFormat.Reader)reader, s -> i.incrementAndGet());
        Assert.assertEquals((long)limit.intValue(), (long)i.get());
    }
}

