/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util.collections.binary;

import java.util.Random;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.runtime.typeutils.BinaryRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.table.runtime.typeutils.WindowKeySerializer;
import org.apache.flink.table.runtime.util.WindowKey;
import org.apache.flink.table.runtime.util.collections.binary.AbstractBytesMultiMap;
import org.apache.flink.table.runtime.util.collections.binary.BytesMultiMapTestBase;
import org.apache.flink.table.runtime.util.collections.binary.WindowBytesMultiMap;
import org.apache.flink.table.types.logical.LogicalType;

public class WindowBytesMultiMapTest
extends BytesMultiMapTestBase<WindowKey> {
    public WindowBytesMultiMapTest() {
        super(new WindowKeySerializer((PagedTypeSerializer)new BinaryRowDataSerializer(KEY_TYPES.length)));
    }

    @Override
    public AbstractBytesMultiMap<WindowKey> createBytesMultiMap(MemoryManager memoryManager, int memorySize, LogicalType[] keyTypes, LogicalType[] valueTypes) {
        return new WindowBytesMultiMap((Object)this, memoryManager, (long)memorySize, (PagedTypeSerializer)new BinaryRowDataSerializer(keyTypes.length), valueTypes.length);
    }

    public WindowKey[] generateRandomKeys(int num) {
        Random rnd = new Random(76518743207143L);
        BinaryRowData[] keys = this.getRandomizedInputs(num, rnd, true);
        WindowKey[] windowKeys = new WindowKey[num];
        for (int i = 0; i < num; ++i) {
            windowKeys[i] = new WindowKey(rnd.nextLong(), (RowData)keys[i]);
        }
        return windowKeys;
    }
}

