/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window.slicing;

import java.time.Duration;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.TimeZone;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssignerTestBase;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigners;
import org.apache.flink.table.runtime.operators.window.slicing.SliceSharedAssigner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class CumulativeSliceAssignerTest
extends SliceAssignerTestBase {
    @Parameterized.Parameter
    public ZoneId shiftTimeZone;

    @Parameterized.Parameters(name="timezone = {0}")
    public static Collection<ZoneId> parameters() {
        return Arrays.asList(ZoneId.of("America/Los_Angeles"), ZoneId.of("Asia/Shanghai"));
    }

    @Test
    public void testSliceAssignment() {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofDays(1L), (Duration)Duration.ofHours(1L));
        Assert.assertEquals((long)this.utcMills("1970-01-01T01:00:00"), (long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-02T23:00:00"), (long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-02T22:59:59.999")));
        Assert.assertEquals((long)this.utcMills("1970-01-03T00:00:00"), (long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-02T23:00:00")));
    }

    @Test
    public void testSliceAssignmentWithOffset() {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L)).withOffset(Duration.ofMillis(100L));
        Assert.assertEquals((long)this.utcMills("1970-01-01T01:00:00.100"), (long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T00:00:00.100")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T05:00:00.100"), (long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.099")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T06:00:00.100"), (long)CumulativeSliceAssignerTest.assignSliceEnd((SliceAssigner)assigner, this.localMills("1970-01-01T05:00:00.1")));
    }

    @Test
    public void testDstSaving() {
        if (!TimeZone.getTimeZone(this.shiftTimeZone).useDaylightTime()) {
            return;
        }
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(4L), (Duration)Duration.ofHours(1L));
        long epoch1 = 1615708800000L;
        long epoch2 = 1615712400000L;
        long epoch3 = 1615716000000L;
        long epoch4 = 1615719600000L;
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T01:00", epoch1, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T02:00", epoch2, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T00:00", "2021-03-14T04:00", epoch3, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-03-14T04:00", "2021-03-14T05:00", epoch4, (SliceAssigner)assigner);
        long epoch5 = 1636268400000L;
        long epoch6 = 1636272000000L;
        long epoch7 = 1636275600000L;
        long epoch8 = 1636279200000L;
        long epoch9 = 1636282800000L;
        long epoch10 = 1636286400000L;
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T01:00", epoch5, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T02:00", epoch6, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T02:00", epoch7, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T03:00", epoch8, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T00:00", "2021-11-07T04:00", epoch9, (SliceAssigner)assigner);
        CumulativeSliceAssignerTest.assertSliceStartEnd("2021-11-07T04:00", "2021-11-07T05:00", epoch10, (SliceAssigner)assigner);
    }

    @Test
    public void testGetWindowStart() {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assert.assertEquals((long)this.utcMills("1969-12-31T19:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T00:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T00:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T01:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T00:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T02:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T00:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T03:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T00:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T04:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T00:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T05:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T05:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T06:00:00")));
        Assert.assertEquals((long)this.utcMills("1970-01-01T05:00:00"), (long)assigner.getWindowStart(this.utcMills("1970-01-01T08:00:00")));
    }

    @Test
    public void testExpiredSlices() {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assert.assertEquals(Collections.emptyList(), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T01:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T02:00:00")), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T02:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T03:00:00")), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T03:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T04:00:00")), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T04:00:00")));
        Assert.assertEquals(Arrays.asList(this.utcMills("1970-01-01T05:00:00"), this.utcMills("1970-01-01T01:00:00")), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T05:00:00")));
        Assert.assertEquals(Collections.emptyList(), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T06:00:00")));
        Assert.assertEquals(Arrays.asList(this.utcMills("1970-01-01T10:00:00"), this.utcMills("1970-01-01T06:00:00")), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T10:00:00")));
        Assert.assertEquals(Arrays.asList(this.utcMills("1970-01-01T00:00:00"), this.utcMills("1969-12-31T20:00:00")), CumulativeSliceAssignerTest.expiredSlices((SliceAssigner)assigner, this.utcMills("1970-01-01T00:00:00")));
    }

    @Test
    public void testMerge() throws Exception {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T01:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T01:00:00")));
        Assert.assertEquals(Collections.emptyList(), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T01:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T01:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T02:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T02:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T02:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T01:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T03:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T03:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T03:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T01:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T04:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T04:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T04:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T01:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T05:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T05:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T05:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T06:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T06:00:00")));
        Assert.assertEquals(Collections.emptyList(), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T06:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T06:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T08:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T08:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T08:00:00")));
        Assert.assertEquals((Object)this.utcMills("1970-01-01T06:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T10:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T10:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T10:00:00")));
        Assert.assertEquals((Object)this.utcMills("1969-12-31T20:00:00"), (Object)CumulativeSliceAssignerTest.mergeResultSlice((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T00:00:00")));
        Assert.assertEquals(Collections.singletonList(this.utcMills("1970-01-01T00:00:00")), CumulativeSliceAssignerTest.toBeMergedSlices((SliceSharedAssigner)assigner, this.utcMills("1970-01-01T00:00:00")));
    }

    @Test
    public void testNextTriggerWindow() {
        SliceAssigners.CumulativeSliceAssigner assigner = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofHours(5L), (Duration)Duration.ofHours(1L));
        Assert.assertEquals(Optional.empty(), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T00:00:00"), () -> false));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T02:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T01:00:00"), () -> false));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T03:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T02:00:00"), () -> false));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T04:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T03:00:00"), () -> false));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T05:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T04:00:00"), () -> false));
        Assert.assertEquals(Optional.empty(), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T05:00:00"), () -> false));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T07:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T06:00:00"), () -> false));
        Assert.assertEquals(Optional.empty(), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T00:00:00"), () -> true));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T02:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T01:00:00"), () -> true));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T03:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T02:00:00"), () -> true));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T04:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T03:00:00"), () -> true));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T05:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T04:00:00"), () -> true));
        Assert.assertEquals(Optional.empty(), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T05:00:00"), () -> true));
        Assert.assertEquals(Optional.of(this.utcMills("1970-01-01T07:00:00")), (Object)assigner.nextTriggerWindow(this.utcMills("1970-01-01T06:00:00"), () -> true));
    }

    @Test
    public void testEventTime() {
        if (this.shiftTimeZone.equals("Asia/Shanghai")) {
            return;
        }
        SliceAssigners.CumulativeSliceAssigner assigner1 = SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L));
        Assert.assertTrue((boolean)assigner1.isEventTime());
        SliceAssigners.CumulativeSliceAssigner assigner2 = SliceAssigners.cumulative((int)-1, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(1L));
        Assert.assertFalse((boolean)assigner2.isEventTime());
    }

    @Test
    public void testInvalidParameters() {
        CumulativeSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(-5L), (Duration)Duration.ofSeconds(1L)), "Cumulative Window parameters must satisfy maxSize > 0 and step > 0, but got maxSize -5000ms and step 1000ms.");
        CumulativeSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(-1L)), "Cumulative Window parameters must satisfy maxSize > 0 and step > 0, but got maxSize 5000ms and step -1000ms.");
        CumulativeSliceAssignerTest.assertErrorMessage(() -> SliceAssigners.cumulative((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(5L), (Duration)Duration.ofSeconds(2L)), "Cumulative Window requires maxSize must be an integral multiple of step, but got maxSize 5000ms and step 2000ms.");
        SliceAssigners.hopping((int)0, (ZoneId)this.shiftTimeZone, (Duration)Duration.ofSeconds(10L), (Duration)Duration.ofSeconds(2L)).withOffset(Duration.ofSeconds(-1L));
    }

    private long localMills(String timestampStr) {
        return this.localMills(timestampStr, this.shiftTimeZone);
    }
}

