/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.formats.raw;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LocalDateTimeSerializer;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.formats.raw.RawFormatDeserializationSchema;
import org.apache.flink.formats.raw.RawFormatSerializationSchema;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.conversion.DataStructureConverter;
import org.apache.flink.table.data.conversion.DataStructureConverters;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class RawFormatSerDeSchemaTest {
    @Parameterized.Parameter
    public TestSpec testSpec;

    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpec.type(DataTypes.TINYINT()).value((byte)127).binary(new byte[]{127}), TestSpec.type(DataTypes.SMALLINT()).value((short)Short.MAX_VALUE).binary(StringUtils.hexStringToByte((String)"7fff")), TestSpec.type(DataTypes.SMALLINT()).value((short)Short.MAX_VALUE).withLittleEndian().binary(StringUtils.hexStringToByte((String)"ff7f")), TestSpec.type(DataTypes.INT()).value(Integer.MAX_VALUE).binary(StringUtils.hexStringToByte((String)"7fffffff")), TestSpec.type(DataTypes.INT()).value(Integer.MAX_VALUE).withLittleEndian().binary(StringUtils.hexStringToByte((String)"ffffff7f")), TestSpec.type(DataTypes.BIGINT()).value(Long.MAX_VALUE).binary(StringUtils.hexStringToByte((String)"7fffffffffffffff")), TestSpec.type(DataTypes.BIGINT()).value(Long.MAX_VALUE).withLittleEndian().binary(StringUtils.hexStringToByte((String)"ffffffffffffff7f")), TestSpec.type(DataTypes.FLOAT()).value(Float.valueOf(Float.MAX_VALUE)).binary(StringUtils.hexStringToByte((String)"7f7fffff")), TestSpec.type(DataTypes.FLOAT()).value(Float.valueOf(Float.MAX_VALUE)).withLittleEndian().binary(StringUtils.hexStringToByte((String)"ffff7f7f")), TestSpec.type(DataTypes.DOUBLE()).value(Double.MAX_VALUE).binary(StringUtils.hexStringToByte((String)"7fefffffffffffff")), TestSpec.type(DataTypes.DOUBLE()).value(Double.MAX_VALUE).withLittleEndian().binary(StringUtils.hexStringToByte((String)"ffffffffffffef7f")), TestSpec.type(DataTypes.BOOLEAN()).value(true).binary(new byte[]{1}), TestSpec.type(DataTypes.BOOLEAN()).value(false).binary(new byte[]{0}), TestSpec.type(DataTypes.STRING()).value("Hello World").binary("Hello World".getBytes()), TestSpec.type(DataTypes.STRING()).value("\u4f60\u597d\u4e16\u754c\uff0cHello World").binary("\u4f60\u597d\u4e16\u754c\uff0cHello World".getBytes()), TestSpec.type(DataTypes.STRING()).value("Flink Awesome!").withCharset("UTF-16").binary("Flink Awesome!".getBytes(StandardCharsets.UTF_16)), TestSpec.type(DataTypes.STRING()).value("Flink \u5e05\u54ed!").withCharset("UTF-16").binary("Flink \u5e05\u54ed!".getBytes(StandardCharsets.UTF_16)), TestSpec.type(DataTypes.STRING()).value("").binary("".getBytes()), TestSpec.type(DataTypes.VARCHAR((int)5)).value("HELLO").binary("HELLO".getBytes()), TestSpec.type(DataTypes.BYTES()).value(new byte[]{1, 3, 5, 7, 9}).binary(new byte[]{1, 3, 5, 7, 9}), TestSpec.type(DataTypes.BYTES()).value(new byte[0]).binary(new byte[0]), TestSpec.type(DataTypes.BINARY((int)3)).value(new byte[]{1, 3, 5}).binary(new byte[]{1, 3, 5}), TestSpec.type(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)new LocalDateTimeSerializer())).value(LocalDateTime.parse("2020-11-11T18:08:01.123")).binary(RawFormatSerDeSchemaTest.serializeLocalDateTime(LocalDateTime.parse("2020-11-11T18:08:01.123"))), TestSpec.type(DataTypes.TINYINT()).value(null).binary(null), TestSpec.type(DataTypes.SMALLINT()).value(null).binary(null), TestSpec.type(DataTypes.INT()).value(null).binary(null), TestSpec.type(DataTypes.BIGINT()).value(null).binary(null), TestSpec.type(DataTypes.FLOAT()).value(null).binary(null), TestSpec.type(DataTypes.DOUBLE()).value(null).binary(null), TestSpec.type(DataTypes.BOOLEAN()).value(null).binary(null), TestSpec.type(DataTypes.STRING()).value(null).binary(null), TestSpec.type(DataTypes.BYTES()).value(null).binary(null), TestSpec.type(DataTypes.RAW(LocalDateTime.class, (TypeSerializer)new LocalDateTimeSerializer())).value(null).binary(null));
    }

    @Test
    public void testSerializationAndDeserialization() throws Exception {
        RawFormatDeserializationSchema deserializationSchema = new RawFormatDeserializationSchema(this.testSpec.type.getLogicalType(), TypeInformation.of(RowData.class), this.testSpec.charsetName, this.testSpec.isBigEndian);
        RawFormatSerializationSchema serializationSchema = new RawFormatSerializationSchema(this.testSpec.type.getLogicalType(), this.testSpec.charsetName, this.testSpec.isBigEndian);
        deserializationSchema.open((DeserializationSchema.InitializationContext)Mockito.mock(DeserializationSchema.InitializationContext.class));
        serializationSchema.open((SerializationSchema.InitializationContext)Mockito.mock(SerializationSchema.InitializationContext.class));
        Row row = Row.of((Object[])new Object[]{this.testSpec.value});
        DataStructureConverter converter = DataStructureConverters.getConverter((DataType)DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"single", (DataType)this.testSpec.type)}));
        RowData originalRowData = (RowData)converter.toInternal((Object)row);
        byte[] serializedBytes = serializationSchema.serialize(originalRowData);
        Assert.assertArrayEquals((byte[])this.testSpec.binary, (byte[])serializedBytes);
        RowData deserializeRowData = deserializationSchema.deserialize(serializedBytes);
        Row actual = (Row)converter.toExternal((Object)deserializeRowData);
        Assert.assertEquals((Object)row, (Object)actual);
    }

    private static byte[] serializeLocalDateTime(LocalDateTime localDateTime) {
        DataOutputSerializer dos = new DataOutputSerializer(16);
        LocalDateTimeSerializer serializer = new LocalDateTimeSerializer();
        try {
            serializer.serialize(localDateTime, (DataOutputView)dos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return dos.getCopyOfBuffer();
    }

    private static class TestSpec {
        private Object value;
        private byte[] binary;
        private DataType type;
        private String charsetName = "UTF-8";
        private boolean isBigEndian = true;

        private TestSpec(DataType type) {
            this.type = type;
        }

        public static TestSpec type(DataType fieldType) {
            return new TestSpec(fieldType);
        }

        public TestSpec value(Object value) {
            this.value = value;
            return this;
        }

        public TestSpec binary(byte[] bytes) {
            this.binary = bytes;
            return this;
        }

        public TestSpec withCharset(String charsetName) {
            this.charsetName = charsetName;
            return this;
        }

        public TestSpec withLittleEndian() {
            this.isBigEndian = false;
            return this;
        }

        public String toString() {
            String hex = this.binary == null ? "null" : "0x" + StringUtils.byteToHexString((byte[])this.binary);
            return "TestSpec{value=" + this.value + ", binary=" + hex + ", type=" + this.type + ", charsetName='" + this.charsetName + '\'' + ", isBigEndian=" + this.isBigEndian + '}';
        }
    }
}

