/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.runtime.typeutils.ExternalSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.types.Row;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ExternalSerializerTest<T>
extends SerializerTestInstance<T> {
    @Parameterized.Parameters(name="{index}: {0}")
    public static List<TestSpec<?>> testData() {
        return Arrays.asList(TestSpec.forDataType(DataTypes.INT()).withLength(4).addInstance(18).addInstance(42), TestSpec.forDataType(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).addInstance(Row.of((Object[])new Object[]{12, "Bob"})).addInstance(Row.of((Object[])new Object[]{42, null})), TestSpec.forDataType(DataTypes.STRUCTURED(ImmutableTestPojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).addInstance(new ImmutableTestPojo(12, "Bob")).addInstance(new ImmutableTestPojo(42, null)), TestSpec.forDataType((DataType)DataTypes.ARRAY((DataType)DataTypes.STRUCTURED(ImmutableTestPojo.class, (DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"age", (DataType)DataTypes.INT()), DataTypes.FIELD((String)"name", (DataType)DataTypes.STRING())})).bridgedTo(List.class)).addInstance(Collections.singletonList(new ImmutableTestPojo(12, "Bob"))).addInstance(Arrays.asList(new ImmutableTestPojo(42, "Alice"), null, null, new ImmutableTestPojo(42, null))), TestSpec.forDataType(DataTypes.ARRAY((DataType)DataTypes.INT())).addInstance(new Integer[]{0, 1, null, 3}).addInstance(new Integer[0]));
    }

    public ExternalSerializerTest(TestSpec<T> testSpec) {
        super((TypeSerializer)ExternalSerializer.of((DataType)((TestSpec)testSpec).dataType), ((TestSpec)testSpec).dataType.getConversionClass(), ((TestSpec)testSpec).length, ((TestSpec)testSpec).instances.toArray((Object[])Array.newInstance(((TestSpec)testSpec).dataType.getConversionClass(), 0)));
    }

    protected boolean allowNullInstances(TypeSerializer<T> serializer) {
        return true;
    }

    public static class ImmutableTestPojo {
        public final int age;
        public final String name;

        public ImmutableTestPojo(int age, String name) {
            this.age = age;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImmutableTestPojo that = (ImmutableTestPojo)o;
            return this.age == that.age && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.age, this.name);
        }
    }

    private static class TestSpec<T> {
        private final DataType dataType;
        private final List<T> instances = new ArrayList<T>();
        private int length = -1;

        private TestSpec(DataType dataType) {
            this.dataType = dataType;
        }

        static <T> TestSpec<T> forDataType(DataType dataType) {
            return new TestSpec<T>(dataType);
        }

        TestSpec<T> withLength(int length) {
            this.length = length;
            return this;
        }

        TestSpec<T> addInstance(T instance) {
            this.instances.add(instance);
            return this;
        }

        public String toString() {
            return this.dataType.toString();
        }
    }
}

