/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyContext;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.GeneratedRecordEqualiser;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.generated.RecordEqualiser;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ComparableRecordComparator;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRangeWithoutEnd;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.operators.sort.IntRecordComparator;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.runtime.util.GenericRowRecordSortComparator;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.RowDataRecordEqualiser;
import org.apache.flink.table.runtime.util.StateConfigUtil;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.HandwrittenSelectorUtil;
import org.junit.Test;

abstract class TopNFunctionTestBase {
    StateTtlConfig ttlConfig = StateConfigUtil.createTtlConfig((long)10000000L);
    long cacheSize = 10000L;
    InternalTypeInfo<RowData> inputRowType = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new BigIntType(), new IntType()});
    static GeneratedRecordComparator generatedSortKeyComparator = new GeneratedRecordComparator("", "", new Object[0]){
        private static final long serialVersionUID = 1434685115916728955L;

        public RecordComparator newInstance(ClassLoader classLoader) {
            return IntRecordComparator.INSTANCE;
        }
    };
    static ComparableRecordComparator comparableRecordComparator = new ComparableRecordComparator(generatedSortKeyComparator, new int[]{0}, new LogicalType[]{new IntType()}, new boolean[]{true}, new boolean[]{true});
    private int sortKeyIdx = 2;
    RowDataKeySelector sortKeySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{this.sortKeyIdx}, this.inputRowType.toRowFieldTypes());
    static GeneratedRecordEqualiser generatedEqualiser = new GeneratedRecordEqualiser("", "", new Object[0]){
        private static final long serialVersionUID = 8932460173848746733L;

        public RecordEqualiser newInstance(ClassLoader classLoader) {
            return new RowDataRecordEqualiser();
        }
    };
    private int partitionKeyIdx = 0;
    private RowDataKeySelector keySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{this.partitionKeyIdx}, this.inputRowType.toRowFieldTypes());
    private InternalTypeInfo<RowData> outputTypeWithoutRowNumber = this.inputRowType;
    private InternalTypeInfo<RowData> outputTypeWithRowNumber = InternalTypeInfo.ofFields((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new BigIntType(), new IntType(), new BigIntType()});
    RowDataHarnessAssertor assertorWithoutRowNumber = new RowDataHarnessAssertor(this.outputTypeWithoutRowNumber.toRowFieldTypes(), new GenericRowRecordSortComparator(this.sortKeyIdx, this.outputTypeWithoutRowNumber.toRowFieldTypes()[this.sortKeyIdx]));
    RowDataHarnessAssertor assertorWithRowNumber = new RowDataHarnessAssertor(this.outputTypeWithRowNumber.toRowFieldTypes(), new GenericRowRecordSortComparator(this.sortKeyIdx, this.outputTypeWithRowNumber.toRowFieldTypes()[this.sortKeyIdx]));
    private int rowKeyIdx = 1;
    RowDataKeySelector rowKeySelector = HandwrittenSelectorUtil.getRowDataSelector(new int[]{this.rowKeyIdx}, this.inputRowType.toRowFieldTypes());

    TopNFunctionTestBase() {
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testInvalidVariableRankRangeWithIntType() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(0), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNotSupportRank() throws Exception {
        this.createFunction(RankType.RANK, (RankRange)new ConstantRankRange(1L, 10L), true, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNotSupportDenseRank() throws Exception {
        this.createFunction(RankType.DENSE_RANK, (RankRange)new ConstantRankRange(1L, 10L), true, true);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testNotSupportWithoutRankEnd() throws Exception {
        this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRangeWithoutEnd(1L), true, true);
    }

    @Test
    public void testDisableGenerateUpdateBefore() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 5L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testDisableGenerateUpdateBeforeAndOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 5L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 4L, 33, 2L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testOutputRankNumberWithConstantRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 5L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 4L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 5L, 22, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 3L, 44, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 4L, 33, 2L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testConstantRankRangeWithOffset() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(2L, 2L), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 4L, 33));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testOutputRankNumberWithVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 12, 2L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testConstantRankRangeWithoutOffset() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 4L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 4L, 33));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.deleteRecord("fruit", 3L, 44));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 5L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        expectedOutput.clear();
        func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        testHarness = this.createTestHarness(func);
        testHarness.setup();
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 5L, 10));
        testHarness.close();
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 5L, 10));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(AbstractTopNFunction rankFunction) throws Exception {
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)rankFunction);
        rankFunction.setKeyContext((KeyContext)operator);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector)this.keySelector, (TypeInformation)this.keySelector.getProducedType());
    }

    abstract AbstractTopNFunction createFunction(RankType var1, RankRange var2, boolean var3, boolean var4);
}

