/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.multipleinput;

import java.util.Arrays;
import java.util.Collections;
import org.apache.flink.streaming.api.operators.StreamOperatorParameters;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.multipleinput.MultipleInputTestBase;
import org.apache.flink.table.runtime.operators.multipleinput.TableOperatorWrapper;
import org.apache.flink.table.runtime.operators.multipleinput.TestingOneInputStreamOperator;
import org.apache.flink.table.runtime.operators.multipleinput.TestingTwoInputStreamOperator;
import org.junit.Assert;
import org.junit.Test;

public class TableOperatorWrapperTest
extends MultipleInputTestBase {
    @Test
    public void testBasicInfo() {
        TestingOneInputStreamOperator inOperator1 = new TestingOneInputStreamOperator();
        TestingOneInputStreamOperator inOperator2 = new TestingOneInputStreamOperator();
        TestingTwoInputStreamOperator outOperator = new TestingTwoInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper1 = this.createOneInputOperatorWrapper(inOperator1, "test1");
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper2 = this.createOneInputOperatorWrapper(inOperator2, "test2");
        TableOperatorWrapper<TestingTwoInputStreamOperator> wrapper3 = this.createTwoInputOperatorWrapper(outOperator, "test3");
        wrapper3.addInput(wrapper1, 1);
        wrapper3.addInput(wrapper2, 2);
        Assert.assertTrue((boolean)wrapper1.getInputEdges().isEmpty());
        Assert.assertTrue((boolean)wrapper1.getInputWrappers().isEmpty());
        Assert.assertEquals(Collections.singletonList(wrapper3), (Object)wrapper1.getOutputWrappers());
        Assert.assertEquals(Collections.singletonList(new TableOperatorWrapper.Edge(wrapper1, wrapper3, 1)), (Object)wrapper1.getOutputEdges());
        Assert.assertTrue((boolean)wrapper2.getInputEdges().isEmpty());
        Assert.assertTrue((boolean)wrapper2.getInputWrappers().isEmpty());
        Assert.assertEquals(Collections.singletonList(wrapper3), (Object)wrapper2.getOutputWrappers());
        Assert.assertEquals(Collections.singletonList(new TableOperatorWrapper.Edge(wrapper2, wrapper3, 2)), (Object)wrapper2.getOutputEdges());
        Assert.assertTrue((boolean)wrapper3.getOutputEdges().isEmpty());
        Assert.assertTrue((boolean)wrapper3.getOutputWrappers().isEmpty());
        Assert.assertEquals(Arrays.asList(wrapper1, wrapper2), (Object)wrapper3.getInputWrappers());
        Assert.assertEquals(Arrays.asList(new TableOperatorWrapper.Edge(wrapper1, wrapper3, 1), new TableOperatorWrapper.Edge(wrapper2, wrapper3, 2)), (Object)wrapper3.getInputEdges());
    }

    @Test
    public void testCreateOperator() throws Exception {
        TestingOneInputStreamOperator operator = new TestingOneInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper = this.createOneInputOperatorWrapper(operator, "test");
        StreamOperatorParameters<RowData> parameters = this.createStreamOperatorParameters();
        wrapper.createOperator(parameters);
        Assert.assertEquals((Object)((Object)operator), (Object)wrapper.getStreamOperator());
        try {
            wrapper.createOperator(parameters);
            Assert.fail((String)"This should not happen");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("This operator has been initialized"));
        }
    }

    @Test
    public void testEndInput() throws Exception {
        StreamOperatorParameters<RowData> parameters = this.createStreamOperatorParameters();
        TestingOneInputStreamOperator inOperator1 = new TestingOneInputStreamOperator();
        TestingOneInputStreamOperator inOperator2 = new TestingOneInputStreamOperator();
        TestingTwoInputStreamOperator outOperator = new TestingTwoInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper1 = this.createOneInputOperatorWrapper(inOperator1, "test1");
        wrapper1.createOperator(parameters);
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper2 = this.createOneInputOperatorWrapper(inOperator2, "test2");
        wrapper2.createOperator(parameters);
        TableOperatorWrapper<TestingTwoInputStreamOperator> wrapper3 = this.createTwoInputOperatorWrapper(outOperator, "test3");
        wrapper3.addInput(wrapper1, 1);
        wrapper3.addInput(wrapper2, 2);
        wrapper3.createOperator(parameters);
        Assert.assertFalse((boolean)inOperator1.isEnd());
        Assert.assertFalse((boolean)inOperator2.isEnd());
        Assert.assertTrue((boolean)outOperator.getEndInputs().isEmpty());
        wrapper1.endOperatorInput(1);
        Assert.assertTrue((boolean)inOperator1.isEnd());
        Assert.assertEquals((long)1L, (long)wrapper1.getEndedInputCount());
        Assert.assertFalse((boolean)inOperator2.isEnd());
        Assert.assertEquals((long)0L, (long)wrapper2.getEndedInputCount());
        Assert.assertEquals(Collections.singletonList(1), outOperator.getEndInputs());
        Assert.assertEquals((long)1L, (long)wrapper3.getEndedInputCount());
        wrapper2.endOperatorInput(1);
        Assert.assertTrue((boolean)inOperator1.isEnd());
        Assert.assertEquals((long)1L, (long)wrapper1.getEndedInputCount());
        Assert.assertTrue((boolean)inOperator2.isEnd());
        Assert.assertEquals((long)1L, (long)wrapper2.getEndedInputCount());
        Assert.assertEquals(Arrays.asList(1, 2), outOperator.getEndInputs());
        Assert.assertEquals((long)2L, (long)wrapper3.getEndedInputCount());
    }

    @Test
    public void testClose() throws Exception {
        TestingOneInputStreamOperator operator = new TestingOneInputStreamOperator();
        TableOperatorWrapper<TestingOneInputStreamOperator> wrapper = this.createOneInputOperatorWrapper(operator, "test");
        StreamOperatorParameters<RowData> parameters = this.createStreamOperatorParameters();
        wrapper.createOperator(parameters);
        Assert.assertEquals((Object)((Object)operator), (Object)wrapper.getStreamOperator());
        Assert.assertFalse((boolean)operator.isClosed());
        Assert.assertFalse((boolean)wrapper.isClosed());
        wrapper.close();
        Assert.assertTrue((boolean)wrapper.isClosed());
        Assert.assertTrue((boolean)operator.isClosed());
        wrapper.close();
        Assert.assertTrue((boolean)wrapper.isClosed());
        Assert.assertTrue((boolean)operator.isClosed());
    }
}

