/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.core.fs.FSDataOutputStream;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.filesystem.stream.PartitionCommitInfo;
import org.apache.flink.table.filesystem.stream.compact.AbstractCompactTestBase;
import org.apache.flink.table.filesystem.stream.compact.CompactBulkReader;
import org.apache.flink.table.filesystem.stream.compact.CompactMessages;
import org.apache.flink.table.filesystem.stream.compact.CompactOperator;
import org.apache.flink.table.filesystem.stream.compact.CompactWriter;
import org.apache.flink.table.filesystem.stream.compact.TestByteFormat;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.function.ThrowingConsumer;
import org.junit.Assert;
import org.junit.Test;

public class CompactOperatorTest
extends AbstractCompactTestBase {
    @Test
    public void testCompactOperator() throws Exception {
        AtomicReference state = new AtomicReference();
        Path f0 = this.newFile(".uncompacted-f0", 3);
        Path f1 = this.newFile(".uncompacted-f1", 2);
        Path f2 = this.newFile(".uncompacted-f2", 2);
        Path f3 = this.newFile(".uncompacted-f3", 5);
        Path f4 = this.newFile(".uncompacted-f4", 1);
        Path f5 = this.newFile(".uncompacted-f5", 5);
        Path f6 = this.newFile(".uncompacted-f6", 4);
        FileSystem fs = f0.getFileSystem();
        this.runCompact((ThrowingConsumer<OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo>, Exception>)((ThrowingConsumer)harness -> {
            harness.setup();
            harness.open();
            harness.processElement((Object)new CompactMessages.CompactionUnit(0, "p0", Arrays.asList(f0, f1, f4)), 0L);
            harness.processElement((Object)new CompactMessages.CompactionUnit(1, "p0", Collections.singletonList(f3)), 0L);
            harness.processElement((Object)new CompactMessages.CompactionUnit(2, "p1", Arrays.asList(f2, f5)), 0L);
            harness.processElement((Object)new CompactMessages.CompactionUnit(3, "p0", Collections.singletonList(f6)), 0L);
            harness.processElement((Object)new CompactMessages.EndCompaction(1L), 0L);
            state.set(harness.snapshot(2L, 0L));
            List outputs = harness.extractOutputValues();
            Assert.assertEquals((long)1L, (long)outputs.size());
            Assert.assertEquals((long)1L, (long)((PartitionCommitInfo)outputs.get(0)).getCheckpointId());
            Assert.assertEquals(Arrays.asList("p0", "p1"), (Object)((PartitionCommitInfo)outputs.get(0)).getPartitions());
            Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f0")));
            Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f2")));
            Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f3")));
            Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f6")));
            byte[] bytes = FileUtils.readAllBytes((java.nio.file.Path)new File(this.folder.getPath(), "compacted-f0").toPath());
            Arrays.sort(bytes);
            Assert.assertArrayEquals((byte[])new byte[]{0, 0, 0, 1, 1, 2}, (byte[])bytes);
        }));
        this.runCompact((ThrowingConsumer<OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo>, Exception>)((ThrowingConsumer)harness -> {
            harness.setup();
            harness.initializeState((OperatorSubtaskState)state.get());
            harness.open();
            harness.notifyOfCompletedCheckpoint(2L);
            Assert.assertFalse((boolean)fs.exists(f0));
            Assert.assertFalse((boolean)fs.exists(f1));
            Assert.assertFalse((boolean)fs.exists(f2));
            Assert.assertFalse((boolean)fs.exists(f3));
            Assert.assertFalse((boolean)fs.exists(f4));
            Assert.assertFalse((boolean)fs.exists(f5));
            Assert.assertFalse((boolean)fs.exists(f6));
        }));
    }

    @Test
    public void testEndInput() throws Exception {
        Path f0 = this.newFile(".uncompacted-f0", 3);
        Path f1 = this.newFile(".uncompacted-f1", 4);
        Path f2 = this.newFile(".uncompacted-f2", 2);
        FileSystem fs = f0.getFileSystem();
        this.runCompact((ThrowingConsumer<OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo>, Exception>)((ThrowingConsumer)harness -> {
            harness.setup();
            harness.open();
            harness.processElement((Object)new CompactMessages.CompactionUnit(0, "p0", Arrays.asList(f0, f1)), 0L);
            harness.processElement((Object)new CompactMessages.CompactionUnit(1, "p0", Collections.singletonList(f2)), 0L);
            harness.endInput();
            Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f0")));
            Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f2")));
            Assert.assertFalse((boolean)fs.exists(f0));
            Assert.assertFalse((boolean)fs.exists(f1));
            Assert.assertFalse((boolean)fs.exists(f2));
        }));
    }

    @Test
    public void testUnitSelection() throws Exception {
        OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo> harness0 = this.create(2, 0);
        harness0.setup();
        harness0.open();
        OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo> harness1 = this.create(2, 1);
        harness1.setup();
        harness1.open();
        Path f0 = this.newFile(".uncompacted-f0", 3);
        Path f1 = this.newFile(".uncompacted-f1", 2);
        Path f2 = this.newFile(".uncompacted-f2", 2);
        Path f3 = this.newFile(".uncompacted-f3", 5);
        Path f4 = this.newFile(".uncompacted-f4", 1);
        Path f5 = this.newFile(".uncompacted-f5", 5);
        Path f6 = this.newFile(".uncompacted-f6", 4);
        FileSystem fs = f0.getFileSystem();
        harness0.processElement((Object)new CompactMessages.CompactionUnit(0, "p0", Arrays.asList(f0, f1, f4)), 0L);
        harness0.processElement((Object)new CompactMessages.CompactionUnit(1, "p0", Collections.singletonList(f3)), 0L);
        harness0.processElement((Object)new CompactMessages.CompactionUnit(2, "p0", Arrays.asList(f2, f5)), 0L);
        harness0.processElement((Object)new CompactMessages.CompactionUnit(3, "p0", Collections.singletonList(f6)), 0L);
        harness0.processElement((Object)new CompactMessages.EndCompaction(1L), 0L);
        Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f0")));
        Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f2")));
        Assert.assertFalse((boolean)fs.exists(new Path(this.folder, "compacted-f3")));
        Assert.assertFalse((boolean)fs.exists(new Path(this.folder, "compacted-f6")));
        harness1.processElement((Object)new CompactMessages.CompactionUnit(0, "p0", Arrays.asList(f0, f1, f4)), 0L);
        harness1.processElement((Object)new CompactMessages.CompactionUnit(1, "p0", Collections.singletonList(f3)), 0L);
        harness1.processElement((Object)new CompactMessages.CompactionUnit(2, "p0", Arrays.asList(f2, f5)), 0L);
        harness1.processElement((Object)new CompactMessages.CompactionUnit(3, "p0", Collections.singletonList(f6)), 0L);
        harness1.processElement((Object)new CompactMessages.EndCompaction(1L), 0L);
        Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f3")));
        Assert.assertTrue((boolean)fs.exists(new Path(this.folder, "compacted-f6")));
        harness0.close();
        harness1.close();
    }

    private void runCompact(ThrowingConsumer<OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo>, Exception> consumer) throws Exception {
        try (OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo> harness = this.create(1, 0);){
            consumer.accept(harness);
        }
    }

    private OneInputStreamOperatorTestHarness<CompactMessages.CoordinatorOutput, PartitionCommitInfo> create(int parallelism, int subtaskIndex) throws Exception {
        CompactOperator operator = new CompactOperator(() -> this.folder.getFileSystem(), CompactBulkReader.factory(TestByteFormat.bulkFormat()), (CompactWriter.Factory & Serializable)context -> {
            final Path path = context.getPath();
            final Path tempPath = new Path(path.getParent(), "." + path.getName());
            final FSDataOutputStream out = context.getFileSystem().create(tempPath, FileSystem.WriteMode.OVERWRITE);
            return new CompactWriter<Byte>(){

                public void write(Byte record) throws IOException {
                    out.write((int)record.byteValue());
                }

                public void commit() throws IOException {
                    out.close();
                    context.getFileSystem().rename(tempPath, path);
                }
            };
        });
        return new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, parallelism, parallelism, subtaskIndex);
    }
}

