/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.DecimalDataUtils;
import org.junit.Assert;
import org.junit.Test;

public class DecimalDataTest {
    @Test
    public void testNormal() {
        BigDecimal bigDecimal1 = new BigDecimal("13145678.90123");
        BigDecimal bigDecimal2 = new BigDecimal("1234567890.0987654321");
        Assert.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)bigDecimal1, (int)15, (int)5), (Object)DecimalData.fromUnscaledBytes((byte[])bigDecimal1.unscaledValue().toByteArray(), (int)15, (int)5));
        Assert.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)bigDecimal2, (int)23, (int)10), (Object)DecimalData.fromUnscaledBytes((byte[])bigDecimal2.unscaledValue().toByteArray(), (int)23, (int)10));
        Assert.assertArrayEquals((byte[])bigDecimal1.unscaledValue().toByteArray(), (byte[])DecimalData.fromUnscaledBytes((byte[])bigDecimal1.unscaledValue().toByteArray(), (int)15, (int)5).toUnscaledBytes());
        Assert.assertArrayEquals((byte[])bigDecimal2.unscaledValue().toByteArray(), (byte[])DecimalData.fromUnscaledBytes((byte[])bigDecimal2.unscaledValue().toByteArray(), (int)23, (int)10).toUnscaledBytes());
        DecimalData decimal1 = DecimalData.fromUnscaledLong((long)10L, (int)5, (int)0);
        DecimalData decimal2 = DecimalData.fromUnscaledLong((long)15L, (int)5, (int)0);
        Assert.assertEquals((long)decimal1.hashCode(), (long)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)5, (int)0).hashCode());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.copy());
        Assert.assertEquals((Object)decimal1, (Object)DecimalData.fromUnscaledLong((long)decimal1.toUnscaledLong(), (int)5, (int)0));
        Assert.assertEquals((Object)decimal1, (Object)DecimalData.fromUnscaledBytes((byte[])decimal1.toUnscaledBytes(), (int)5, (int)0));
        Assert.assertTrue((decimal1.compareTo(decimal2) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)DecimalDataUtils.signum((DecimalData)decimal1));
        Assert.assertEquals((double)10.5, (double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)5, (int)1)), (double)0.0);
        Assert.assertEquals((Object)DecimalData.fromUnscaledLong((long)-10L, (int)5, (int)0), (Object)DecimalDataUtils.negate((DecimalData)decimal1));
        Assert.assertEquals((Object)decimal1, (Object)DecimalDataUtils.abs((DecimalData)decimal1));
        Assert.assertEquals((Object)decimal1, (Object)DecimalDataUtils.abs((DecimalData)DecimalDataUtils.negate((DecimalData)decimal1)));
        Assert.assertEquals((long)25L, (long)DecimalDataUtils.add((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((long)-5L, (long)DecimalDataUtils.subtract((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((long)150L, (long)DecimalDataUtils.multiply((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((double)0.67, (double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.divide((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)2)), (double)0.0);
        Assert.assertEquals((Object)decimal1, (Object)DecimalDataUtils.mod((DecimalData)decimal1, (DecimalData)decimal2, (int)5, (int)0));
        Assert.assertEquals((long)5L, (long)DecimalDataUtils.divideToIntegralValue((DecimalData)decimal1, (DecimalData)DecimalData.fromUnscaledLong((long)2L, (int)5, (int)0), (int)5, (int)0).toUnscaledLong());
        Assert.assertEquals((long)10L, (long)DecimalDataUtils.castToIntegral((DecimalData)decimal1));
        Assert.assertTrue((boolean)DecimalDataUtils.castToBoolean((DecimalData)decimal1));
        Assert.assertEquals((long)0L, (long)DecimalDataUtils.compare((DecimalData)decimal1, (long)10L));
        Assert.assertTrue((DecimalDataUtils.compare((DecimalData)decimal1, (long)5L) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)DecimalDataUtils.castFrom((double)1.0, (int)10, (int)5), (Object)DecimalDataUtils.sign((DecimalData)DecimalDataUtils.castFrom((double)5.556, (int)10, (int)5)));
        Assert.assertNull((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0));
        Assert.assertEquals((long)0L, (long)DecimalData.zero((int)5, (int)2).toBigDecimal().intValue());
        Assert.assertEquals((long)0L, (long)DecimalData.zero((int)20, (int)2).toBigDecimal().intValue());
        Assert.assertEquals((Object)DecimalData.fromUnscaledLong((long)10L, (int)5, (int)0), (Object)DecimalDataUtils.floor((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)5, (int)1)));
        Assert.assertEquals((Object)DecimalData.fromUnscaledLong((long)11L, (int)5, (int)0), (Object)DecimalDataUtils.ceil((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)5, (int)1)));
        Assert.assertEquals((Object)"5.00", (Object)DecimalDataUtils.castToDecimal((DecimalData)DecimalDataUtils.castFrom((double)5.0, (int)10, (int)1), (int)10, (int)2).toString());
        Assert.assertTrue((boolean)DecimalDataUtils.castToBoolean((DecimalData)DecimalDataUtils.castFrom((boolean)true, (int)5, (int)0)));
        Assert.assertEquals((long)5L, (long)DecimalDataUtils.castToIntegral((DecimalData)DecimalDataUtils.castFrom((long)5L, (int)5, (int)0)));
        Assert.assertEquals((long)5L, (long)DecimalDataUtils.castToIntegral((DecimalData)DecimalDataUtils.castFrom((String)"5", (int)5, (int)0)));
        DecimalData newDecimal = DecimalDataUtils.castFrom((DecimalData)DecimalDataUtils.castFrom((long)10L, (int)5, (int)2), (int)10, (int)4);
        Assert.assertEquals((long)10L, (long)newDecimal.precision());
        Assert.assertEquals((long)4L, (long)newDecimal.scale());
        Assert.assertTrue((boolean)DecimalDataUtils.is32BitDecimal((int)6));
        Assert.assertTrue((boolean)DecimalDataUtils.is64BitDecimal((int)11));
        Assert.assertTrue((boolean)DecimalDataUtils.isByteArrayDecimal((int)20));
        Assert.assertEquals((long)6L, (long)DecimalDataUtils.sround((DecimalData)DecimalDataUtils.castFrom((double)5.555, (int)5, (int)0), (int)1).toUnscaledLong());
        Assert.assertEquals((long)56L, (long)DecimalDataUtils.sround((DecimalData)DecimalDataUtils.castFrom((double)5.555, (int)5, (int)3), (int)1).toUnscaledLong());
    }

    @Test
    public void testNotCompact() {
        DecimalData decimal1 = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0);
        DecimalData decimal2 = DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(15), (int)20, (int)0);
        Assert.assertEquals((long)decimal1.hashCode(), (long)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(10), (int)20, (int)0).hashCode());
        Assert.assertEquals((Object)decimal1, (Object)decimal1.copy());
        Assert.assertEquals((Object)decimal1, (Object)DecimalData.fromBigDecimal((BigDecimal)decimal1.toBigDecimal(), (int)20, (int)0));
        Assert.assertEquals((Object)decimal1, (Object)DecimalData.fromUnscaledBytes((byte[])decimal1.toUnscaledBytes(), (int)20, (int)0));
        Assert.assertTrue((decimal1.compareTo(decimal2) < 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)DecimalDataUtils.signum((DecimalData)decimal1));
        Assert.assertEquals((double)10.5, (double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.castFrom((double)10.5, (int)20, (int)1)), (double)0.0);
        Assert.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(-10), (int)20, (int)0), (Object)DecimalDataUtils.negate((DecimalData)decimal1));
        Assert.assertEquals((Object)decimal1, (Object)DecimalDataUtils.abs((DecimalData)decimal1));
        Assert.assertEquals((Object)decimal1, (Object)DecimalDataUtils.abs((DecimalData)DecimalDataUtils.negate((DecimalData)decimal1)));
        Assert.assertEquals((long)25L, (long)DecimalDataUtils.add((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((long)-5L, (long)DecimalDataUtils.subtract((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((long)150L, (long)DecimalDataUtils.multiply((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((double)0.67, (double)DecimalDataUtils.doubleValue((DecimalData)DecimalDataUtils.divide((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)2)), (double)0.0);
        Assert.assertEquals((Object)decimal1, (Object)DecimalDataUtils.mod((DecimalData)decimal1, (DecimalData)decimal2, (int)20, (int)0));
        Assert.assertEquals((long)5L, (long)DecimalDataUtils.divideToIntegralValue((DecimalData)decimal1, (DecimalData)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(2), (int)20, (int)0), (int)20, (int)0).toBigDecimal().longValue());
        Assert.assertEquals((long)10L, (long)DecimalDataUtils.castToIntegral((DecimalData)decimal1));
        Assert.assertTrue((boolean)DecimalDataUtils.castToBoolean((DecimalData)decimal1));
        Assert.assertEquals((long)0L, (long)DecimalDataUtils.compare((DecimalData)decimal1, (long)10L));
        Assert.assertTrue((DecimalDataUtils.compare((DecimalData)decimal1, (long)5L) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((DecimalDataUtils.compare((DecimalData)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal("10.5"), (int)20, (int)2), (long)10L) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)DecimalDataUtils.castFrom((double)1.0, (int)20, (int)5), (Object)DecimalDataUtils.sign((DecimalData)DecimalDataUtils.castFrom((double)5.556, (int)20, (int)5)));
        Assert.assertNull((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(Long.MAX_VALUE), (int)5, (int)0));
        Assert.assertEquals((long)0L, (long)DecimalData.zero((int)20, (int)2).toBigDecimal().intValue());
        Assert.assertEquals((long)0L, (long)DecimalData.zero((int)20, (int)2).toBigDecimal().intValue());
    }

    @Test
    public void testToString() {
        String val = "0.0000000000000000001";
        Assert.assertEquals((Object)val, (Object)DecimalDataUtils.castFrom((String)val, (int)39, (int)(val.length() - 2)).toString());
        val = "123456789012345678901234567890123456789";
        Assert.assertEquals((Object)val, (Object)DecimalDataUtils.castFrom((String)val, (int)39, (int)0).toString());
    }
}

