/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.api.common.serialization.BulkWriter;
import org.apache.flink.api.java.io.CsvOutputFormat;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.util.DataFormatConverters;
import org.apache.flink.table.factories.BulkWriterFormatFactory;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FileSystemFormatFactory;
import org.apache.flink.table.filesystem.TestRowDataCsvInputFormat;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.types.Row;

public class TestCsvFileSystemFormatFactory
implements FileSystemFormatFactory,
BulkWriterFormatFactory {
    public String factoryIdentifier() {
        return "testcsv";
    }

    public Set<ConfigOption<?>> requiredOptions() {
        return new HashSet();
    }

    public Set<ConfigOption<?>> optionalOptions() {
        return new HashSet();
    }

    public InputFormat<RowData, ?> createReader(FileSystemFormatFactory.ReaderContext context) {
        return new TestRowDataCsvInputFormat(context.getPaths(), context.getSchema(), context.getPartitionKeys(), context.getDefaultPartName(), context.getProjectFields(), context.getPushedDownLimit());
    }

    private static void writeCsvToStream(DataType[] types, RowData rowData, OutputStream stream) throws IOException {
        LogicalType[] fieldTypes = (LogicalType[])Arrays.stream(types).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        DataFormatConverters.DataFormatConverter converter = DataFormatConverters.getConverterForDataType((DataType)TypeConversions.fromLogicalToDataType((LogicalType)RowType.of((LogicalType[])fieldTypes)));
        Row row = (Row)converter.toExternal((Object)rowData);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < row.getArity(); ++i) {
            Object o;
            if (i > 0) {
                builder.append(CsvOutputFormat.DEFAULT_FIELD_DELIMITER);
            }
            if ((o = row.getField(i)) == null) continue;
            builder.append(o);
        }
        String str = builder.toString();
        stream.write(str.getBytes(StandardCharsets.UTF_8));
        stream.write("\n".getBytes(StandardCharsets.UTF_8));
    }

    public EncodingFormat<BulkWriter.Factory<RowData>> createEncodingFormat(DynamicTableFactory.Context context, ReadableConfig formatOptions) {
        return new EncodingFormat<BulkWriter.Factory<RowData>>(){

            public BulkWriter.Factory<RowData> createRuntimeEncoder(DynamicTableSink.Context context, DataType consumedDataType) {
                return (BulkWriter.Factory & Serializable)out -> new CsvBulkWriter(consumedDataType.getChildren().toArray(new DataType[0]), (OutputStream)out);
            }

            public ChangelogMode getChangelogMode() {
                return ChangelogMode.insertOnly();
            }
        };
    }

    private static class CsvBulkWriter
    implements BulkWriter<RowData> {
        private final DataType[] types;
        private final OutputStream stream;

        private CsvBulkWriter(DataType[] types, OutputStream stream) {
            this.types = types;
            this.stream = stream;
        }

        public void addElement(RowData element) throws IOException {
            TestCsvFileSystemFormatFactory.writeCsvToStream(this.types, element, this.stream);
        }

        public void flush() {
        }

        public void finish() {
        }
    }
}

