/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data.vector;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.ColumnarArrayData;
import org.apache.flink.table.data.ColumnarRowData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.vector.ArrayColumnVector;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.ColumnVectorTest;
import org.apache.flink.table.data.vector.DecimalColumnVector;
import org.apache.flink.table.data.vector.Dictionary;
import org.apache.flink.table.data.vector.TimestampColumnVector;
import org.apache.flink.table.data.vector.VectorizedColumnBatch;
import org.apache.flink.table.data.vector.heap.HeapBooleanVector;
import org.apache.flink.table.data.vector.heap.HeapByteVector;
import org.apache.flink.table.data.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.vector.heap.HeapDoubleVector;
import org.apache.flink.table.data.vector.heap.HeapFloatVector;
import org.apache.flink.table.data.vector.heap.HeapIntVector;
import org.apache.flink.table.data.vector.heap.HeapLongVector;
import org.apache.flink.table.data.vector.heap.HeapShortVector;
import org.junit.Assert;
import org.junit.Test;

public class VectorizedColumnBatchTest {
    private static final int VECTOR_SIZE = 1024;
    private static final int ARRAY_SIZE = 3;

    @Test
    public void testTyped() throws IOException {
        int j;
        int i;
        HeapBooleanVector col0 = new HeapBooleanVector(1024);
        for (int i2 = 0; i2 < 1024; ++i2) {
            col0.vector[i2] = i2 % 2 == 0;
        }
        HeapBytesVector col1 = new HeapBytesVector(1024);
        for (int i3 = 0; i3 < 1024; ++i3) {
            byte[] bytes = String.valueOf(i3).getBytes(StandardCharsets.UTF_8);
            col1.appendBytes(i3, bytes, 0, bytes.length);
        }
        HeapByteVector col2 = new HeapByteVector(1024);
        for (int i4 = 0; i4 < 1024; ++i4) {
            col2.vector[i4] = (byte)i4;
        }
        HeapDoubleVector col3 = new HeapDoubleVector(1024);
        for (int i5 = 0; i5 < 1024; ++i5) {
            col3.vector[i5] = i5;
        }
        HeapFloatVector col4 = new HeapFloatVector(1024);
        for (int i6 = 0; i6 < 1024; ++i6) {
            col4.vector[i6] = i6;
        }
        HeapIntVector col5 = new HeapIntVector(1024);
        for (int i7 = 0; i7 < 1024; ++i7) {
            col5.vector[i7] = i7;
        }
        HeapLongVector col6 = new HeapLongVector(1024);
        for (int i8 = 0; i8 < 1024; ++i8) {
            col6.vector[i8] = i8;
        }
        HeapShortVector col7 = new HeapShortVector(1024);
        for (int i9 = 0; i9 < 1024; ++i9) {
            col7.vector[i9] = (short)i9;
        }
        final long[] vector8 = new long[1024];
        for (int i10 = 0; i10 < 1024; ++i10) {
            vector8[i10] = i10;
        }
        TimestampColumnVector col8 = new TimestampColumnVector(){

            public boolean isNullAt(int i) {
                return false;
            }

            public TimestampData getTimestamp(int i, int precision) {
                return TimestampData.fromEpochMillis((long)vector8[i]);
            }
        };
        final long[] vector9 = new long[1024];
        for (int i11 = 0; i11 < 1024; ++i11) {
            vector9[i11] = i11 * 1000;
        }
        TimestampColumnVector col9 = new TimestampColumnVector(){

            public TimestampData getTimestamp(int i, int precision) {
                long microseconds = vector9[i];
                return TimestampData.fromEpochMillis((long)(microseconds / 1000L), (int)((int)(microseconds % 1000L) * 1000));
            }

            public boolean isNullAt(int i) {
                return false;
            }
        };
        final HeapBytesVector vector10 = new HeapBytesVector(1024);
        int nanosecond = 123456789;
        int start = 0;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        for (i = 0; i < 1024; ++i) {
            byte[] bytes = new byte[12];
            long l = (long)i * 1000000000L + (long)nanosecond;
            for (int j2 = 0; j2 < 8; ++j2) {
                bytes[7 - j2] = (byte)l;
                l >>>= 8;
            }
            int n = 2440588;
            for (j = 0; j < 4; ++j) {
                bytes[11 - j] = (byte)n;
                n >>>= 8;
            }
            vector10.start[i] = start;
            vector10.length[i] = 12;
            start += 12;
            out.write(bytes);
        }
        vector10.buffer = out.toByteArray();
        TimestampColumnVector col10 = new TimestampColumnVector(){

            public TimestampData getTimestamp(int colId, int precision) {
                byte[] bytes = vector10.getBytes(colId).getBytes();
                assert (bytes.length == 12);
                long nanoOfDay = 0L;
                for (int i = 0; i < 8; ++i) {
                    nanoOfDay <<= 8;
                    nanoOfDay |= (long)(bytes[i] & 0xFF);
                }
                int julianDay = 0;
                for (int i = 8; i < 12; ++i) {
                    julianDay <<= 8;
                    julianDay |= bytes[i] & 0xFF;
                }
                long millisecond = (long)(julianDay - 2440588) * 86400000L + nanoOfDay / 1000000L;
                int nanoOfMillisecond = (int)(nanoOfDay % 1000000L);
                return TimestampData.fromEpochMillis((long)millisecond, (int)nanoOfMillisecond);
            }

            public boolean isNullAt(int i) {
                return false;
            }
        };
        final long[] vector11 = new long[1024];
        DecimalColumnVector col11 = new DecimalColumnVector(){

            public boolean isNullAt(int i) {
                return false;
            }

            public DecimalData getDecimal(int i, int precision, int scale) {
                return DecimalData.fromUnscaledLong((long)vector11[i], (int)precision, (int)scale);
            }
        };
        for (i = 0; i < 1024; ++i) {
            vector11[i] = i;
        }
        final HeapIntVector col12Data = new HeapIntVector(3072);
        for (int i12 = 0; i12 < 3072; ++i12) {
            col12Data.vector[i12] = i12;
        }
        ArrayColumnVector col12 = new ArrayColumnVector(){

            public boolean isNullAt(int i) {
                return false;
            }

            public ArrayData getArray(int i) {
                return new ColumnarArrayData((ColumnVector)col12Data, i * 3, 3);
            }
        };
        VectorizedColumnBatch batch = new VectorizedColumnBatch(new ColumnVector[]{col0, col1, col2, col3, col4, col5, col6, col7, col8, col9, col10, col11, col12});
        batch.setNumRows(1024);
        for (int i13 = 0; i13 < batch.getNumRows(); ++i13) {
            ColumnarRowData row = new ColumnarRowData(batch, i13);
            Assert.assertEquals((Object)row.getBoolean(0), (Object)(i13 % 2 == 0 ? 1 : 0));
            Assert.assertEquals((Object)row.getString(1).toString(), (Object)String.valueOf(i13));
            Assert.assertEquals((long)row.getByte(2), (long)((byte)i13));
            Assert.assertEquals((double)row.getDouble(3), (double)i13, (double)0.0);
            Assert.assertEquals((float)row.getFloat(4), (float)i13, (float)0.0f);
            Assert.assertEquals((long)row.getInt(5), (long)i13);
            Assert.assertEquals((long)row.getLong(6), (long)i13);
            Assert.assertEquals((long)row.getShort(7), (long)((short)i13));
            Assert.assertEquals((long)row.getTimestamp(8, 3).getMillisecond(), (long)i13);
            Assert.assertEquals((long)row.getTimestamp(9, 6).getMillisecond(), (long)i13);
            Assert.assertEquals((long)row.getTimestamp(10, 9).getMillisecond(), (long)((long)i13 * 1000L + 123L));
            Assert.assertEquals((long)row.getTimestamp(10, 9).getNanoOfMillisecond(), (long)456789L);
            Assert.assertEquals((long)row.getDecimal(11, 10, 0).toUnscaledLong(), (long)i13);
            for (j = 0; j < 3; ++j) {
                Assert.assertEquals((long)row.getArray(12).getInt(j), (long)(i13 * 3 + j));
            }
        }
        Assert.assertEquals((long)1024L, (long)batch.getNumRows());
    }

    @Test
    public void testNull() {
        HeapIntVector col0 = new HeapIntVector(1024);
        for (int i = 0; i < 1024; ++i) {
            col0.setNullAt(i);
        }
        HeapIntVector col1 = new HeapIntVector(1024);
        for (int i = 0; i < 1024; ++i) {
            if (i % 2 == 0) {
                col1.setNullAt(i);
                continue;
            }
            col1.vector[i] = i;
        }
        VectorizedColumnBatch batch = new VectorizedColumnBatch(new ColumnVector[]{col0, col1});
        for (int i = 0; i < 1024; ++i) {
            ColumnarRowData row = new ColumnarRowData(batch, i);
            Assert.assertTrue((boolean)row.isNullAt(0));
            if (i % 2 == 0) {
                Assert.assertTrue((boolean)row.isNullAt(1));
                continue;
            }
            Assert.assertEquals((long)row.getInt(1), (long)i);
        }
    }

    @Test
    public void testDictionary() {
        HeapIntVector col = new HeapIntVector(1024);
        Object[] dict = new Integer[]{1998, 9998};
        col.setDictionary((Dictionary)new ColumnVectorTest.TestDictionary(dict));
        HeapIntVector heapIntVector = col.reserveDictionaryIds(1024);
        for (int i = 0; i < 1024; ++i) {
            heapIntVector.vector[i] = i % 2 == 0 ? 0 : 1;
        }
        VectorizedColumnBatch batch = new VectorizedColumnBatch(new ColumnVector[]{col});
        for (int i = 0; i < 1024; ++i) {
            ColumnarRowData row = new ColumnarRowData(batch, i);
            if (i % 2 == 0) {
                Assert.assertEquals((long)row.getInt(0), (long)1998L);
                continue;
            }
            Assert.assertEquals((long)row.getInt(0), (long)9998L);
        }
    }
}

