/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.runtime.typeutils.DecimalDataSerializer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeQueryable;

@Internal
public class DecimalDataTypeInfo
extends TypeInformation<DecimalData>
implements DataTypeQueryable {
    private static final long serialVersionUID = 1L;
    private final int precision;
    private final int scale;

    public static DecimalDataTypeInfo of(int precision, int scale) {
        return new DecimalDataTypeInfo(precision, scale);
    }

    public DecimalDataTypeInfo(int precision, int scale) {
        this.precision = precision;
        this.scale = scale;
    }

    public DataType getDataType() {
        return (DataType)DataTypes.DECIMAL((int)this.precision, (int)this.scale).bridgedTo(DecimalData.class);
    }

    public boolean isBasicType() {
        return true;
    }

    public boolean isTupleType() {
        return false;
    }

    public int getArity() {
        return 1;
    }

    public int getTotalFields() {
        return 1;
    }

    public Class<DecimalData> getTypeClass() {
        return DecimalData.class;
    }

    public boolean isKeyType() {
        return true;
    }

    public TypeSerializer<DecimalData> createSerializer(ExecutionConfig config) {
        return new DecimalDataSerializer(this.precision, this.scale);
    }

    public String toString() {
        return String.format("Decimal(%d,%d)", this.precision, this.scale);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DecimalDataTypeInfo)) {
            return false;
        }
        DecimalDataTypeInfo that = (DecimalDataTypeInfo)((Object)obj);
        return this.precision == that.precision && this.scale == that.scale;
    }

    public int hashCode() {
        int h0 = ((Object)((Object)this)).getClass().getCanonicalName().hashCode();
        return Arrays.hashCode(new int[]{h0, this.precision, this.scale});
    }

    public boolean canEqual(Object obj) {
        return obj instanceof DecimalDataTypeInfo;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }
}

