/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.window;

import java.time.ZoneId;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceTableAggsHandleFunction;
import org.apache.flink.table.runtime.generated.NamespaceTableAggsHandleFunction;
import org.apache.flink.table.runtime.operators.window.Window;
import org.apache.flink.table.runtime.operators.window.WindowOperator;
import org.apache.flink.table.runtime.operators.window.assigners.WindowAssigner;
import org.apache.flink.table.runtime.operators.window.triggers.Trigger;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.Collector;

public class TableAggregateWindowOperator<K, W extends Window>
extends WindowOperator<K, W> {
    private static final long serialVersionUID = 1L;
    private NamespaceTableAggsHandleFunction<W> tableAggWindowAggregator;
    private GeneratedNamespaceTableAggsHandleFunction<W> generatedTableAggWindowAggregator;

    TableAggregateWindowOperator(NamespaceTableAggsHandleFunction<W> windowTableAggregator, WindowAssigner<W> windowAssigner, Trigger<W> trigger, TypeSerializer<W> windowSerializer, LogicalType[] inputFieldTypes, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes, int rowtimeIndex, boolean produceUpdates, long allowedLateness, ZoneId shiftTimeZone) {
        super(windowTableAggregator, windowAssigner, trigger, windowSerializer, inputFieldTypes, accumulatorTypes, aggResultTypes, windowPropertyTypes, rowtimeIndex, produceUpdates, allowedLateness, shiftTimeZone);
        this.tableAggWindowAggregator = windowTableAggregator;
    }

    TableAggregateWindowOperator(GeneratedNamespaceTableAggsHandleFunction<W> generatedTableAggWindowAggregator, WindowAssigner<W> windowAssigner, Trigger<W> trigger, TypeSerializer<W> windowSerializer, LogicalType[] inputFieldTypes, LogicalType[] accumulatorTypes, LogicalType[] aggResultTypes, LogicalType[] windowPropertyTypes, int rowtimeIndex, boolean sendRetraction, long allowedLateness, ZoneId shiftTimeZone) {
        super(windowAssigner, trigger, windowSerializer, inputFieldTypes, accumulatorTypes, aggResultTypes, windowPropertyTypes, rowtimeIndex, sendRetraction, allowedLateness, shiftTimeZone);
        this.generatedTableAggWindowAggregator = generatedTableAggWindowAggregator;
    }

    @Override
    protected void compileGeneratedCode() {
        if (this.generatedTableAggWindowAggregator != null) {
            this.tableAggWindowAggregator = (NamespaceTableAggsHandleFunction)this.generatedTableAggWindowAggregator.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
            this.windowAggregator = this.tableAggWindowAggregator;
        }
    }

    @Override
    protected void emitWindowResult(W window) throws Exception {
        this.windowFunction.prepareAggregateAccumulatorForEmit(window);
        this.tableAggWindowAggregator.emitValue(window, (RowData)this.getCurrentKey(), (Collector<RowData>)this.collector);
    }
}

