/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.filesystem.stream.compact;

import java.io.IOException;
import java.util.UUID;
import org.apache.flink.connector.file.src.FileSourceSplit;
import org.apache.flink.connector.file.src.reader.BulkFormat;
import org.apache.flink.connector.file.src.util.RecordAndPosition;
import org.apache.flink.table.filesystem.stream.compact.CompactContext;
import org.apache.flink.table.filesystem.stream.compact.CompactReader;

public class CompactBulkReader<T>
implements CompactReader<T> {
    private final BulkFormat.Reader<T> reader;
    private BulkFormat.RecordIterator<T> iterator;

    public CompactBulkReader(BulkFormat.Reader<T> reader) throws IOException {
        this.reader = reader;
        this.iterator = reader.readBatch();
    }

    @Override
    public T read() throws IOException {
        if (this.iterator == null) {
            return null;
        }
        RecordAndPosition record = this.iterator.next();
        if (record != null) {
            return (T)record.getRecord();
        }
        this.iterator.releaseBatch();
        this.iterator = this.reader.readBatch();
        return this.read();
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public static <T> CompactReader.Factory<T> factory(BulkFormat<T, FileSourceSplit> format) {
        return new Factory<T>(format);
    }

    private static class Factory<T>
    implements CompactReader.Factory<T> {
        private static final long serialVersionUID = 1L;
        private final BulkFormat<T, FileSourceSplit> format;

        public Factory(BulkFormat<T, FileSourceSplit> format) {
            this.format = format;
        }

        @Override
        public CompactReader<T> create(CompactContext context) throws IOException {
            String splitId = UUID.randomUUID().toString();
            long len = context.getFileSystem().getFileStatus(context.getPath()).getLen();
            return new CompactBulkReader(this.format.createReader(context.getConfig(), new FileSourceSplit(splitId, context.getPath(), 0L, len)));
        }
    }
}

