/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinaryStringData;
import org.apache.flink.table.data.binary.BinaryStringDataUtil;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.apache.flink.table.runtime.util.StringUtf8Utils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BinaryStringDataTest {
    private BinaryStringData empty = this.fromString("");
    private final Mode mode;

    public BinaryStringDataTest(Mode mode) {
        this.mode = mode;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Mode> getVarSeg() {
        return Arrays.asList(Mode.ONE_SEG, Mode.MULTI_SEGS, Mode.STRING, Mode.RANDOM);
    }

    private BinaryStringData fromString(String str) {
        BinaryStringData string = BinaryStringData.fromString((String)str);
        Mode mode = this.mode;
        if (mode == Mode.RANDOM) {
            int rnd = new Random().nextInt(3);
            if (rnd == 0) {
                mode = Mode.ONE_SEG;
            } else if (rnd == 1) {
                mode = Mode.MULTI_SEGS;
            } else if (rnd == 2) {
                mode = Mode.STRING;
            }
        }
        if (mode == Mode.STRING) {
            return string;
        }
        if (mode == Mode.ONE_SEG || string.getSizeInBytes() < 2) {
            string.ensureMaterialized();
            return string;
        }
        int numBytes = string.getSizeInBytes();
        int pad = new Random().nextInt(5);
        int numBytesWithPad = numBytes + pad;
        int segSize = numBytesWithPad / 2 + 1;
        byte[] bytes1 = new byte[segSize];
        byte[] bytes2 = new byte[segSize];
        if (segSize - pad > 0 && numBytes >= segSize - pad) {
            string.getSegments()[0].get(0, bytes1, pad, segSize - pad);
        }
        string.getSegments()[0].get(segSize - pad, bytes2, 0, numBytes - segSize + pad);
        return BinaryStringData.fromAddress((MemorySegment[])new MemorySegment[]{MemorySegmentFactory.wrap((byte[])bytes1), MemorySegmentFactory.wrap((byte[])bytes2)}, (int)pad, (int)numBytes);
    }

    private void checkBasic(String str, int len) {
        BinaryStringData s1 = this.fromString(str);
        BinaryStringData s2 = BinaryStringData.fromBytes((byte[])str.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((long)s1.numChars(), (long)len);
        Assert.assertEquals((long)s2.numChars(), (long)len);
        Assert.assertEquals((Object)s1.toString(), (Object)str);
        Assert.assertEquals((Object)s2.toString(), (Object)str);
        Assert.assertEquals((Object)s1, (Object)s2);
        Assert.assertEquals((long)s1.hashCode(), (long)s2.hashCode());
        Assert.assertEquals((long)0L, (long)s1.compareTo((StringData)s2));
        Assert.assertTrue((boolean)s1.contains(s2));
        Assert.assertTrue((boolean)s2.contains(s1));
        Assert.assertTrue((boolean)s1.startsWith(s1));
        Assert.assertTrue((boolean)s1.endsWith(s1));
    }

    @Test
    public void basicTest() {
        this.checkBasic("", 0);
        this.checkBasic(",", 1);
        this.checkBasic("hello", 5);
        this.checkBasic("hello world", 11);
        this.checkBasic("Flink\u4e2d\u6587\u793e\u533a", 9);
        this.checkBasic("\u4e2d \u6587 \u793e \u533a", 7);
        this.checkBasic("\u00a1", 1);
        this.checkBasic("\u043a\u0443", 2);
        this.checkBasic("\ufe3d\ufe4b\uff05", 3);
        this.checkBasic("\ud83e\udd19", 1);
    }

    @Test
    public void emptyStringTest() {
        Assert.assertEquals((Object)this.empty, (Object)this.fromString(""));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringData.fromBytes((byte[])new byte[0]));
        Assert.assertEquals((long)0L, (long)this.empty.numChars());
        Assert.assertEquals((long)0L, (long)this.empty.getSizeInBytes());
    }

    @Test
    public void compareTo() {
        Assert.assertEquals((long)0L, (long)this.fromString("   ").compareTo((StringData)BinaryStringData.blankString((int)3)));
        Assert.assertTrue((this.fromString("").compareTo((StringData)this.fromString("a")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("abc").compareTo((StringData)this.fromString("ABC")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("abc0").compareTo((StringData)this.fromString("abc")) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)this.fromString("abcabcabc").compareTo((StringData)this.fromString("abcabcabc")));
        Assert.assertTrue((this.fromString("aBcabcabc").compareTo((StringData)this.fromString("Abcabcabc")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("Abcabcabc").compareTo((StringData)this.fromString("abcabcabC")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("abcabcabc").compareTo((StringData)this.fromString("abcabcabC")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("abc").compareTo((StringData)this.fromString("\u4e16\u754c")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("\u4f60\u597d").compareTo((StringData)this.fromString("\u4e16\u754c")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((this.fromString("\u4f60\u597d123").compareTo((StringData)this.fromString("\u4f60\u597d122")) > 0 ? 1 : 0) != 0);
        MemorySegment segment1 = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        MemorySegment segment2 = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        SortUtil.putStringNormalizedKey((StringData)this.fromString("abcabcabc"), (MemorySegment)segment1, (int)0, (int)9);
        SortUtil.putStringNormalizedKey((StringData)this.fromString("abcabcabC"), (MemorySegment)segment2, (int)0, (int)9);
        Assert.assertTrue((segment1.compare(segment2, 0, 0, 9) > 0 ? 1 : 0) != 0);
        SortUtil.putStringNormalizedKey((StringData)this.fromString("abcab"), (MemorySegment)segment1, (int)0, (int)9);
        Assert.assertTrue((segment1.compare(segment2, 0, 0, 9) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testMultiSegments() {
        MemorySegment[] segments1 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[10]), MemorySegmentFactory.wrap((byte[])new byte[10])};
        segments1[0].put(5, "abcde".getBytes(StandardCharsets.UTF_8), 0, 5);
        segments1[1].put(0, "aaaaa".getBytes(StandardCharsets.UTF_8), 0, 5);
        MemorySegment[] segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[5]), MemorySegmentFactory.wrap((byte[])new byte[5])};
        segments2[0].put(0, "abcde".getBytes(StandardCharsets.UTF_8), 0, 5);
        segments2[1].put(0, "b".getBytes(StandardCharsets.UTF_8), 0, 1);
        BinaryStringData binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)5, (int)10);
        BinaryStringData binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)0, (int)6);
        Assert.assertEquals((Object)"abcdeaaaaa", (Object)binaryString1.toString());
        Assert.assertEquals((Object)"abcdeb", (Object)binaryString2.toString());
        Assert.assertEquals((long)-1L, (long)binaryString1.compareTo((StringData)binaryString2));
        binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)5, (int)5);
        binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)0, (int)5);
        Assert.assertEquals((Object)"abcde", (Object)binaryString1.toString());
        Assert.assertEquals((Object)"abcde", (Object)binaryString2.toString());
        Assert.assertEquals((long)0L, (long)binaryString1.compareTo((StringData)binaryString2));
        binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)10, (int)5);
        binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)0, (int)5);
        Assert.assertEquals((Object)"aaaaa", (Object)binaryString1.toString());
        Assert.assertEquals((Object)"abcde", (Object)binaryString2.toString());
        Assert.assertEquals((long)-1L, (long)binaryString1.compareTo((StringData)binaryString2));
        Assert.assertEquals((long)1L, (long)binaryString2.compareTo((StringData)binaryString1));
        segments2 = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[10])};
        segments2[0].put(4, "abcdeb".getBytes(StandardCharsets.UTF_8), 0, 6);
        binaryString1 = BinaryStringData.fromAddress((MemorySegment[])segments1, (int)5, (int)10);
        binaryString2 = BinaryStringData.fromAddress((MemorySegment[])segments2, (int)4, (int)6);
        Assert.assertEquals((Object)"abcdeaaaaa", (Object)binaryString1.toString());
        Assert.assertEquals((Object)"abcdeb", (Object)binaryString2.toString());
        Assert.assertEquals((long)-1L, (long)binaryString1.compareTo((StringData)binaryString2));
        Assert.assertEquals((long)1L, (long)binaryString2.compareTo((StringData)binaryString1));
    }

    @Test
    public void concatTest() {
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[0]));
        Assert.assertEquals(null, (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{null}));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.empty}));
        Assert.assertEquals((Object)this.fromString("ab"), (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("ab")}));
        Assert.assertEquals((Object)this.fromString("ab"), (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b")}));
        Assert.assertEquals((Object)this.fromString("abc"), (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b"), this.fromString("c")}));
        Assert.assertEquals(null, (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, this.fromString("c")}));
        Assert.assertEquals(null, (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, null}));
        Assert.assertEquals(null, (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{null, null, null}));
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u7816\u5934"), (Object)BinaryStringDataUtil.concat((BinaryStringData[])new BinaryStringData[]{this.fromString("\u6570\u636e"), this.fromString("\u7816\u5934")}));
    }

    @Test
    public void concatWsTest() {
        Assert.assertEquals(null, (Object)BinaryStringDataUtil.concatWs(null, (BinaryStringData[])new BinaryStringData[]{null}));
        Assert.assertEquals(null, (Object)BinaryStringDataUtil.concatWs(null, (BinaryStringData[])new BinaryStringData[]{this.fromString("a")}));
        BinaryStringData sep = this.fromString("\u54c8\u54c8");
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.empty}));
        Assert.assertEquals((Object)this.fromString("ab"), (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("ab")}));
        Assert.assertEquals((Object)this.fromString("a\u54c8\u54c8b"), (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b")}));
        Assert.assertEquals((Object)this.fromString("a\u54c8\u54c8b\u54c8\u54c8c"), (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), this.fromString("b"), this.fromString("c")}));
        Assert.assertEquals((Object)this.fromString("a\u54c8\u54c8c"), (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, this.fromString("c")}));
        Assert.assertEquals((Object)this.fromString("a"), (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("a"), null, null}));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{null, null, null}));
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u54c8\u54c8\u7816\u5934"), (Object)BinaryStringDataUtil.concatWs((BinaryStringData)sep, (BinaryStringData[])new BinaryStringData[]{this.fromString("\u6570\u636e"), this.fromString("\u7816\u5934")}));
    }

    @Test
    public void contains() {
        Assert.assertTrue((boolean)this.empty.contains(this.empty));
        Assert.assertTrue((boolean)this.fromString("hello").contains(this.fromString("ello")));
        Assert.assertFalse((boolean)this.fromString("hello").contains(this.fromString("vello")));
        Assert.assertFalse((boolean)this.fromString("hello").contains(this.fromString("hellooo")));
        Assert.assertTrue((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u5343\u4e16\u754c")));
        Assert.assertFalse((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u4e16\u5343")));
        Assert.assertFalse((boolean)this.fromString("\u5927\u5343\u4e16\u754c").contains(this.fromString("\u5927\u5343\u4e16\u754c\u597d")));
    }

    @Test
    public void startsWith() {
        Assert.assertTrue((boolean)this.empty.startsWith(this.empty));
        Assert.assertTrue((boolean)this.fromString("hello").startsWith(this.fromString("hell")));
        Assert.assertFalse((boolean)this.fromString("hello").startsWith(this.fromString("ell")));
        Assert.assertFalse((boolean)this.fromString("hello").startsWith(this.fromString("hellooo")));
        Assert.assertTrue((boolean)this.fromString("\u6570\u636e\u7816\u5934").startsWith(this.fromString("\u6570\u636e")));
        Assert.assertFalse((boolean)this.fromString("\u5927\u5343\u4e16\u754c").startsWith(this.fromString("\u5343")));
        Assert.assertFalse((boolean)this.fromString("\u5927\u5343\u4e16\u754c").startsWith(this.fromString("\u5927\u5343\u4e16\u754c\u597d")));
    }

    @Test
    public void endsWith() {
        Assert.assertTrue((boolean)this.empty.endsWith(this.empty));
        Assert.assertTrue((boolean)this.fromString("hello").endsWith(this.fromString("ello")));
        Assert.assertFalse((boolean)this.fromString("hello").endsWith(this.fromString("ellov")));
        Assert.assertFalse((boolean)this.fromString("hello").endsWith(this.fromString("hhhello")));
        Assert.assertTrue((boolean)this.fromString("\u5927\u5343\u4e16\u754c").endsWith(this.fromString("\u4e16\u754c")));
        Assert.assertFalse((boolean)this.fromString("\u5927\u5343\u4e16\u754c").endsWith(this.fromString("\u4e16")));
        Assert.assertFalse((boolean)this.fromString("\u6570\u636e\u7816\u5934").endsWith(this.fromString("\u6211\u7684\u6570\u636e\u7816\u5934")));
    }

    @Test
    public void substring() {
        Assert.assertEquals((Object)this.empty, (Object)this.fromString("hello").substring(0, 0));
        Assert.assertEquals((Object)this.fromString("el"), (Object)this.fromString("hello").substring(1, 3));
        Assert.assertEquals((Object)this.fromString("\u6570"), (Object)this.fromString("\u6570\u636e\u7816\u5934").substring(0, 1));
        Assert.assertEquals((Object)this.fromString("\u636e\u7816"), (Object)this.fromString("\u6570\u636e\u7816\u5934").substring(1, 3));
        Assert.assertEquals((Object)this.fromString("\u5934"), (Object)this.fromString("\u6570\u636e\u7816\u5934").substring(3, 5));
        Assert.assertEquals((Object)this.fromString("\u07f5\u68b7"), (Object)this.fromString("\u07f5\u68b7").substring(0, 2));
    }

    @Test
    public void trims() {
        Assert.assertEquals((Object)this.fromString("1"), (Object)this.fromString("1").trim());
        Assert.assertEquals((Object)this.fromString("hello"), (Object)this.fromString("  hello ").trim());
        Assert.assertEquals((Object)this.fromString("hello "), (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("  hello ")));
        Assert.assertEquals((Object)this.fromString("  hello"), (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("  hello ")));
        Assert.assertEquals((Object)this.fromString("  hello "), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)false, (boolean)false, (BinaryStringData)this.fromString(" ")));
        Assert.assertEquals((Object)this.fromString("hello"), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)true, (boolean)true, (BinaryStringData)this.fromString(" ")));
        Assert.assertEquals((Object)this.fromString("hello "), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)true, (boolean)false, (BinaryStringData)this.fromString(" ")));
        Assert.assertEquals((Object)this.fromString("  hello"), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("  hello "), (boolean)false, (boolean)true, (BinaryStringData)this.fromString(" ")));
        Assert.assertEquals((Object)this.fromString("hello"), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("xxxhellox"), (boolean)true, (boolean)true, (BinaryStringData)this.fromString("x")));
        Assert.assertEquals((Object)this.fromString("ell"), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("xxxhellox"), (BinaryStringData)this.fromString("xoh")));
        Assert.assertEquals((Object)this.fromString("ellox"), (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("xxxhellox"), (BinaryStringData)this.fromString("xoh")));
        Assert.assertEquals((Object)this.fromString("xxxhell"), (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("xxxhellox"), (BinaryStringData)this.fromString("xoh")));
        Assert.assertEquals((Object)this.empty, (Object)this.empty.trim());
        Assert.assertEquals((Object)this.empty, (Object)this.fromString("  ").trim());
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("  ")));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("  ")));
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u7816\u5934"), (Object)this.fromString("  \u6570\u636e\u7816\u5934 ").trim());
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u7816\u5934 "), (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("  \u6570\u636e\u7816\u5934 ")));
        Assert.assertEquals((Object)this.fromString("  \u6570\u636e\u7816\u5934"), (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("  \u6570\u636e\u7816\u5934 ")));
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u7816\u5934"), (Object)this.fromString("\u6570\u636e\u7816\u5934").trim());
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u7816\u5934"), (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("\u6570\u636e\u7816\u5934")));
        Assert.assertEquals((Object)this.fromString("\u6570\u636e\u7816\u5934"), (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("\u6570\u636e\u7816\u5934")));
        Assert.assertEquals((Object)this.fromString(","), (Object)BinaryStringDataUtil.trim((BinaryStringData)this.fromString("\u5e74\u5e74\u5c81\u5c81, \u5c81\u5c81\u5e74\u5e74"), (BinaryStringData)this.fromString("\u5e74\u5c81 ")));
        Assert.assertEquals((Object)this.fromString(", \u5c81\u5c81\u5e74\u5e74"), (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString("\u5e74\u5e74\u5c81\u5c81, \u5c81\u5c81\u5e74\u5e74"), (BinaryStringData)this.fromString("\u5e74\u5c81 ")));
        Assert.assertEquals((Object)this.fromString("\u5e74\u5e74\u5c81\u5c81,"), (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString("\u5e74\u5e74\u5c81\u5c81, \u5c81\u5c81\u5e74\u5e74"), (BinaryStringData)this.fromString("\u5e74\u5c81 ")));
        char[] charsLessThan0x20 = new char[10];
        Arrays.fill(charsLessThan0x20, '\u001f');
        String stringStartingWithSpace = new String(charsLessThan0x20) + "hello" + new String(charsLessThan0x20);
        Assert.assertEquals((Object)this.fromString(stringStartingWithSpace), (Object)this.fromString(stringStartingWithSpace).trim());
        Assert.assertEquals((Object)this.fromString(stringStartingWithSpace), (Object)BinaryStringDataUtil.trimLeft((BinaryStringData)this.fromString(stringStartingWithSpace)));
        Assert.assertEquals((Object)this.fromString(stringStartingWithSpace), (Object)BinaryStringDataUtil.trimRight((BinaryStringData)this.fromString(stringStartingWithSpace)));
    }

    @Test
    public void testSqlSubstring() {
        Assert.assertEquals((Object)this.fromString("ello"), (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)2));
        Assert.assertEquals((Object)this.fromString("ell"), (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)2, (int)3));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.empty, (int)2, (int)3));
        Assert.assertNull((Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)0, (int)-1));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)10));
        Assert.assertEquals((Object)this.fromString("hel"), (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)0, (int)3));
        Assert.assertEquals((Object)this.fromString("lo"), (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)-2, (int)3));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.substringSQL((BinaryStringData)this.fromString("hello"), (int)-100, (int)3));
    }

    @Test
    public void reverseTest() {
        Assert.assertEquals((Object)this.fromString("olleh"), (Object)BinaryStringDataUtil.reverse((BinaryStringData)this.fromString("hello")));
        Assert.assertEquals((Object)this.fromString("\u56fd\u4e2d"), (Object)BinaryStringDataUtil.reverse((BinaryStringData)this.fromString("\u4e2d\u56fd")));
        Assert.assertEquals((Object)this.fromString("\u56fd\u4e2d ,olleh"), (Object)BinaryStringDataUtil.reverse((BinaryStringData)this.fromString("hello, \u4e2d\u56fd")));
        Assert.assertEquals((Object)this.empty, (Object)BinaryStringDataUtil.reverse((BinaryStringData)this.empty));
    }

    @Test
    public void indexOf() {
        Assert.assertEquals((long)0L, (long)this.empty.indexOf(this.empty, 0));
        Assert.assertEquals((long)-1L, (long)this.empty.indexOf(this.fromString("l"), 0));
        Assert.assertEquals((long)0L, (long)this.fromString("hello").indexOf(this.empty, 0));
        Assert.assertEquals((long)2L, (long)this.fromString("hello").indexOf(this.fromString("l"), 0));
        Assert.assertEquals((long)3L, (long)this.fromString("hello").indexOf(this.fromString("l"), 3));
        Assert.assertEquals((long)-1L, (long)this.fromString("hello").indexOf(this.fromString("a"), 0));
        Assert.assertEquals((long)2L, (long)this.fromString("hello").indexOf(this.fromString("ll"), 0));
        Assert.assertEquals((long)-1L, (long)this.fromString("hello").indexOf(this.fromString("ll"), 4));
        Assert.assertEquals((long)1L, (long)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u636e\u7816"), 0));
        Assert.assertEquals((long)-1L, (long)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u6570"), 3));
        Assert.assertEquals((long)0L, (long)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u6570"), 0));
        Assert.assertEquals((long)3L, (long)this.fromString("\u6570\u636e\u7816\u5934").indexOf(this.fromString("\u5934"), 0));
    }

    @Test
    public void testToNumeric() {
        Assert.assertEquals((Object)Byte.valueOf("123"), (Object)BinaryStringDataUtil.toByte((BinaryStringData)this.fromString("123")));
        Assert.assertEquals((Object)Byte.valueOf("123"), (Object)BinaryStringDataUtil.toByte((BinaryStringData)this.fromString("+123")));
        Assert.assertEquals((Object)Byte.valueOf("-123"), (Object)BinaryStringDataUtil.toByte((BinaryStringData)this.fromString("-123")));
        Assert.assertEquals((Object)Short.valueOf("123"), (Object)BinaryStringDataUtil.toShort((BinaryStringData)this.fromString("123")));
        Assert.assertEquals((Object)Short.valueOf("123"), (Object)BinaryStringDataUtil.toShort((BinaryStringData)this.fromString("+123")));
        Assert.assertEquals((Object)Short.valueOf("-123"), (Object)BinaryStringDataUtil.toShort((BinaryStringData)this.fromString("-123")));
        Assert.assertEquals((Object)Integer.valueOf("123"), (Object)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("123")));
        Assert.assertEquals((Object)Integer.valueOf("123"), (Object)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("+123")));
        Assert.assertEquals((Object)Integer.valueOf("-123"), (Object)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("-123")));
        Assert.assertEquals((Object)Long.valueOf("1234567890"), (Object)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("1234567890")));
        Assert.assertEquals((Object)Long.valueOf("+1234567890"), (Object)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("+1234567890")));
        Assert.assertEquals((Object)Long.valueOf("-1234567890"), (Object)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("-1234567890")));
        Assert.assertEquals((Object)Integer.valueOf("123"), (Object)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("123.456789")));
        Assert.assertEquals((Object)Long.valueOf("123"), (Object)BinaryStringDataUtil.toLong((BinaryStringData)this.fromString("123.456789")));
        Assert.assertNull((Object)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("1a3.456789")));
        Assert.assertNull((Object)BinaryStringDataUtil.toInt((BinaryStringData)this.fromString("123.a56789")));
        BinaryRowData row = new BinaryRowData(20);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, (StringData)BinaryStringData.fromString((String)"1"));
        writer.writeString(1, (StringData)BinaryStringData.fromString((String)"123"));
        writer.writeString(2, (StringData)BinaryStringData.fromString((String)"12345"));
        writer.writeString(3, (StringData)BinaryStringData.fromString((String)"123456789"));
        writer.complete();
        Assert.assertEquals((Object)Byte.valueOf("1"), (Object)BinaryStringDataUtil.toByte((BinaryStringData)((BinaryStringData)row.getString(0))));
        Assert.assertEquals((Object)Short.valueOf("123"), (Object)BinaryStringDataUtil.toShort((BinaryStringData)((BinaryStringData)row.getString(1))));
        Assert.assertEquals((Object)Integer.valueOf("12345"), (Object)BinaryStringDataUtil.toInt((BinaryStringData)((BinaryStringData)row.getString(2))));
        Assert.assertEquals((Object)Long.valueOf("123456789"), (Object)BinaryStringDataUtil.toLong((BinaryStringData)((BinaryStringData)row.getString(3))));
    }

    @Test
    public void testToUpperLowerCase() {
        Assert.assertEquals((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"), (Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba").toLowerCase());
        Assert.assertEquals((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"), (Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba").toUpperCase());
        Assert.assertEquals((Object)this.fromString("abcdefg"), (Object)this.fromString("aBcDeFg").toLowerCase());
        Assert.assertEquals((Object)this.fromString("ABCDEFG"), (Object)this.fromString("aBcDeFg").toUpperCase());
        Assert.assertEquals((Object)this.fromString("!@#$%^*"), (Object)this.fromString("!@#$%^*").toLowerCase());
        Assert.assertEquals((Object)this.fromString("!@#$%^*"), (Object)this.fromString("!@#$%^*").toLowerCase());
        BinaryRowData row = new BinaryRowData(20);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        writer.writeString(0, (StringData)BinaryStringData.fromString((String)"a"));
        writer.writeString(1, (StringData)BinaryStringData.fromString((String)"\u6211\u662f\u4e2d\u56fd\u4eba"));
        writer.writeString(3, (StringData)BinaryStringData.fromString((String)"aBcDeFg"));
        writer.writeString(5, (StringData)BinaryStringData.fromString((String)"!@#$%^*"));
        writer.complete();
        Assert.assertEquals((Object)this.fromString("A"), (Object)((BinaryStringData)row.getString(0)).toUpperCase());
        Assert.assertEquals((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"), (Object)((BinaryStringData)row.getString(1)).toUpperCase());
        Assert.assertEquals((Object)this.fromString("\u6211\u662f\u4e2d\u56fd\u4eba"), (Object)((BinaryStringData)row.getString(1)).toLowerCase());
        Assert.assertEquals((Object)this.fromString("ABCDEFG"), (Object)((BinaryStringData)row.getString(3)).toUpperCase());
        Assert.assertEquals((Object)this.fromString("abcdefg"), (Object)((BinaryStringData)row.getString(3)).toLowerCase());
        Assert.assertEquals((Object)this.fromString("!@#$%^*"), (Object)((BinaryStringData)row.getString(5)).toUpperCase());
        Assert.assertEquals((Object)this.fromString("!@#$%^*"), (Object)((BinaryStringData)row.getString(5)).toLowerCase());
    }

    @Test
    public void testToDecimal() {
        int i;
        class DecimalTestData {
            private String str;
            private int precision;
            private int scale;

            DecimalTestData(String str, int precision, int scale) {
                this.str = str;
                this.precision = precision;
                this.scale = scale;
            }
        }
        DecimalTestData[] data;
        for (DecimalTestData d : data = new DecimalTestData[]{new DecimalTestData("12.345", 5, 3), new DecimalTestData("-12.345", 5, 3), new DecimalTestData("+12345", 5, 0), new DecimalTestData("-12345", 5, 0), new DecimalTestData("12345.", 5, 0), new DecimalTestData("-12345.", 5, 0), new DecimalTestData(".12345", 5, 5), new DecimalTestData("-.12345", 5, 5), new DecimalTestData("+12.345E3", 5, 0), new DecimalTestData("-12.345e3", 5, 0), new DecimalTestData("12.345e-3", 6, 6), new DecimalTestData("-12.345E-3", 6, 6), new DecimalTestData("12345E3", 8, 0), new DecimalTestData("-12345e3", 8, 0), new DecimalTestData("12345e-3", 5, 3), new DecimalTestData("-12345E-3", 5, 3), new DecimalTestData("+.12345E3", 5, 2), new DecimalTestData("-.12345e3", 5, 2), new DecimalTestData(".12345e-3", 8, 8), new DecimalTestData("-.12345E-3", 8, 8), new DecimalTestData("1234512345.1234", 18, 8), new DecimalTestData("-1234512345.1234", 18, 8), new DecimalTestData("1234512345.1234", 12, 2), new DecimalTestData("-1234512345.1234", 12, 2), new DecimalTestData("1234512345.1299", 12, 2), new DecimalTestData("-1234512345.1299", 12, 2), new DecimalTestData("999999999999999999", 18, 0), new DecimalTestData("1234512345.1234512345", 20, 10), new DecimalTestData("-1234512345.1234512345", 20, 10), new DecimalTestData("1234512345.1234512345", 15, 5), new DecimalTestData("-1234512345.1234512345", 15, 5), new DecimalTestData("12345123451234512345E-10", 20, 10), new DecimalTestData("-12345123451234512345E-10", 20, 10), new DecimalTestData("12345123451234512345E-10", 15, 5), new DecimalTestData("-12345123451234512345E-10", 15, 5), new DecimalTestData("999999999999999999999", 21, 0), new DecimalTestData("-999999999999999999999", 21, 0), new DecimalTestData("0.00000000000000000000123456789123456789", 38, 38), new DecimalTestData("-0.00000000000000000000123456789123456789", 38, 38), new DecimalTestData("0.00000000000000000000123456789123456789", 29, 29), new DecimalTestData("-0.00000000000000000000123456789123456789", 29, 29), new DecimalTestData("123456789123E-27", 18, 18), new DecimalTestData("-123456789123E-27", 18, 18), new DecimalTestData("123456789999E-27", 18, 18), new DecimalTestData("-123456789999E-27", 18, 18), new DecimalTestData("123456789123456789E-36", 18, 18), new DecimalTestData("-123456789123456789E-36", 18, 18), new DecimalTestData("123456789999999999E-36", 18, 18), new DecimalTestData("-123456789999999999E-36", 18, 18)}) {
            Assert.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(d.str), (int)d.precision, (int)d.scale), (Object)BinaryStringDataUtil.toDecimal((BinaryStringData)this.fromString(d.str), (int)d.precision, (int)d.scale));
        }
        BinaryRowData row = new BinaryRowData(data.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (i = 0; i < data.length; ++i) {
            writer.writeString(i, (StringData)BinaryStringData.fromString((String)data[i].str));
        }
        writer.complete();
        for (i = 0; i < data.length; ++i) {
            DecimalTestData d;
            d = data[i];
            Assert.assertEquals((Object)DecimalData.fromBigDecimal((BigDecimal)new BigDecimal(d.str), (int)d.precision, (int)d.scale), (Object)BinaryStringDataUtil.toDecimal((BinaryStringData)((BinaryStringData)row.getString(i)), (int)d.precision, (int)d.scale));
        }
    }

    @Test
    public void testEmptyString() {
        BinaryStringData str2 = this.fromString("hahahahah");
        MemorySegment[] segments = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[10]), MemorySegmentFactory.wrap((byte[])new byte[10])};
        BinaryStringData str3 = BinaryStringData.fromAddress((MemorySegment[])segments, (int)15, (int)0);
        Assert.assertTrue((BinaryStringData.EMPTY_UTF8.compareTo((StringData)str2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((str2.compareTo((StringData)BinaryStringData.EMPTY_UTF8) > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)0L, (long)BinaryStringData.EMPTY_UTF8.compareTo((StringData)str3));
        Assert.assertEquals((long)0L, (long)str3.compareTo((StringData)BinaryStringData.EMPTY_UTF8));
        Assert.assertNotEquals((Object)BinaryStringData.EMPTY_UTF8, (Object)str2);
        Assert.assertNotEquals((Object)str2, (Object)BinaryStringData.EMPTY_UTF8);
        Assert.assertEquals((Object)BinaryStringData.EMPTY_UTF8, (Object)str3);
        Assert.assertEquals((Object)str3, (Object)BinaryStringData.EMPTY_UTF8);
    }

    @Test
    public void testEncodeWithIllegalCharacter() throws UnsupportedEncodingException {
        char[] chars = new char[]{'\u4e9a', '\u9ebb', '|', '\u957f', '\u8896', '|', '\u8fde', '\u8863', '\u88d9', '|', '\ud83d', '|', '\udc57'};
        String str = new String(chars);
        Assert.assertArrayEquals((byte[])str.getBytes("UTF-8"), (byte[])StringUtf8Utils.encodeUTF8((String)str));
    }

    @Test
    public void testKeyValue() {
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1|k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k3")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1|k2:v2|"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k3")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("|k1:v1|k2:v2|"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k3")));
        String tab = StringEscapeUtils.unescapeJava((String)"\t");
        Assert.assertEquals((Object)this.fromString("v2"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1" + tab + "k2:v2"), (byte)this.fromString("\t").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k2")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v1|k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), null));
        Assert.assertEquals((Object)this.fromString("v2"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2")));
        Assert.assertEquals((Object)this.fromString("v2"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("|k1=v1|k2=v2|"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2")));
        Assert.assertEquals((Object)this.fromString("v2"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1||k2=v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k2")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k=1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k=")));
        Assert.assertEquals((Object)this.fromString("=v1"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1==v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1==v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1=")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1=")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1")));
        Assert.assertNull((Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1=v1;k2=v2"), (byte)this.fromString(";").byteAt(0), (byte)this.fromString("=").byteAt(0), (BinaryStringData)this.fromString("k1k1k1k1k1k1k1k1k1k1")));
        Assert.assertEquals((Object)this.fromString("v2"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v||k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k2")));
        Assert.assertEquals((Object)this.fromString("v2"), (Object)BinaryStringDataUtil.keyValue((BinaryStringData)this.fromString("k1:v||k2:v2"), (byte)this.fromString("|").byteAt(0), (byte)this.fromString(":").byteAt(0), (BinaryStringData)this.fromString("k2")));
    }

    @Test
    public void testDecodeWithIllegalUtf8Bytes() throws UnsupportedEncodingException {
        byte[] bytes = new byte[]{-102, -69, 124, 127, -106, 124, -34, 99, -39, 124, 61, 124, 87};
        String str = new String(bytes, StandardCharsets.UTF_8);
        Assert.assertEquals((Object)str, (Object)StringUtf8Utils.decodeUTF8((byte[])bytes, (int)0, (int)bytes.length));
        Assert.assertEquals((Object)str, (Object)StringUtf8Utils.decodeUTF8((MemorySegment)MemorySegmentFactory.wrap((byte[])bytes), (int)0, (int)bytes.length));
        byte[] newBytes = new byte[bytes.length + 5];
        System.arraycopy(bytes, 0, newBytes, 5, bytes.length);
        Assert.assertEquals((Object)str, (Object)StringUtf8Utils.decodeUTF8((MemorySegment)MemorySegmentFactory.wrap((byte[])newBytes), (int)5, (int)bytes.length));
    }

    @Test
    public void skipWrongFirstByte() {
        int[] wrongFirstBytes = new int[]{128, 159, 191, 192, 194, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};
        byte[] c = new byte[1];
        for (int wrongFirstByte : wrongFirstBytes) {
            c[0] = (byte)wrongFirstByte;
            Assert.assertEquals((long)BinaryStringData.fromBytes((byte[])c).numChars(), (long)1L);
        }
    }

    @Test
    public void testSplit() {
        Assert.assertArrayEquals((Object[])BinaryStringDataUtil.EMPTY_STRING_ARRAY, (Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString(""), (BinaryStringData)this.fromString("")));
        Assert.assertArrayEquals((Object[])new BinaryStringData[]{this.fromString("ab"), this.fromString("de"), this.fromString("fg")}, (Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab de fg"), null));
        Assert.assertArrayEquals((Object[])new BinaryStringData[]{this.fromString("ab"), this.fromString(""), this.fromString(""), this.fromString("de"), this.fromString("fg")}, (Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab   de fg"), null));
        Assert.assertArrayEquals((Object[])new BinaryStringData[]{this.fromString("ab"), this.fromString("cd"), this.fromString("ef")}, (Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab:cd:ef"), (BinaryStringData)this.fromString(":")));
        Assert.assertArrayEquals((Object[])new BinaryStringData[]{this.fromString("ab"), this.fromString("cd"), this.fromString("ef")}, (Object[])BinaryStringDataUtil.splitByWholeSeparatorPreserveAllTokens((BinaryStringData)this.fromString("ab-!-cd-!-ef"), (BinaryStringData)this.fromString("-!-")));
    }

    @Test
    public void testLazy() {
        String javaStr = "haha";
        BinaryStringData str = BinaryStringData.fromString((String)javaStr);
        str.ensureMaterialized();
        Assert.assertSame((Object)str.toString(), (Object)javaStr);
    }

    private static enum Mode {
        ONE_SEG,
        MULTI_SEGS,
        STRING,
        RANDOM;

    }
}

