/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.aggregate.window;

import java.time.ZoneId;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedNamespaceAggsHandleFunction;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.RecordsWindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.buffers.WindowBuffer;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.AggRecordsCombiner;
import org.apache.flink.table.runtime.operators.aggregate.window.combines.GlobalAggAccCombiner;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.AbstractWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.SliceSharedWindowAggProcessor;
import org.apache.flink.table.runtime.operators.aggregate.window.processors.SliceUnsharedWindowAggProcessor;
import org.apache.flink.table.runtime.operators.window.combines.WindowCombineFunction;
import org.apache.flink.table.runtime.operators.window.slicing.SliceAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceSharedAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SliceUnsharedAssigner;
import org.apache.flink.table.runtime.operators.window.slicing.SlicingWindowOperator;
import org.apache.flink.table.runtime.typeutils.AbstractRowDataSerializer;
import org.apache.flink.table.runtime.typeutils.PagedTypeSerializer;
import org.apache.flink.util.Preconditions;

public class SlicingWindowAggOperatorBuilder {
    private SliceAssigner assigner;
    private AbstractRowDataSerializer<RowData> inputSerializer;
    private PagedTypeSerializer<RowData> keySerializer;
    private TypeSerializer<RowData> accSerializer;
    private GeneratedNamespaceAggsHandleFunction<Long> generatedAggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<Long> localGeneratedAggregateFunction;
    private GeneratedNamespaceAggsHandleFunction<Long> globalGeneratedAggregateFunction;
    private int indexOfCountStart = -1;
    private ZoneId shiftTimeZone;

    public static SlicingWindowAggOperatorBuilder builder() {
        return new SlicingWindowAggOperatorBuilder();
    }

    public SlicingWindowAggOperatorBuilder inputSerializer(AbstractRowDataSerializer<RowData> inputSerializer) {
        this.inputSerializer = inputSerializer;
        return this;
    }

    public SlicingWindowAggOperatorBuilder shiftTimeZone(ZoneId shiftTimeZone) {
        this.shiftTimeZone = shiftTimeZone;
        return this;
    }

    public SlicingWindowAggOperatorBuilder keySerializer(PagedTypeSerializer<RowData> keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public SlicingWindowAggOperatorBuilder assigner(SliceAssigner assigner) {
        this.assigner = assigner;
        return this;
    }

    public SlicingWindowAggOperatorBuilder aggregate(GeneratedNamespaceAggsHandleFunction<Long> generatedAggregateFunction, TypeSerializer<RowData> accSerializer) {
        this.generatedAggregateFunction = generatedAggregateFunction;
        this.accSerializer = accSerializer;
        return this;
    }

    public SlicingWindowAggOperatorBuilder globalAggregate(GeneratedNamespaceAggsHandleFunction<Long> localGeneratedAggregateFunction, GeneratedNamespaceAggsHandleFunction<Long> globalGeneratedAggregateFunction, GeneratedNamespaceAggsHandleFunction<Long> stateGeneratedAggregateFunction, TypeSerializer<RowData> accSerializer) {
        this.localGeneratedAggregateFunction = localGeneratedAggregateFunction;
        this.globalGeneratedAggregateFunction = globalGeneratedAggregateFunction;
        this.generatedAggregateFunction = stateGeneratedAggregateFunction;
        this.accSerializer = accSerializer;
        return this;
    }

    public SlicingWindowAggOperatorBuilder countStarIndex(int indexOfCountStart) {
        this.indexOfCountStart = indexOfCountStart;
        return this;
    }

    public SlicingWindowOperator<RowData, ?> build() {
        AbstractWindowAggProcessor windowProcessor;
        Preconditions.checkNotNull((Object)this.assigner);
        Preconditions.checkNotNull(this.inputSerializer);
        Preconditions.checkNotNull(this.keySerializer);
        Preconditions.checkNotNull(this.accSerializer);
        Preconditions.checkNotNull(this.generatedAggregateFunction);
        RecordsWindowBuffer.Factory bufferFactory = new RecordsWindowBuffer.Factory(this.keySerializer, this.inputSerializer);
        WindowCombineFunction.Factory combinerFactory = this.localGeneratedAggregateFunction != null && this.globalGeneratedAggregateFunction != null ? new GlobalAggAccCombiner.Factory(this.localGeneratedAggregateFunction, this.globalGeneratedAggregateFunction, this.keySerializer) : new AggRecordsCombiner.Factory(this.generatedAggregateFunction, this.keySerializer, this.inputSerializer);
        if (this.assigner instanceof SliceSharedAssigner) {
            windowProcessor = new SliceSharedWindowAggProcessor(this.generatedAggregateFunction, bufferFactory, combinerFactory, (SliceSharedAssigner)this.assigner, this.accSerializer, this.indexOfCountStart, this.shiftTimeZone);
        } else if (this.assigner instanceof SliceUnsharedAssigner) {
            windowProcessor = new SliceUnsharedWindowAggProcessor(this.generatedAggregateFunction, (WindowBuffer.Factory)bufferFactory, combinerFactory, (SliceUnsharedAssigner)this.assigner, this.accSerializer, this.shiftTimeZone);
        } else {
            throw new IllegalArgumentException("assigner must be instance of SliceUnsharedAssigner or SliceSharedAssigner.");
        }
        return new SlicingWindowOperator(windowProcessor);
    }
}

