/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.types.RowKind;

public class GenericRowRecordSortComparator
implements Comparator<GenericRowData>,
Serializable {
    private static final long serialVersionUID = -4988371592272863772L;
    private final int sortKeyIdx;
    private final LogicalType sortKeyType;

    public GenericRowRecordSortComparator(int sortKeyIdx, LogicalType sortKeyType) {
        this.sortKeyIdx = sortKeyIdx;
        this.sortKeyType = sortKeyType;
    }

    @Override
    public int compare(GenericRowData row1, GenericRowData row2) {
        RowKind kind2;
        RowKind kind1 = row1.getRowKind();
        if (kind1 != (kind2 = row2.getRowKind())) {
            return kind1.toByteValue() - kind2.toByteValue();
        }
        Object key1 = RowData.get((RowData)row1, (int)this.sortKeyIdx, (LogicalType)this.sortKeyType);
        Object key2 = RowData.get((RowData)row2, (int)this.sortKeyIdx, (LogicalType)this.sortKeyType);
        if (key1 instanceof Comparable) {
            return ((Comparable)key1).compareTo(key2);
        }
        throw new UnsupportedOperationException();
    }
}

