/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.data.writer.BinaryWriter;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;

public class BinaryRowDataKeySelector
implements RowDataKeySelector {
    private static final long serialVersionUID = -2327761762415377059L;
    private final int[] keyFields;
    private final LogicalType[] inputFieldTypes;
    private final LogicalType[] keyFieldTypes;
    private final TypeSerializer[] keySers;

    public BinaryRowDataKeySelector(int[] keyFields, LogicalType[] inputFieldTypes) {
        this.keyFields = keyFields;
        this.inputFieldTypes = inputFieldTypes;
        this.keyFieldTypes = new LogicalType[keyFields.length];
        this.keySers = new TypeSerializer[keyFields.length];
        ExecutionConfig conf = new ExecutionConfig();
        for (int i = 0; i < keyFields.length; ++i) {
            this.keyFieldTypes[i] = inputFieldTypes[keyFields[i]];
            this.keySers[i] = InternalSerializers.create((LogicalType)this.keyFieldTypes[i], (ExecutionConfig)conf);
        }
    }

    public RowData getKey(RowData value) throws Exception {
        BinaryRowData ret = new BinaryRowData(this.keyFields.length);
        BinaryRowWriter writer = new BinaryRowWriter(ret);
        for (int i = 0; i < this.keyFields.length; ++i) {
            if (value.isNullAt(i)) {
                writer.setNullAt(i);
                continue;
            }
            BinaryWriter.write((BinaryWriter)writer, (int)i, (Object)RowData.get((RowData)value, (int)this.keyFields[i], (LogicalType)this.inputFieldTypes[this.keyFields[i]]), (LogicalType)this.inputFieldTypes[this.keyFields[i]], (TypeSerializer)this.keySers[i]);
        }
        writer.complete();
        return ret;
    }

    public RowDataTypeInfo getProducedType() {
        return new RowDataTypeInfo(this.keyFieldTypes);
    }
}

