/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Assert;
import org.junit.Test;

public class RowDataTypeInfoTest {
    private static LogicalType[] typeList = new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)};

    @Test(expected=IllegalArgumentException.class)
    public void testWrongNumberOfFieldNames() {
        new RowDataTypeInfo(typeList, new String[]{"int", "string", "int"});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicateCustomFieldNames() {
        new RowDataTypeInfo(typeList, new String[]{"int", "int"});
    }

    @Test
    public void testBinaryRowTypeInfoEquality() {
        RowDataTypeInfo typeInfo1 = new RowDataTypeInfo(new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)});
        RowDataTypeInfo typeInfo2 = new RowDataTypeInfo(new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)});
        Assert.assertEquals((Object)typeInfo1, (Object)typeInfo2);
        Assert.assertEquals((long)typeInfo1.hashCode(), (long)typeInfo2.hashCode());
    }

    @Test
    public void testBinaryRowTypeInfoInequality() {
        RowDataTypeInfo typeInfo1 = new RowDataTypeInfo(new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)});
        RowDataTypeInfo typeInfo2 = new RowDataTypeInfo(new LogicalType[]{new IntType(), new BooleanType()});
        Assert.assertNotEquals((Object)typeInfo1, (Object)typeInfo2);
        Assert.assertNotEquals((long)typeInfo1.hashCode(), (long)typeInfo2.hashCode());
    }
}

