/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RowDataSerializerTest
extends SerializerTestInstance<RowData> {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final RowDataSerializer serializer;
    private final RowData[] testData;

    public RowDataSerializerTest(RowDataSerializer serializer, RowData[] testData) {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof RowData && o2 instanceof RowData, (o1, o2, checker) -> RowDataSerializerTest.deepEqualsRowData((RowData)o1, (RowData)o2, (RowDataSerializer)serializer.duplicate(), (RowDataSerializer)serializer.duplicate())), (TypeSerializer)serializer, RowData.class, -1, (Object[])testData);
        this.serializer = serializer;
        this.testData = testData;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(RowDataSerializerTest.testRowDataSerializer(), RowDataSerializerTest.testLargeRowDataSerializer(), RowDataSerializerTest.testRowDataSerializerWithComplexTypes(), RowDataSerializerTest.testRowDataSerializerWithKryo());
    }

    private static Object[] testRowDataSerializer() {
        RowDataTypeInfo typeInfo = new RowDataTypeInfo(new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)});
        GenericRowData row1 = new GenericRowData(2);
        row1.setField(0, (Object)1);
        row1.setField(1, (Object)StringData.fromString((String)"a"));
        GenericRowData row2 = new GenericRowData(2);
        row2.setField(0, (Object)2);
        row2.setField(1, null);
        RowDataSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        return new Object[]{serializer, new RowData[]{row1, row2}};
    }

    private static Object[] testLargeRowDataSerializer() {
        RowDataTypeInfo typeInfo = new RowDataTypeInfo(new LogicalType[]{new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new VarCharType(Integer.MAX_VALUE)});
        GenericRowData row = new GenericRowData(13);
        row.setField(0, (Object)2);
        row.setField(1, null);
        row.setField(3, null);
        row.setField(4, null);
        row.setField(5, null);
        row.setField(6, null);
        row.setField(7, null);
        row.setField(8, null);
        row.setField(9, null);
        row.setField(10, null);
        row.setField(11, null);
        row.setField(12, (Object)StringData.fromString((String)"Test"));
        RowDataSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        return new Object[]{serializer, new RowData[]{row}};
    }

    private static Object[] testRowDataSerializerWithComplexTypes() {
        RowDataTypeInfo typeInfo = new RowDataTypeInfo(new LogicalType[]{new IntType(), new DoubleType(), new VarCharType(Integer.MAX_VALUE), new ArrayType((LogicalType)new IntType()), new MapType((LogicalType)new IntType(), (LogicalType)new IntType())});
        GenericRowData[] data = new GenericRowData[]{RowDataSerializerTest.createRow(null, null, null, null, null), RowDataSerializerTest.createRow(0, null, null, null, null), RowDataSerializerTest.createRow(0, 0.0, null, null, null), RowDataSerializerTest.createRow(0, 0.0, StringData.fromString((String)"a"), null, null), RowDataSerializerTest.createRow(1, 0.0, StringData.fromString((String)"a"), null, null), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"a"), null, null), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), null, null), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1), RowDataSerializerTest.createMap(new int[]{1}, new int[]{1})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2), RowDataSerializerTest.createMap(new int[]{1, 4}, new int[]{1, 2})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3), RowDataSerializerTest.createMap(new int[]{1, 5}, new int[]{1, 3})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3, 4), RowDataSerializerTest.createMap(new int[]{1, 6}, new int[]{1, 4})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3, 4, 5), RowDataSerializerTest.createMap(new int[]{1, 7}, new int[]{1, 5})), RowDataSerializerTest.createRow(1, 1.0, StringData.fromString((String)"b"), RowDataSerializerTest.createArray(1, 2, 3, 4, 5, 6), RowDataSerializerTest.createMap(new int[]{1, 8}, new int[]{1, 6}))};
        RowDataSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        return new Object[]{serializer, data};
    }

    private static Object[] testRowDataSerializerWithKryo() {
        RawValueDataSerializer rawValueSerializer = new RawValueDataSerializer((TypeSerializer)new KryoSerializer(WrappedString.class, new ExecutionConfig()));
        RowDataSerializer serializer = new RowDataSerializer(new LogicalType[]{new RawType(RawValueData.class, (TypeSerializer)rawValueSerializer)}, new TypeSerializer[]{rawValueSerializer});
        GenericRowData row = new GenericRowData(1);
        row.setField(0, (Object)RawValueData.fromObject((Object)new WrappedString("a")));
        return new Object[]{serializer, new GenericRowData[]{row}};
    }

    private static BinaryArrayData createArray(int ... ints) {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, ints.length, 4);
        for (int i = 0; i < ints.length; ++i) {
            writer.writeInt(i, ints[i]);
        }
        writer.complete();
        return array;
    }

    private static BinaryMapData createMap(int[] keys, int[] values) {
        return BinaryMapData.valueOf((BinaryArrayData)RowDataSerializerTest.createArray(keys), (BinaryArrayData)RowDataSerializerTest.createArray(values));
    }

    private static GenericRowData createRow(Object f0, Object f1, Object f2, Object f3, Object f4) {
        GenericRowData row = new GenericRowData(5);
        row.setField(0, f0);
        row.setField(1, f1);
        row.setField(2, f2);
        row.setField(3, f3);
        row.setField(4, f4);
        return row;
    }

    private static boolean deepEqualsRowData(RowData should, RowData is, RowDataSerializer serializer1, RowDataSerializer serializer2) {
        if (should.getArity() != is.getArity()) {
            return false;
        }
        BinaryRowData row1 = serializer1.toBinaryRow(should);
        BinaryRowData row2 = serializer2.toBinaryRow(is);
        return Objects.equals(row1, row2);
    }

    private void checkDeepEquals(RowData should, RowData is) {
        boolean equals = RowDataSerializerTest.deepEqualsRowData(should, is, (RowDataSerializer)this.serializer.duplicate(), (RowDataSerializer)this.serializer.duplicate());
        Assert.assertTrue((boolean)equals);
    }

    @Test
    public void testCopy() {
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row));
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row, (RowData)new GenericRowData(row.getArity())));
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((RowData)this.serializer.toBinaryRow(row), (RowData)new GenericRowData(row.getArity())));
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((RowData)this.serializer.toBinaryRow(row)));
        }
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((RowData)this.serializer.toBinaryRow(row), (RowData)new BinaryRowData(row.getArity())));
        }
    }

    @Test
    public void testWrongCopy() {
        this.thrown.expect(IllegalArgumentException.class);
        this.serializer.copy((RowData)new GenericRowData(this.serializer.getArity() + 1));
    }

    @Test
    public void testWrongCopyReuse() {
        this.thrown.expect(IllegalArgumentException.class);
        for (RowData row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row, (RowData)new GenericRowData(row.getArity() + 1)));
        }
    }

    private static class WrappedString {
        private final String content;

        WrappedString(String content) {
            this.content = content;
        }
    }
}

