/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import com.esotericsoftware.kryo.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.GenericMapData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.util.MapDataUtil;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializerTest;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.SerializerTestUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.Assert;
import org.junit.Test;

public class MapDataSerializerTest
extends SerializerTestBase<MapData> {
    private static final LogicalType INT = DataTypes.INT().getLogicalType();
    private static final LogicalType STRING = DataTypes.STRING().getLogicalType();

    public MapDataSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof MapData && o2 instanceof MapData, (o1, o2, checker) -> MapDataUtil.convertToJavaMap((MapData)((MapData)o1), (LogicalType)INT, (LogicalType)STRING).equals(MapDataUtil.convertToJavaMap((MapData)((MapData)o2), (LogicalType)INT, (LogicalType)STRING))));
    }

    @Test
    public void testExecutionConfigWithKryo() throws Exception {
        MapData outputMap;
        byte[] serialized;
        ExecutionConfig config = new ExecutionConfig();
        config.enableForceKryo();
        config.registerTypeWithKryoSerializer(SerializerTestUtil.MyObj.class, (Serializer)new SerializerTestUtil.MyObjSerializer());
        MapDataSerializer serializer = this.createSerializerWithConfig(config);
        int inputKey = 998244353;
        SerializerTestUtil.MyObj inputObj = new SerializerTestUtil.MyObj(114514, 1919810);
        HashMap<Integer, RawValueData> javaMap = new HashMap<Integer, RawValueData>();
        javaMap.put(inputKey, RawValueData.fromObject((Object)inputObj));
        GenericMapData inputMap = new GenericMapData(javaMap);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            serializer.serialize((MapData)inputMap, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        MapDataSerializer restoreSerializer = (MapDataSerializer)SerializerTestUtil.snapshotAndReconfigure(serializer, () -> this.createSerializerWithConfig(config));
        try (ByteArrayInputStream in = new ByteArrayInputStream(serialized);){
            outputMap = restoreSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        TypeSerializer restoreKeySer = restoreSerializer.getKeySerializer();
        TypeSerializer restoreValueSer = restoreSerializer.getValueSerializer();
        Assert.assertEquals((Object)serializer.getKeySerializer(), (Object)restoreKeySer);
        Assert.assertEquals((Object)serializer.getValueSerializer(), (Object)restoreValueSer);
        Map outputJavaMap = MapDataUtil.convertToJavaMap((MapData)outputMap, (LogicalType)DataTypes.INT().getLogicalType(), (LogicalType)DataTypes.RAW((TypeInformation)TypeInformation.of(SerializerTestUtil.MyObj.class)).getLogicalType());
        SerializerTestUtil.MyObj outputObj = (SerializerTestUtil.MyObj)((RawValueData)outputJavaMap.get(inputKey)).toObject((TypeSerializer)new KryoSerializer(SerializerTestUtil.MyObj.class, config));
        Assert.assertEquals((Object)inputObj, (Object)outputObj);
    }

    private MapDataSerializer createSerializerWithConfig(ExecutionConfig config) {
        return new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.RAW((TypeInformation)TypeInformation.of(SerializerTestUtil.MyObj.class)).getLogicalType(), config);
    }

    private static MapDataSerializer newSer() {
        return new MapDataSerializer(INT, STRING, new ExecutionConfig());
    }

    protected MapDataSerializer createSerializer() {
        return MapDataSerializerTest.newSer();
    }

    protected int getLength() {
        return -1;
    }

    protected Class<MapData> getTypeClass() {
        return MapData.class;
    }

    protected MapData[] getTestData() {
        HashMap<Integer, StringData> first = new HashMap<Integer, StringData>();
        first.put(1, StringData.fromString((String)""));
        return new MapData[]{new GenericMapData(first), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 2), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "haa")), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 3, 4), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "haa", "ke")), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 4, 2), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "haa", "ke")), BinaryMapData.valueOf((BinaryArrayData)MapDataSerializerTest.createArray(1, 5, 6, 7), (BinaryArrayData)ArrayDataSerializerTest.createArray("11", "lele", "haa", "ke"))};
    }

    private static BinaryArrayData createArray(int ... vs) {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, vs.length, 4);
        for (int i = 0; i < vs.length; ++i) {
            writer.writeInt(i, vs[i]);
        }
        writer.complete();
        return array;
    }
}

