/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import com.esotericsoftware.kryo.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.ColumnarArrayData;
import org.apache.flink.table.data.GenericArrayData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.vector.ColumnVector;
import org.apache.flink.table.data.vector.heap.HeapBytesVector;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.SerializerTestUtil;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.Assert;
import org.junit.Test;

public class ArrayDataSerializerTest
extends SerializerTestBase<ArrayData> {
    public ArrayDataSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof ArrayData && o2 instanceof ArrayData, (o1, o2, checker) -> {
            ArrayData array1 = (ArrayData)o1;
            ArrayData array2 = (ArrayData)o2;
            if (array1.size() != array2.size()) {
                return false;
            }
            for (int i = 0; i < array1.size(); ++i) {
                if (array1.isNullAt(i) && array2.isNullAt(i)) continue;
                if (array1.isNullAt(i) || array2.isNullAt(i)) {
                    return false;
                }
                if (array1.getString(i).equals(array2.getString(i))) continue;
                return false;
            }
            return true;
        }));
    }

    @Test
    public void testExecutionConfigWithKryo() throws Exception {
        ArrayData outputArray;
        byte[] serialized;
        ExecutionConfig config = new ExecutionConfig();
        config.enableForceKryo();
        config.registerTypeWithKryoSerializer(SerializerTestUtil.MyObj.class, (Serializer)new SerializerTestUtil.MyObjSerializer());
        ArrayDataSerializer serializer = this.createSerializerWithConfig(config);
        SerializerTestUtil.MyObj inputObj = new SerializerTestUtil.MyObj(114514, 1919810);
        GenericArrayData inputArray = new GenericArrayData((Object[])new RawValueData[]{RawValueData.fromObject((Object)inputObj)});
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            serializer.serialize((ArrayData)inputArray, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        ArrayDataSerializer restoreSerializer = (ArrayDataSerializer)SerializerTestUtil.snapshotAndReconfigure(serializer, () -> this.createSerializerWithConfig(config));
        try (ByteArrayInputStream in = new ByteArrayInputStream(serialized);){
            outputArray = restoreSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        TypeSerializer restoreEleSer = restoreSerializer.getEleSer();
        Assert.assertEquals((Object)serializer.getEleSer(), (Object)restoreEleSer);
        SerializerTestUtil.MyObj outputObj = (SerializerTestUtil.MyObj)outputArray.getRawValue(0).toObject((TypeSerializer)new KryoSerializer(SerializerTestUtil.MyObj.class, config));
        Assert.assertEquals((Object)inputObj, (Object)outputObj);
    }

    private ArrayDataSerializer createSerializerWithConfig(ExecutionConfig config) {
        return new ArrayDataSerializer(DataTypes.RAW((TypeInformation)TypeInformation.of(SerializerTestUtil.MyObj.class)).getLogicalType(), config);
    }

    protected ArrayDataSerializer createSerializer() {
        return new ArrayDataSerializer(DataTypes.STRING().getLogicalType(), new ExecutionConfig());
    }

    protected int getLength() {
        return -1;
    }

    protected Class<ArrayData> getTypeClass() {
        return ArrayData.class;
    }

    protected ArrayData[] getTestData() {
        return new ArrayData[]{new GenericArrayData((Object[])new StringData[]{StringData.fromString((String)"11")}), ArrayDataSerializerTest.createArray("11", "haa"), ArrayDataSerializerTest.createArray("11", "haa", "ke"), ArrayDataSerializerTest.createArray("11", "haa", "ke"), ArrayDataSerializerTest.createArray("11", "lele", "haa", "ke"), ArrayDataSerializerTest.createColumnarArray("11", "lele", "haa", "ke")};
    }

    static BinaryArrayData createArray(String ... vs) {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, vs.length, 8);
        for (int i = 0; i < vs.length; ++i) {
            writer.writeString(i, StringData.fromString((String)vs[i]));
        }
        writer.complete();
        return array;
    }

    private static ColumnarArrayData createColumnarArray(String ... vs) {
        HeapBytesVector vector = new HeapBytesVector(vs.length);
        for (String v : vs) {
            vector.fill(v.getBytes(StandardCharsets.UTF_8));
        }
        return new ColumnarArrayData((ColumnVector)vector, 0, vs.length);
    }
}

