/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.util.ArrayList;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.StreamSortOperator;
import org.apache.flink.table.runtime.operators.sort.StringRecordComparator;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.util.RowDataHarnessAssertor;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.junit.Test;

public class StreamSortOperatorTest {
    private RowDataTypeInfo inputRowType = new RowDataTypeInfo(new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType()});
    private GeneratedRecordComparator sortKeyComparator = new GeneratedRecordComparator("", "", new Object[0]){
        private static final long serialVersionUID = -6067266199060901331L;

        public RecordComparator newInstance(ClassLoader classLoader) {
            return new StringRecordComparator();
        }
    };
    private RowDataHarnessAssertor assertor = new RowDataHarnessAssertor(this.inputRowType.getFieldTypes());

    @Test
    public void test() throws Exception {
        StreamSortOperator operator = this.createSortOperator();
        OneInputStreamOperatorTestHarness testHarness = this.createTestHarness(operator);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("hi", 1));
        testHarness.processElement(StreamRecordUtils.insertRecord("hello", 2));
        testHarness.processElement(StreamRecordUtils.insertRecord("world", 3));
        testHarness.processElement(StreamRecordUtils.insertRecord("word", 4));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("hello", 2));
        expectedOutput.add(StreamRecordUtils.insertRecord("hi", 1));
        expectedOutput.add(StreamRecordUtils.insertRecord("word", 4));
        expectedOutput.add(StreamRecordUtils.insertRecord("world", 3));
        OperatorSubtaskState snapshot = testHarness.snapshot(0L, 0L);
        testHarness.close();
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
        expectedOutput.clear();
        operator = this.createSortOperator();
        testHarness = this.createTestHarness(operator);
        testHarness.initializeState(snapshot);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("abc", 1));
        testHarness.processElement(StreamRecordUtils.insertRecord("aa", 1));
        testHarness.close();
        expectedOutput.add(StreamRecordUtils.insertRecord("aa", 1));
        expectedOutput.add(StreamRecordUtils.insertRecord("abc", 1));
        expectedOutput.add(StreamRecordUtils.insertRecord("hello", 2));
        expectedOutput.add(StreamRecordUtils.insertRecord("hi", 1));
        expectedOutput.add(StreamRecordUtils.insertRecord("word", 4));
        expectedOutput.add(StreamRecordUtils.insertRecord("world", 3));
        this.assertor.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    private StreamSortOperator createSortOperator() {
        return new StreamSortOperator(this.inputRowType, this.sortKeyComparator);
    }

    private OneInputStreamOperatorTestHarness createTestHarness(StreamSortOperator operator) throws Exception {
        OneInputStreamOperatorTestHarness testHarness = new OneInputStreamOperatorTestHarness((OneInputStreamOperator)operator);
        return testHarness;
    }
}

