/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.ArrayList;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.ConstantRankRange;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.operators.rank.TopNFunctionTestBase;
import org.apache.flink.table.runtime.operators.rank.UpdatableTopNFunction;
import org.apache.flink.table.runtime.operators.rank.VariableRankRange;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class UpdatableTopNFunctionTest
extends TopNFunctionTestBase {
    @Override
    protected AbstractTopNFunction createFunction(RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber) {
        return new UpdatableTopNFunction(this.minTime.toMilliseconds(), this.maxTime.toMilliseconds(), this.inputRowType, (RowDataKeySelector)this.rowKeySelector, sortKeyComparator, (RowDataKeySelector)this.sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber, this.cacheSize);
    }

    @Test
    public void testVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 18));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 18));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 44));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 33));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22));
        this.assertorWithoutRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Override
    @Test
    public void testOutputRankNumberWithVariableRankRange() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new VariableRankRange(1), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 12));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("fruit", 1L, 44));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 12, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("fruit", 1L, 44, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 44, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("fruit", 1L, 33, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("fruit", 1L, 22, 1L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 3L, 16, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 15, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 3L, 15, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1, 1L));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2, 2L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenOutputRankNumberAndNotGenerateUpdateBefore() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16, 1L));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 16, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 15, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11, 2L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1, 1L));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 4L, 2, 2L));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenNotOutputRankNumber() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), true, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testSortKeyChangesWhenNotOutputRankNumberAndNotGenerateUpdateBefore() throws Exception {
        AbstractTopNFunction func = this.createFunction(RankType.ROW_NUMBER, (RankRange)new ConstantRankRange(1L, 2L), false, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 19));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 3L, 16));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 4L, 2));
        testHarness.processElement(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 19));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 3L, 16));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.deleteRecord("book", 3L, 15));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 4L, 2));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 1));
        this.assertorWithRowNumber.assertOutputEquals("output wrong.", expectedOutput, testHarness.getOutput());
    }
}

