/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.flink.api.common.functions.AbstractRichFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamOperatorFactory;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTask;
import org.apache.flink.streaming.runtime.tasks.TwoInputStreamTaskTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.generated.GeneratedJoinCondition;
import org.apache.flink.table.runtime.generated.GeneratedProjection;
import org.apache.flink.table.runtime.generated.JoinCondition;
import org.apache.flink.table.runtime.generated.Projection;
import org.apache.flink.table.runtime.operators.join.HashJoinOperator;
import org.apache.flink.table.runtime.operators.join.HashJoinType;
import org.apache.flink.table.runtime.typeutils.RowDataTypeInfo;
import org.apache.flink.table.runtime.util.UniformBinaryRowGenerator;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public class Int2HashJoinOperatorTest
implements Serializable {
    @Test
    public void testBuildFirstHashInnerJoin() throws Exception {
        int numKeys = 100;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys, buildValsPerKey, false);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, false, true, numKeys * buildValsPerKey * probeValsPerKey, numKeys, 165);
    }

    @Test
    public void testBuildFirstHashLeftOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, false, true, numKeys1 * buildValsPerKey * probeValsPerKey, numKeys1, 165);
    }

    @Test
    public void testBuildFirstHashRightOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, true, true, 280, numKeys2, -1);
    }

    @Test
    public void testBuildFirstHashFullOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, true, true, 280, numKeys2, -1);
    }

    @Test
    public void testBuildSecondHashInnerJoin() throws Exception {
        int numKeys = 100;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys, buildValsPerKey, false);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, false, false, numKeys * buildValsPerKey * probeValsPerKey, numKeys, 165);
    }

    @Test
    public void testBuildSecondHashLeftOutJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, false, false, numKeys2 * buildValsPerKey * probeValsPerKey, numKeys2, 165);
    }

    @Test
    public void testBuildSecondHashRightOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, false, true, false, numKeys1 * buildValsPerKey * probeValsPerKey, numKeys2, -1);
    }

    @Test
    public void testBuildSecondHashFullOutJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        this.buildJoin(buildInput, probeInput, true, true, false, 280, numKeys2, -1);
    }

    @Test
    public void testSemiJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        HashJoinType type = HashJoinType.SEMI;
        Object operator = this.newOperator(0x108000L, type, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 90, 9, 45, true);
    }

    @Test
    public void testAntiJoin() throws Exception {
        int numKeys1 = 9;
        int numKeys2 = 10;
        int buildValsPerKey = 3;
        int probeValsPerKey = 10;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        HashJoinType type = HashJoinType.ANTI;
        Object operator = this.newOperator(0x108000L, type, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 10, 1, 45, true);
    }

    @Test
    public void testBuildLeftSemiJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 10;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        HashJoinType type = HashJoinType.BUILD_LEFT_SEMI;
        Object operator = this.newOperator(0x108000L, type, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 90, 9, 45, true);
    }

    @Test
    public void testBuildLeftAntiJoin() throws Exception {
        int numKeys1 = 10;
        int numKeys2 = 9;
        int buildValsPerKey = 10;
        int probeValsPerKey = 3;
        UniformBinaryRowGenerator buildInput = new UniformBinaryRowGenerator(numKeys1, buildValsPerKey, true);
        UniformBinaryRowGenerator probeInput = new UniformBinaryRowGenerator(numKeys2, probeValsPerKey, true);
        HashJoinType type = HashJoinType.BUILD_LEFT_ANTI;
        Object operator = this.newOperator(0x108000L, type, false);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, 10, 1, 45, true);
    }

    private void buildJoin(MutableObjectIterator<BinaryRowData> buildInput, MutableObjectIterator<BinaryRowData> probeInput, boolean leftOut, boolean rightOut, boolean buildLeft, int expectOutSize, int expectOutKeySize, int expectOutVal) throws Exception {
        HashJoinType type = HashJoinType.of((boolean)buildLeft, (boolean)leftOut, (boolean)rightOut);
        Object operator = this.newOperator(0x108000L, type, !buildLeft);
        Int2HashJoinOperatorTest.joinAndAssert(operator, buildInput, probeInput, expectOutSize, expectOutKeySize, expectOutVal, false);
    }

    static void joinAndAssert(Object operator, MutableObjectIterator<BinaryRowData> input1, MutableObjectIterator<BinaryRowData> input2, int expectOutSize, int expectOutKeySize, int expectOutVal, boolean semiJoin) throws Exception {
        block16: {
            HashMap<Integer, Long> map;
            RowDataTypeInfo typeInfo = new RowDataTypeInfo(new LogicalType[]{new IntType(), new IntType()});
            RowDataTypeInfo rowDataTypeInfo = new RowDataTypeInfo(new LogicalType[]{new IntType(), new IntType(), new IntType(), new IntType()});
            TwoInputStreamTaskTestHarness testHarness = new TwoInputStreamTaskTestHarness(TwoInputStreamTask::new, 2, 1, new int[]{1, 2}, (TypeInformation)typeInfo, (TypeInformation)typeInfo, (TypeInformation)rowDataTypeInfo);
            testHarness.memorySize = 0x2400000L;
            testHarness.getExecutionConfig().enableObjectReuse();
            testHarness.setupOutputForSingletonOperatorChain();
            if (operator instanceof StreamOperator) {
                testHarness.getStreamConfig().setStreamOperator((StreamOperator)operator);
            } else {
                testHarness.getStreamConfig().setStreamOperatorFactory((StreamOperatorFactory)operator);
            }
            testHarness.getStreamConfig().setOperatorID(new OperatorID());
            testHarness.getStreamConfig().setManagedMemoryFraction(0.99);
            testHarness.invoke();
            testHarness.waitForTaskRunning();
            Random random = new Random();
            while (true) {
                BinaryRowData row1 = null;
                BinaryRowData row2 = null;
                if (random.nextInt(2) == 0) {
                    row1 = (BinaryRowData)input1.next();
                    if (row1 == null) {
                        row2 = (BinaryRowData)input2.next();
                    }
                } else {
                    row2 = (BinaryRowData)input2.next();
                    if (row2 == null) {
                        row1 = (BinaryRowData)input1.next();
                    }
                }
                if (row1 == null && row2 == null) break;
                if (row1 != null) {
                    testHarness.processElement((Object)new StreamRecord((Object)row1), 0, 0);
                    continue;
                }
                testHarness.processElement((Object)new StreamRecord((Object)row2), 1, 0);
            }
            testHarness.endInput(0, 0);
            testHarness.endInput(1, 0);
            testHarness.waitForInputProcessing();
            testHarness.waitForTaskCompletion();
            LinkedBlockingQueue actual = testHarness.getOutput();
            Assert.assertEquals((String)"Output was not correct.", (long)expectOutSize, (long)actual.size());
            if (expectOutVal == -1) break block16;
            if (semiJoin) {
                int key;
                map = new HashMap<Integer, Long>(expectOutKeySize);
                for (Object e : actual) {
                    StreamRecord record = (StreamRecord)e;
                    RowData row = (RowData)record.getValue();
                    key = row.getInt(0);
                    int val = row.getInt(1);
                    Long contained = (Long)map.get(key);
                    contained = contained == null ? Long.valueOf(val) : Long.valueOf(contained + (long)val);
                    map.put(key, contained);
                }
                Assert.assertEquals((String)"Wrong number of keys", (long)expectOutKeySize, (long)map.size());
                for (Map.Entry entry : map.entrySet()) {
                    long val = (Long)entry.getValue();
                    key = (Integer)entry.getKey();
                    Assert.assertEquals((String)("Wrong number of values in per-key cross product for key " + key), (long)expectOutVal, (long)val);
                }
            } else {
                int key;
                map = new HashMap(expectOutKeySize);
                for (Object e : actual) {
                    StreamRecord record = (StreamRecord)e;
                    RowData row = (RowData)record.getValue();
                    key = row.isNullAt(0) ? row.getInt(2) : row.getInt(0);
                    int val1 = 0;
                    int val2 = 0;
                    if (!row.isNullAt(1)) {
                        val1 = row.getInt(1);
                    }
                    if (!row.isNullAt(3)) {
                        val2 = row.getInt(3);
                    }
                    int val = val1 + val2;
                    Long contained = (Long)map.get(key);
                    contained = contained == null ? Long.valueOf(val) : Long.valueOf(contained + (long)val);
                    map.put(key, contained);
                }
                Assert.assertEquals((String)"Wrong number of keys", (long)expectOutKeySize, (long)map.size());
                for (Map.Entry entry : map.entrySet()) {
                    long val = (Long)entry.getValue();
                    key = (Integer)entry.getKey();
                    Assert.assertEquals((String)("Wrong number of values in per-key cross product for key " + key), (long)expectOutVal, (long)val);
                }
            }
        }
    }

    public Object newOperator(long memorySize, HashJoinType type, boolean reverseJoinFunction) {
        return HashJoinOperator.newHashJoinOperator((HashJoinType)type, (GeneratedJoinCondition)new GeneratedJoinCondition("", "", new Object[0]){

            public JoinCondition newInstance(ClassLoader classLoader) {
                return new TrueCondition();
            }
        }, (boolean)reverseJoinFunction, (boolean[])new boolean[]{true}, (GeneratedProjection)new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new MyProjection();
            }
        }, (GeneratedProjection)new GeneratedProjection("", "", new Object[0]){

            public Projection newInstance(ClassLoader classLoader) {
                return new MyProjection();
            }
        }, (boolean)false, (int)20, (long)10000L, (long)10000L, (RowType)RowType.of((LogicalType[])new LogicalType[]{new IntType()}));
    }

    public static class TrueCondition
    extends AbstractRichFunction
    implements JoinCondition {
        public boolean apply(RowData in1, RowData in2) {
            return true;
        }
    }

    public static final class MyProjection
    implements Projection<RowData, BinaryRowData> {
        BinaryRowData innerRow = new BinaryRowData(1);
        BinaryRowWriter writer = new BinaryRowWriter(this.innerRow);

        public BinaryRowData apply(RowData row) {
            this.writer.reset();
            if (row.isNullAt(0)) {
                this.writer.setNullAt(0);
            } else {
                this.writer.writeInt(0, row.getInt(0));
            }
            this.writer.complete();
            return this.innerRow;
        }
    }
}

