/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.ArrayList;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.functions.KeySelector;
import org.apache.flink.streaming.api.functions.KeyedProcessFunction;
import org.apache.flink.streaming.api.operators.KeyedProcessOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.util.KeyedOneInputStreamOperatorTestHarness;
import org.apache.flink.streaming.util.OneInputStreamOperatorTestHarness;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionTestBase;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateKeepLastRowFunction;
import org.apache.flink.table.runtime.util.StreamRecordUtils;
import org.junit.Test;

public class DeduplicateKeepLastRowFunctionTest
extends DeduplicateFunctionTestBase {
    private DeduplicateKeepLastRowFunction createFunction(boolean generateUpdateBefore, boolean generateInsert) {
        return new DeduplicateKeepLastRowFunction(this.minTime.toMilliseconds(), this.inputRowType, generateUpdateBefore, generateInsert);
    }

    private OneInputStreamOperatorTestHarness<RowData, RowData> createTestHarness(DeduplicateKeepLastRowFunction func) throws Exception {
        KeyedProcessOperator operator = new KeyedProcessOperator((KeyedProcessFunction)func);
        return new KeyedOneInputStreamOperatorTestHarness((OneInputStreamOperator)operator, (KeySelector)this.rowKeySelector, (TypeInformation)this.rowKeySelector.getProducedType());
    }

    @Test
    public void testWithoutGenerateUpdateBefore() throws Exception {
        DeduplicateKeepLastRowFunction func = this.createFunction(false, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 13));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testWithoutGenerateUpdateBeforeAndInsert() throws Exception {
        DeduplicateKeepLastRowFunction func = this.createFunction(false, false);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 13));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testWithGenerateUpdateBefore() throws Exception {
        DeduplicateKeepLastRowFunction func = this.createFunction(true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 13));
        testHarness.close();
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 13));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 11));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
    }

    @Test
    public void testWithGenerateUpdateBeforeAndStateTtl() throws Exception {
        DeduplicateKeepLastRowFunction func = this.createFunction(true, true);
        OneInputStreamOperatorTestHarness<RowData, RowData> testHarness = this.createTestHarness(func);
        testHarness.open();
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 12));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 11));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 13));
        testHarness.setStateTtlProcessingTime(30L);
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 17));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 2L, 18));
        testHarness.processElement(StreamRecordUtils.insertRecord("book", 1L, 19));
        ArrayList<Object> expectedOutput = new ArrayList<Object>();
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 12));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 13));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 11));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 1L, 17));
        expectedOutput.add(StreamRecordUtils.updateBeforeRecord("book", 1L, 17));
        expectedOutput.add(StreamRecordUtils.updateAfterRecord("book", 1L, 19));
        expectedOutput.add(StreamRecordUtils.insertRecord("book", 2L, 18));
        this.assertor.assertOutputEqualsSorted("output wrong.", expectedOutput, testHarness.getOutput());
        testHarness.close();
    }
}

