/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.data;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RawValueData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryArrayData;
import org.apache.flink.table.data.binary.BinaryMapData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.data.binary.BinarySegmentUtils;
import org.apache.flink.table.data.writer.BinaryArrayWriter;
import org.apache.flink.table.data.writer.BinaryRowWriter;
import org.apache.flink.table.runtime.typeutils.ArrayDataSerializer;
import org.apache.flink.table.runtime.typeutils.MapDataSerializer;
import org.apache.flink.table.runtime.typeutils.RawValueDataSerializer;
import org.apache.flink.table.runtime.typeutils.RowDataSerializer;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.utils.RawValueDataAsserter;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class BinaryArrayDataTest {
    @Test
    public void testArray() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 3, 4);
        writer.writeInt(0, 6);
        writer.setNullInt(1);
        writer.writeInt(2, 666);
        writer.complete();
        Assert.assertEquals((long)array.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array.isNullAt(1));
        Assert.assertEquals((long)array.getInt(2), (long)666L);
        BinaryRowData row2 = new BinaryRowData(1);
        BinaryRowWriter writer2 = new BinaryRowWriter(row2);
        writer2.writeArray(0, (ArrayData)array, new ArrayDataSerializer(DataTypes.INT().getLogicalType(), null));
        writer2.complete();
        BinaryArrayData array2 = (BinaryArrayData)row2.getArray(0);
        Assert.assertEquals((Object)array2, (Object)array);
        Assert.assertEquals((long)array2.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array2.isNullAt(1));
        Assert.assertEquals((long)array2.getInt(2), (long)666L);
        BinaryArrayData array3 = BinaryArrayDataTest.splitArray(array);
        BinaryRowData row22 = new BinaryRowData(1);
        BinaryRowWriter writer22 = new BinaryRowWriter(row22);
        writer22.writeArray(0, (ArrayData)array3, new ArrayDataSerializer(DataTypes.INT().getLogicalType(), null));
        writer22.complete();
        BinaryArrayData array22 = (BinaryArrayData)row22.getArray(0);
        Assert.assertEquals((Object)array22, (Object)array);
        Assert.assertEquals((long)array22.getInt(0), (long)6L);
        Assert.assertTrue((boolean)array22.isNullAt(1));
        Assert.assertEquals((long)array22.getInt(2), (long)666L);
    }

    @Test
    public void testArrayTypes() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 1);
        writer.setNullBoolean(0);
        writer.writeBoolean(1, true);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertTrue((boolean)array.getBoolean(1));
        array.setBoolean(0, true);
        Assert.assertTrue((boolean)array.getBoolean(0));
        array.setNullBoolean(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        BinaryArrayData newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertTrue((boolean)newArray.getBoolean(1));
        newArray.setBoolean(0, true);
        Assert.assertTrue((boolean)newArray.getBoolean(0));
        newArray.setNullBoolean(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setBoolean(0, true);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((boolean[])newArray.toBooleanArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 1);
        writer.setNullByte(0);
        writer.writeByte(1, (byte)25);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getByte(1));
        array.setByte(0, (byte)5);
        Assert.assertEquals((long)5L, (long)array.getByte(0));
        array.setNullByte(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getByte(1));
        newArray.setByte(0, (byte)5);
        Assert.assertEquals((long)5L, (long)newArray.getByte(0));
        newArray.setNullByte(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setByte(0, (byte)3);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((byte[])newArray.toByteArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 2);
        writer.setNullShort(0);
        writer.writeShort(1, (short)25);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getShort(1));
        array.setShort(0, (short)5);
        Assert.assertEquals((long)5L, (long)array.getShort(0));
        array.setNullShort(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getShort(1));
        newArray.setShort(0, (short)5);
        Assert.assertEquals((long)5L, (long)newArray.getShort(0));
        newArray.setNullShort(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setShort(0, (short)3);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((short[])newArray.toShortArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 4);
        writer.setNullInt(0);
        writer.writeInt(1, 25);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getInt(1));
        array.setInt(0, 5);
        Assert.assertEquals((long)5L, (long)array.getInt(0));
        array.setNullInt(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getInt(1));
        newArray.setInt(0, 5);
        Assert.assertEquals((long)5L, (long)newArray.getInt(0));
        newArray.setNullInt(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setInt(0, 3);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((int[])newArray.toIntArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullLong(0);
        writer.writeLong(1, 25L);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((long)25L, (long)array.getLong(1));
        array.setLong(0, 5L);
        Assert.assertEquals((long)5L, (long)array.getLong(0));
        array.setNullLong(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((long)25L, (long)newArray.getLong(1));
        newArray.setLong(0, 5L);
        Assert.assertEquals((long)5L, (long)newArray.getLong(0));
        newArray.setNullLong(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setLong(0, 3L);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((long[])newArray.toLongArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 4);
        writer.setNullFloat(0);
        writer.writeFloat(1, 25.0f);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertTrue((25.0f == array.getFloat(1) ? 1 : 0) != 0);
        array.setFloat(0, 5.0f);
        Assert.assertTrue((5.0f == array.getFloat(0) ? 1 : 0) != 0);
        array.setNullFloat(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertTrue((25.0f == newArray.getFloat(1) ? 1 : 0) != 0);
        newArray.setFloat(0, 5.0f);
        Assert.assertTrue((5.0f == newArray.getFloat(0) ? 1 : 0) != 0);
        newArray.setNullFloat(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setFloat(0, 3.0f);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((float[])newArray.toFloatArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullDouble(0);
        writer.writeDouble(1, 25.0);
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertTrue((25.0 == array.getDouble(1) ? 1 : 0) != 0);
        array.setDouble(0, 5.0);
        Assert.assertTrue((5.0 == array.getDouble(0) ? 1 : 0) != 0);
        array.setNullDouble(0);
        Assert.assertTrue((boolean)array.isNullAt(0));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertTrue((25.0 == newArray.getDouble(1) ? 1 : 0) != 0);
        newArray.setDouble(0, 5.0);
        Assert.assertTrue((5.0 == newArray.getDouble(0) ? 1 : 0) != 0);
        newArray.setNullDouble(0);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        newArray.setDouble(0, 3.0);
        Assert.assertEquals((Object)newArray, (Object)BinaryArrayData.fromPrimitiveArray((double[])newArray.toDoubleArray()));
        array = new BinaryArrayData();
        writer = new BinaryArrayWriter(array, 2, 8);
        writer.setNullAt(0);
        writer.writeString(1, StringData.fromString((String)"jaja"));
        writer.complete();
        Assert.assertTrue((boolean)array.isNullAt(0));
        Assert.assertEquals((Object)StringData.fromString((String)"jaja"), (Object)array.getString(1));
        newArray = BinaryArrayDataTest.splitArray(array);
        Assert.assertTrue((boolean)newArray.isNullAt(0));
        Assert.assertEquals((Object)StringData.fromString((String)"jaja"), (Object)newArray.getString(1));
        BinaryArrayData subArray = new BinaryArrayData();
        BinaryArrayWriter subWriter = new BinaryArrayWriter(subArray, 2, 8);
        subWriter.setNullAt(0);
        subWriter.writeString(1, StringData.fromString((String)"hehehe"));
        subWriter.complete();
        BinaryArrayData array2 = new BinaryArrayData();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 2, 8);
        writer2.setNullAt(0);
        writer2.writeArray(1, (ArrayData)subArray, new ArrayDataSerializer(DataTypes.INT().getLogicalType(), null));
        writer2.complete();
        Assert.assertTrue((boolean)array2.isNullAt(0));
        Assert.assertEquals((Object)subArray, (Object)array2.getArray(1));
        BinaryArrayData newArray2 = BinaryArrayDataTest.splitArray(array2);
        Assert.assertTrue((boolean)newArray2.isNullAt(0));
        Assert.assertEquals((Object)subArray, (Object)newArray2.getArray(1));
        array2 = new BinaryArrayData();
        writer2 = new BinaryArrayWriter(array2, 2, 8);
        writer2.setNullAt(0);
        writer2.writeMap(1, (MapData)BinaryMapData.valueOf((BinaryArrayData)subArray, (BinaryArrayData)subArray), new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), null));
        writer2.complete();
        Assert.assertTrue((boolean)array2.isNullAt(0));
        Assert.assertEquals((Object)BinaryMapData.valueOf((BinaryArrayData)subArray, (BinaryArrayData)subArray), (Object)array2.getMap(1));
        newArray2 = BinaryArrayDataTest.splitArray(array2);
        Assert.assertTrue((boolean)newArray2.isNullAt(0));
        Assert.assertEquals((Object)BinaryMapData.valueOf((BinaryArrayData)subArray, (BinaryArrayData)subArray), (Object)newArray2.getMap(1));
    }

    @Test
    public void testMap() {
        BinaryArrayData array1 = new BinaryArrayData();
        BinaryArrayWriter writer1 = new BinaryArrayWriter(array1, 3, 4);
        writer1.writeInt(0, 6);
        writer1.writeInt(1, 5);
        writer1.writeInt(2, 666);
        writer1.complete();
        BinaryArrayData array2 = new BinaryArrayData();
        BinaryArrayWriter writer2 = new BinaryArrayWriter(array2, 3, 8);
        writer2.writeString(0, StringData.fromString((String)"6"));
        writer2.writeString(1, StringData.fromString((String)"5"));
        writer2.writeString(2, StringData.fromString((String)"666"));
        writer2.complete();
        BinaryMapData binaryMap = BinaryMapData.valueOf((BinaryArrayData)array1, (BinaryArrayData)array2);
        BinaryRowData row = new BinaryRowData(1);
        BinaryRowWriter rowWriter = new BinaryRowWriter(row);
        rowWriter.writeMap(0, (MapData)binaryMap, new MapDataSerializer(DataTypes.INT().getLogicalType(), DataTypes.INT().getLogicalType(), null));
        rowWriter.complete();
        BinaryMapData map = (BinaryMapData)row.getMap(0);
        BinaryArrayData key = map.keyArray();
        BinaryArrayData value = map.valueArray();
        Assert.assertEquals((Object)binaryMap, (Object)map);
        Assert.assertEquals((Object)array1, (Object)key);
        Assert.assertEquals((Object)array2, (Object)value);
        Assert.assertEquals((long)key.getInt(1), (long)5L);
        Assert.assertEquals((Object)value.getString(1), (Object)StringData.fromString((String)"5"));
    }

    private static BinaryArrayData splitArray(BinaryArrayData array) {
        BinaryArrayData ret = new BinaryArrayData();
        MemorySegment[] segments = BinaryArrayDataTest.splitBytes(BinarySegmentUtils.copyToBytes((MemorySegment[])array.getSegments(), (int)0, (int)array.getSizeInBytes()), 0);
        ret.pointTo(segments, 0, array.getSizeInBytes());
        return ret;
    }

    private static MemorySegment[] splitBytes(byte[] bytes, int baseOffset) {
        int newSize = (bytes.length + 1) / 2 + baseOffset;
        MemorySegment[] ret = new MemorySegment[]{MemorySegmentFactory.wrap((byte[])new byte[newSize]), MemorySegmentFactory.wrap((byte[])new byte[newSize])};
        ret[0].put(baseOffset, bytes, 0, newSize - baseOffset);
        ret[1].put(0, bytes, newSize - baseOffset, bytes.length - (newSize - baseOffset));
        return ret;
    }

    @Test
    public void testToArray() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 3, 2);
        writer.writeShort(0, (short)5);
        writer.writeShort(1, (short)10);
        writer.writeShort(2, (short)15);
        writer.complete();
        short[] shorts = array.toShortArray();
        Assert.assertEquals((long)5L, (long)shorts[0]);
        Assert.assertEquals((long)10L, (long)shorts[1]);
        Assert.assertEquals((long)15L, (long)shorts[2]);
        MemorySegment[] segments = BinaryArrayDataTest.splitBytes(writer.getSegments().getArray(), 3);
        array.pointTo(segments, 3, array.getSizeInBytes());
        Assert.assertEquals((long)5L, (long)array.getShort(0));
        Assert.assertEquals((long)10L, (long)array.getShort(1));
        Assert.assertEquals((long)15L, (long)array.getShort(2));
        short[] shorts2 = array.toShortArray();
        Assert.assertEquals((long)5L, (long)shorts2[0]);
        Assert.assertEquals((long)10L, (long)shorts2[1]);
        Assert.assertEquals((long)15L, (long)shorts2[2]);
    }

    @Test
    public void testDecimal() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        int precision = 4;
        int scale = 2;
        writer.reset();
        writer.writeDecimal(0, DecimalData.fromUnscaledLong((long)5L, (int)precision, (int)scale), precision);
        writer.setNullAt(1);
        writer.complete();
        Assert.assertEquals((Object)"0.05", (Object)array.getDecimal(0, precision, scale).toString());
        Assert.assertTrue((boolean)array.isNullAt(1));
        array.setDecimal(0, DecimalData.fromUnscaledLong((long)6L, (int)precision, (int)scale), precision);
        Assert.assertEquals((Object)"0.06", (Object)array.getDecimal(0, precision, scale).toString());
        precision = 25;
        scale = 5;
        DecimalData decimal1 = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(5.55), (int)precision, (int)scale);
        DecimalData decimal2 = DecimalData.fromBigDecimal((BigDecimal)BigDecimal.valueOf(6.55), (int)precision, (int)scale);
        writer.reset();
        writer.writeDecimal(0, decimal1, precision);
        writer.writeDecimal(1, null, precision);
        writer.complete();
        Assert.assertEquals((Object)"5.55000", (Object)array.getDecimal(0, precision, scale).toString());
        Assert.assertTrue((boolean)array.isNullAt(1));
        array.setDecimal(0, decimal2, precision);
        Assert.assertEquals((Object)"6.55000", (Object)array.getDecimal(0, precision, scale).toString());
    }

    @Test
    public void testGeneric() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        RawValueData generic = RawValueData.fromObject((Object)"hahah");
        RawValueDataSerializer serializer = new RawValueDataSerializer((TypeSerializer)StringSerializer.INSTANCE);
        writer.writeRawValue(0, generic, serializer);
        writer.setNullAt(1);
        writer.complete();
        RawValueData newGeneric = array.getRawValue(0);
        Assert.assertThat((Object)newGeneric, (Matcher)RawValueDataAsserter.equivalent(generic, serializer));
        Assert.assertTrue((boolean)array.isNullAt(1));
    }

    @Test
    public void testNested() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        writer.writeRow(0, (RowData)GenericRowData.of((Object[])new Object[]{StringData.fromString((String)"1"), 1}), new RowDataSerializer(null, RowType.of((LogicalType[])new LogicalType[]{new VarCharType(Integer.MAX_VALUE), new IntType()})));
        writer.setNullAt(1);
        writer.complete();
        RowData nestedRow = array.getRow(0, 2);
        Assert.assertEquals((Object)"1", (Object)nestedRow.getString(0).toString());
        Assert.assertEquals((long)1L, (long)nestedRow.getInt(1));
        Assert.assertTrue((boolean)array.isNullAt(1));
    }

    @Test
    public void testBinary() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        byte[] bytes1 = new byte[]{1, -1, 5};
        byte[] bytes2 = new byte[]{1, -1, 5, 5, 1, 5, 1, 5};
        writer.writeBinary(0, bytes1);
        writer.writeBinary(1, bytes2);
        writer.complete();
        Assert.assertArrayEquals((byte[])bytes1, (byte[])array.getBinary(0));
        Assert.assertArrayEquals((byte[])bytes2, (byte[])array.getBinary(1));
    }

    @Test
    public void testTimestampData() {
        BinaryArrayData array = new BinaryArrayData();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, 2, 8);
        int precision = 3;
        writer.reset();
        writer.writeTimestamp(0, TimestampData.fromEpochMillis((long)123L), 3);
        writer.setNullAt(1);
        writer.complete();
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123", (Object)array.getTimestamp(0, 3).toString());
        Assert.assertTrue((boolean)array.isNullAt(1));
        array.setTimestamp(0, TimestampData.fromEpochMillis((long)-123L), 3);
        Assert.assertEquals((Object)"1969-12-31T23:59:59.877", (Object)array.getTimestamp(0, 3).toString());
        precision = 9;
        TimestampData timestamp1 = TimestampData.fromLocalDateTime((LocalDateTime)LocalDateTime.of(1970, 1, 1, 0, 0, 0, 123456789));
        TimestampData timestamp2 = TimestampData.fromTimestamp((Timestamp)Timestamp.valueOf("1969-01-01 00:00:00.123456789"));
        writer.reset();
        writer.writeTimestamp(0, timestamp1, 9);
        writer.writeTimestamp(1, null, 9);
        writer.complete();
        Assert.assertEquals((Object)"1970-01-01T00:00:00.123456789", (Object)array.getTimestamp(0, 9).toString());
        Assert.assertTrue((boolean)array.isNullAt(1));
        array.setTimestamp(0, timestamp2, 9);
        Assert.assertEquals((Object)"1969-01-01T00:00:00.123456789", (Object)array.getTimestamp(0, 9).toString());
    }
}

