/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.util;

import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryRowWriter;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;

public class StreamRecordUtils {
    public static StreamRecord<BaseRow> record(Object ... fields) {
        return new StreamRecord((Object)StreamRecordUtils.baserow(fields));
    }

    public static StreamRecord<BaseRow> retractRecord(Object ... fields) {
        BaseRow row = StreamRecordUtils.baserow(fields);
        BaseRowUtil.setRetract((BaseRow)row);
        return new StreamRecord((Object)row);
    }

    public static StreamRecord<BaseRow> deleteRecord(Object ... fields) {
        BaseRow row = StreamRecordUtils.baserow(fields);
        BaseRowUtil.setRetract((BaseRow)row);
        return new StreamRecord((Object)row);
    }

    public static BaseRow baserow(Object ... fields) {
        Object[] objects = new Object[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            Object field = fields[i];
            objects[i] = field instanceof String ? BinaryString.fromString((String)((String)field)) : field;
        }
        return GenericRow.of((Object[])objects);
    }

    public static BinaryRow binaryrow(Object ... fields) {
        BinaryRow row = new BinaryRow(fields.length);
        BinaryRowWriter writer = new BinaryRowWriter(row);
        for (int j = 0; j < fields.length; ++j) {
            Object value = fields[j];
            if (value == null) {
                writer.setNullAt(j);
                continue;
            }
            if (value instanceof Integer) {
                writer.writeInt(j, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                writer.writeString(j, BinaryString.fromString((String)((String)value)));
                continue;
            }
            if (value instanceof Double) {
                writer.writeDouble(j, ((Double)value).doubleValue());
                continue;
            }
            if (value instanceof Float) {
                writer.writeFloat(j, ((Float)value).floatValue());
                continue;
            }
            if (value instanceof Long) {
                writer.writeLong(j, ((Long)value).longValue());
                continue;
            }
            if (value instanceof Boolean) {
                writer.writeBoolean(j, ((Boolean)value).booleanValue());
                continue;
            }
            throw new RuntimeException("Not support yet!");
        }
        writer.complete();
        return row;
    }

    public static BinaryRow retractBinaryRow(Object ... fields) {
        BinaryRow br = StreamRecordUtils.binaryrow(fields);
        BaseRowUtil.setRetract((BaseRow)br);
        return br;
    }

    private StreamRecordUtils() {
    }
}

