/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.SqlTimestamp;
import org.apache.flink.table.runtime.typeutils.SqlTimestampSerializer;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SqlTimestampSerializerTest
extends SerializerTestBase<SqlTimestamp> {
    private int precision;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({0}, {3}, {6}, {9});
    }

    public SqlTimestampSerializerTest(int precision) {
        this.precision = precision;
    }

    protected TypeSerializer<SqlTimestamp> createSerializer() {
        return new SqlTimestampSerializer(this.precision);
    }

    protected int getLength() {
        return this.precision <= 3 ? 8 : 12;
    }

    protected Class<SqlTimestamp> getTypeClass() {
        return SqlTimestamp.class;
    }

    protected SqlTimestamp[] getTestData() {
        return new SqlTimestamp[]{SqlTimestamp.fromEpochMillis((long)1L), SqlTimestamp.fromEpochMillis((long)2L), SqlTimestamp.fromEpochMillis((long)3L), SqlTimestamp.fromEpochMillis((long)4L)};
    }
}

