/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.SerializerTestInstance;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericRow;
import org.apache.flink.table.runtime.typeutils.BaseRowSerializer;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryGenericSerializer;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RawType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class BaseRowSerializerTest
extends SerializerTestInstance<BaseRow> {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private final BaseRowSerializer serializer;
    private final BaseRow[] testData;

    public BaseRowSerializerTest(BaseRowSerializer serializer, BaseRow[] testData) {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof BaseRow && o2 instanceof BaseRow, (o1, o2, checker) -> BaseRowSerializerTest.deepEqualsBaseRow((BaseRow)o1, (BaseRow)o2, (BaseRowSerializer)serializer.duplicate(), (BaseRowSerializer)serializer.duplicate())), (TypeSerializer)serializer, BaseRow.class, -1, (Object[])testData);
        this.serializer = serializer;
        this.testData = testData;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList(BaseRowSerializerTest.testBaseRowSerializer(), BaseRowSerializerTest.testLargeBaseRowSerializer(), BaseRowSerializerTest.testBaseRowSerializerWithComplexTypes(), BaseRowSerializerTest.testBaseRowSerializerWithKryo());
    }

    private static Object[] testBaseRowSerializer() {
        BaseRowTypeInfo typeInfo = new BaseRowTypeInfo(new LogicalType[]{new IntType(), new VarCharType(Integer.MAX_VALUE)});
        GenericRow row1 = new GenericRow(2);
        row1.setField(0, (Object)1);
        row1.setField(1, (Object)BinaryString.fromString((String)"a"));
        GenericRow row2 = new GenericRow(2);
        row2.setField(0, (Object)2);
        row2.setField(1, null);
        BaseRowSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        return new Object[]{serializer, new BaseRow[]{row1, row2}};
    }

    private static Object[] testLargeBaseRowSerializer() {
        BaseRowTypeInfo typeInfo = new BaseRowTypeInfo(new LogicalType[]{new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new IntType(), new VarCharType(Integer.MAX_VALUE)});
        GenericRow row = new GenericRow(13);
        row.setField(0, (Object)2);
        row.setField(1, null);
        row.setField(3, null);
        row.setField(4, null);
        row.setField(5, null);
        row.setField(6, null);
        row.setField(7, null);
        row.setField(8, null);
        row.setField(9, null);
        row.setField(10, null);
        row.setField(11, null);
        row.setField(12, (Object)BinaryString.fromString((String)"Test"));
        BaseRowSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        return new Object[]{serializer, new BaseRow[]{row}};
    }

    private static Object[] testBaseRowSerializerWithComplexTypes() {
        BaseRowTypeInfo typeInfo = new BaseRowTypeInfo(new LogicalType[]{new IntType(), new DoubleType(), new VarCharType(Integer.MAX_VALUE), new ArrayType((LogicalType)new IntType()), new MapType((LogicalType)new IntType(), (LogicalType)new IntType())});
        GenericRow[] data = new GenericRow[]{BaseRowSerializerTest.createRow(null, null, null, null, null), BaseRowSerializerTest.createRow(0, null, null, null, null), BaseRowSerializerTest.createRow(0, 0.0, null, null, null), BaseRowSerializerTest.createRow(0, 0.0, BinaryString.fromString((String)"a"), null, null), BaseRowSerializerTest.createRow(1, 0.0, BinaryString.fromString((String)"a"), null, null), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"a"), null, null), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), null, null), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), BaseRowSerializerTest.createArray(1), BaseRowSerializerTest.createMap(new int[]{1}, new int[]{1})), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), BaseRowSerializerTest.createArray(1, 2), BaseRowSerializerTest.createMap(new int[]{1, 4}, new int[]{1, 2})), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), BaseRowSerializerTest.createArray(1, 2, 3), BaseRowSerializerTest.createMap(new int[]{1, 5}, new int[]{1, 3})), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), BaseRowSerializerTest.createArray(1, 2, 3, 4), BaseRowSerializerTest.createMap(new int[]{1, 6}, new int[]{1, 4})), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), BaseRowSerializerTest.createArray(1, 2, 3, 4, 5), BaseRowSerializerTest.createMap(new int[]{1, 7}, new int[]{1, 5})), BaseRowSerializerTest.createRow(1, 1.0, BinaryString.fromString((String)"b"), BaseRowSerializerTest.createArray(1, 2, 3, 4, 5, 6), BaseRowSerializerTest.createMap(new int[]{1, 8}, new int[]{1, 6}))};
        BaseRowSerializer serializer = typeInfo.createSerializer(new ExecutionConfig());
        return new Object[]{serializer, data};
    }

    private static Object[] testBaseRowSerializerWithKryo() {
        BinaryGenericSerializer binaryGenericSerializer = new BinaryGenericSerializer((TypeSerializer)new KryoSerializer(WrappedString.class, new ExecutionConfig()));
        BaseRowSerializer serializer = new BaseRowSerializer(new LogicalType[]{new RawType(BinaryGeneric.class, (TypeSerializer)binaryGenericSerializer)}, new TypeSerializer[]{binaryGenericSerializer});
        GenericRow row = new GenericRow(1);
        row.setField(0, (Object)new BinaryGeneric((Object)new WrappedString("a")));
        return new Object[]{serializer, new GenericRow[]{row}};
    }

    private static BinaryArray createArray(int ... ints) {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, ints.length, 4);
        for (int i = 0; i < ints.length; ++i) {
            writer.writeInt(i, ints[i]);
        }
        writer.complete();
        return array;
    }

    private static BinaryMap createMap(int[] keys, int[] values) {
        return BinaryMap.valueOf((BinaryArray)BaseRowSerializerTest.createArray(keys), (BinaryArray)BaseRowSerializerTest.createArray(values));
    }

    private static GenericRow createRow(Object f0, Object f1, Object f2, Object f3, Object f4) {
        GenericRow row = new GenericRow(5);
        row.setField(0, f0);
        row.setField(1, f1);
        row.setField(2, f2);
        row.setField(3, f3);
        row.setField(4, f4);
        return row;
    }

    private static boolean deepEqualsBaseRow(BaseRow should, BaseRow is, BaseRowSerializer serializer1, BaseRowSerializer serializer2) {
        if (should.getArity() != is.getArity()) {
            return false;
        }
        BinaryRow row1 = serializer1.toBinaryRow(should);
        BinaryRow row2 = serializer2.toBinaryRow(is);
        return Objects.equals(row1, row2);
    }

    private void checkDeepEquals(BaseRow should, BaseRow is) {
        boolean equals = BaseRowSerializerTest.deepEqualsBaseRow(should, is, (BaseRowSerializer)this.serializer.duplicate(), (BaseRowSerializer)this.serializer.duplicate());
        Assert.assertTrue((boolean)equals);
    }

    @Test
    public void testCopy() {
        for (BaseRow row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row));
        }
        for (BaseRow row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row, (BaseRow)new GenericRow(row.getArity())));
        }
        for (BaseRow row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((BaseRow)this.serializer.toBinaryRow(row), (BaseRow)new GenericRow(row.getArity())));
        }
        for (BaseRow row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((BaseRow)this.serializer.toBinaryRow(row)));
        }
        for (BaseRow row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy((BaseRow)this.serializer.toBinaryRow(row), (BaseRow)new BinaryRow(row.getArity())));
        }
    }

    @Test
    public void testWrongCopy() {
        this.thrown.expect(IllegalArgumentException.class);
        this.serializer.copy((BaseRow)new GenericRow(this.serializer.getArity() + 1));
    }

    @Test
    public void testWrongCopyReuse() {
        this.thrown.expect(IllegalArgumentException.class);
        for (BaseRow row : this.testData) {
            this.checkDeepEquals(row, this.serializer.copy(row, (BaseRow)new GenericRow(row.getArity() + 1)));
        }
    }

    private static class WrappedString {
        private final String content;

        WrappedString(String content) {
            this.content = content;
        }
    }
}

