/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import com.esotericsoftware.kryo.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializerTest;
import org.apache.flink.table.runtime.typeutils.BaseMapSerializer;
import org.apache.flink.table.runtime.typeutils.SerializerTestUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.Assert;
import org.junit.Test;

public class BaseMapSerializerTest
extends SerializerTestBase<BaseMap> {
    private static final LogicalType INT = DataTypes.INT().getLogicalType();
    private static final LogicalType STRING = DataTypes.STRING().getLogicalType();

    public BaseMapSerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof BaseMap && o2 instanceof BaseMap, (o1, o2, checker) -> ((BaseMap)o1).toJavaMap(INT, STRING).equals(((BaseMap)o2).toJavaMap(INT, STRING))));
    }

    @Test
    public void testExecutionConfigWithKryo() throws Exception {
        BaseMap outputMap;
        byte[] serialized;
        ExecutionConfig config = new ExecutionConfig();
        config.enableForceKryo();
        config.registerTypeWithKryoSerializer(SerializerTestUtil.MyObj.class, (Serializer)new SerializerTestUtil.MyObjSerializer());
        BaseMapSerializer serializer = this.createSerializerWithConfig(config);
        int inputKey = 998244353;
        SerializerTestUtil.MyObj inputObj = new SerializerTestUtil.MyObj(114514, 1919810);
        HashMap<Integer, BinaryGeneric> javaMap = new HashMap<Integer, BinaryGeneric>();
        javaMap.put(inputKey, new BinaryGeneric((Object)inputObj));
        GenericMap inputMap = new GenericMap(javaMap);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            serializer.serialize((BaseMap)inputMap, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        BaseMapSerializer restoreSerializer = (BaseMapSerializer)SerializerTestUtil.snapshotAndReconfigure(serializer, () -> this.createSerializerWithConfig(config));
        try (ByteArrayInputStream in = new ByteArrayInputStream(serialized);){
            outputMap = restoreSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        TypeSerializer restoreKeySer = restoreSerializer.getKeySerializer();
        TypeSerializer restoreValueSer = restoreSerializer.getValueSerializer();
        Assert.assertEquals((Object)serializer.getKeySerializer(), (Object)restoreKeySer);
        Assert.assertEquals((Object)serializer.getValueSerializer(), (Object)restoreValueSer);
        SerializerTestUtil.MyObj outputObj = (SerializerTestUtil.MyObj)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)((BinaryGeneric)outputMap.toJavaMap(DataTypes.INT().getLogicalType(), DataTypes.RAW((TypeInformation)TypeInformation.of(SerializerTestUtil.MyObj.class)).getLogicalType()).get(inputKey)), (TypeSerializer)new KryoSerializer(SerializerTestUtil.MyObj.class, config));
        Assert.assertEquals((Object)inputObj, (Object)outputObj);
    }

    private BaseMapSerializer createSerializerWithConfig(ExecutionConfig config) {
        return new BaseMapSerializer(DataTypes.INT().getLogicalType(), DataTypes.RAW((TypeInformation)TypeInformation.of(SerializerTestUtil.MyObj.class)).getLogicalType(), config);
    }

    private static BaseMapSerializer newSer() {
        return new BaseMapSerializer(INT, STRING, new ExecutionConfig());
    }

    protected BaseMapSerializer createSerializer() {
        return BaseMapSerializerTest.newSer();
    }

    protected int getLength() {
        return -1;
    }

    protected Class<BaseMap> getTypeClass() {
        return BaseMap.class;
    }

    protected BaseMap[] getTestData() {
        HashMap<Integer, BinaryString> first = new HashMap<Integer, BinaryString>();
        first.put(1, BinaryString.fromString((String)""));
        return new BaseMap[]{new GenericMap(first), BinaryMap.valueOf((BinaryArray)BaseMapSerializerTest.createArray(1, 2), (BinaryArray)BaseArraySerializerTest.createArray("11", "haa")), BinaryMap.valueOf((BinaryArray)BaseMapSerializerTest.createArray(1, 3, 4), (BinaryArray)BaseArraySerializerTest.createArray("11", "haa", "ke")), BinaryMap.valueOf((BinaryArray)BaseMapSerializerTest.createArray(1, 4, 2), (BinaryArray)BaseArraySerializerTest.createArray("11", "haa", "ke")), BinaryMap.valueOf((BinaryArray)BaseMapSerializerTest.createArray(1, 5, 6, 7), (BinaryArray)BaseArraySerializerTest.createArray("11", "lele", "haa", "ke"))};
    }

    private static BinaryArray createArray(int ... vs) {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, vs.length, 4);
        for (int i = 0; i < vs.length; ++i) {
            writer.writeInt(i, vs[i]);
        }
        writer.complete();
        return array;
    }
}

