/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import com.esotericsoftware.kryo.Serializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.SerializerTestBase;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.kryo.KryoSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.DataOutputViewStreamWrapper;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.BaseArray;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryGeneric;
import org.apache.flink.table.dataformat.BinaryString;
import org.apache.flink.table.dataformat.GenericArray;
import org.apache.flink.table.runtime.typeutils.BaseArraySerializer;
import org.apache.flink.table.runtime.typeutils.SerializerTestUtil;
import org.apache.flink.testutils.DeeplyEqualsChecker;
import org.junit.Assert;
import org.junit.Test;

public class BaseArraySerializerTest
extends SerializerTestBase<BaseArray> {
    public BaseArraySerializerTest() {
        super(new DeeplyEqualsChecker().withCustomCheck((o1, o2) -> o1 instanceof BaseArray && o2 instanceof BaseArray, (o1, o2, checker) -> {
            BaseArray array1 = (BaseArray)o1;
            BaseArray array2 = (BaseArray)o2;
            if (array1.numElements() != array2.numElements()) {
                return false;
            }
            for (int i = 0; i < array1.numElements(); ++i) {
                if (array1.isNullAt(i) && array2.isNullAt(i)) continue;
                if (array1.isNullAt(i) || array2.isNullAt(i)) {
                    return false;
                }
                if (array1.getString(i).equals((Object)array2.getString(i))) continue;
                return false;
            }
            return true;
        }));
    }

    @Test
    public void testExecutionConfigWithKryo() throws Exception {
        BaseArray outputArray;
        byte[] serialized;
        ExecutionConfig config = new ExecutionConfig();
        config.enableForceKryo();
        config.registerTypeWithKryoSerializer(SerializerTestUtil.MyObj.class, (Serializer)new SerializerTestUtil.MyObjSerializer());
        BaseArraySerializer serializer = this.createSerializerWithConfig(config);
        SerializerTestUtil.MyObj inputObj = new SerializerTestUtil.MyObj(114514, 1919810);
        GenericArray inputArray = new GenericArray((Object)new BinaryGeneric[]{new BinaryGeneric((Object)inputObj)}, 1);
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            serializer.serialize((BaseArray)inputArray, (DataOutputView)new DataOutputViewStreamWrapper((OutputStream)out));
            serialized = out.toByteArray();
        }
        BaseArraySerializer restoreSerializer = (BaseArraySerializer)SerializerTestUtil.snapshotAndReconfigure(serializer, () -> this.createSerializerWithConfig(config));
        try (ByteArrayInputStream in = new ByteArrayInputStream(serialized);){
            outputArray = restoreSerializer.deserialize((DataInputView)new DataInputViewStreamWrapper((InputStream)in));
        }
        TypeSerializer restoreEleSer = restoreSerializer.getEleSer();
        Assert.assertEquals((Object)serializer.getEleSer(), (Object)restoreEleSer);
        SerializerTestUtil.MyObj outputObj = (SerializerTestUtil.MyObj)BinaryGeneric.getJavaObjectFromBinaryGeneric((BinaryGeneric)outputArray.getGeneric(0), (TypeSerializer)new KryoSerializer(SerializerTestUtil.MyObj.class, config));
        Assert.assertEquals((Object)inputObj, (Object)outputObj);
    }

    private BaseArraySerializer createSerializerWithConfig(ExecutionConfig config) {
        return new BaseArraySerializer(DataTypes.RAW((TypeInformation)TypeInformation.of(SerializerTestUtil.MyObj.class)).getLogicalType(), config);
    }

    protected BaseArraySerializer createSerializer() {
        return new BaseArraySerializer(DataTypes.STRING().getLogicalType(), new ExecutionConfig());
    }

    protected int getLength() {
        return -1;
    }

    protected Class<BaseArray> getTypeClass() {
        return BaseArray.class;
    }

    protected BaseArray[] getTestData() {
        return new BaseArray[]{new GenericArray((Object)new BinaryString[]{BinaryString.fromString((String)"11")}, 1), BaseArraySerializerTest.createArray("11", "haa"), BaseArraySerializerTest.createArray("11", "haa", "ke"), BaseArraySerializerTest.createArray("11", "haa", "ke"), BaseArraySerializerTest.createArray("11", "lele", "haa", "ke")};
    }

    static BinaryArray createArray(String ... vs) {
        BinaryArray array = new BinaryArray();
        BinaryArrayWriter writer = new BinaryArrayWriter(array, vs.length, 8);
        for (int i = 0; i < vs.length; ++i) {
            writer.writeString(i, BinaryString.fromString((String)vs[i]));
        }
        writer.complete();
        return array;
    }
}

