/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.runtime.types.DataTypePrecisionFixer;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.DataTypeVisitor;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.utils.TypeConversions;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DataTypePrecisionFixerTest {
    @Parameterized.Parameter
    public TestSpec testSpec;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Parameterized.Parameters(name="{index}: [From: {0}, To: {1}]")
    public static List<TestSpec> testData() {
        return Arrays.asList(TestSpecs.fix(Types.BIG_DEC).logicalType((LogicalType)new DecimalType(10, 5)).expect(DataTypes.DECIMAL((int)10, (int)5)), TestSpecs.fix(Types.SQL_TIMESTAMP).logicalType((LogicalType)new TimestampType(9)).expect(DataTypes.TIMESTAMP((int)9).bridgedTo(Timestamp.class)), TestSpecs.fix(Types.SQL_TIME).logicalType((LogicalType)new TimeType(9)).expect(DataTypes.TIME((int)9).bridgedTo(Time.class)), TestSpecs.fix(Types.SQL_DATE).logicalType((LogicalType)new DateType()).expect(DataTypes.DATE().bridgedTo(Date.class)), TestSpecs.fix(Types.LOCAL_DATE_TIME).logicalType((LogicalType)new TimestampType(9)).expect(DataTypes.TIMESTAMP((int)9)), TestSpecs.fix(Types.LOCAL_TIME).logicalType((LogicalType)new TimeType(9)).expect(DataTypes.TIME((int)9)), TestSpecs.fix(Types.LOCAL_DATE).logicalType((LogicalType)new DateType()).expect(DataTypes.DATE()), TestSpecs.fix(Types.INSTANT).logicalType((LogicalType)new LocalZonedTimestampType(2)).expect(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE((int)2)), TestSpecs.fix(Types.STRING).logicalType((LogicalType)new VarCharType(Integer.MAX_VALUE)).expect(DataTypes.STRING()), TestSpecs.fix(Types.ROW_NAMED((String[])new String[]{"field1", "field2"}, (TypeInformation[])new TypeInformation[]{Types.MAP((TypeInformation)Types.BIG_DEC, (TypeInformation)Types.SQL_TIMESTAMP), Types.OBJECT_ARRAY((TypeInformation)Types.SQL_TIME)})).logicalType((LogicalType)new RowType(Arrays.asList(new RowType.RowField("field1", (LogicalType)new MapType((LogicalType)new DecimalType(20, 2), (LogicalType)new TimestampType(0))), new RowType.RowField("field2", (LogicalType)new ArrayType((LogicalType)new TimeType(8)))))).expect(DataTypes.ROW((DataTypes.Field[])new DataTypes.Field[]{DataTypes.FIELD((String)"field1", (DataType)DataTypes.MAP((DataType)DataTypes.DECIMAL((int)20, (int)2), (DataType)DataTypes.TIMESTAMP((int)0).bridgedTo(Timestamp.class))), DataTypes.FIELD((String)"field2", (DataType)DataTypes.ARRAY((DataType)DataTypes.TIME((int)8).bridgedTo(Time.class)))})));
    }

    @Test
    public void testPrecisionFixing() {
        DataType dataType = TypeConversions.fromLegacyInfoToDataType((TypeInformation)this.testSpec.typeInfo);
        DataType newDataType = (DataType)dataType.accept((DataTypeVisitor)new DataTypePrecisionFixer(this.testSpec.logicalType));
        Assert.assertEquals((Object)this.testSpec.expectedType, (Object)newDataType);
    }

    private static class TestSpecs {
        private TypeInformation<?> typeInfo;
        private LogicalType logicalType;

        private TestSpecs() {
        }

        static TestSpecs fix(TypeInformation<?> typeInfo) {
            TestSpecs testSpecs = new TestSpecs();
            testSpecs.typeInfo = typeInfo;
            return testSpecs;
        }

        TestSpecs logicalType(LogicalType logicalType) {
            this.logicalType = logicalType;
            return this;
        }

        TestSpec expect(DataType expectedType) {
            return new TestSpec(this.typeInfo, this.logicalType, expectedType);
        }
    }

    private static class TestSpec {
        private final TypeInformation<?> typeInfo;
        private final LogicalType logicalType;
        private final DataType expectedType;

        private TestSpec(TypeInformation<?> typeInfo, LogicalType logicalType, DataType expectedType) {
            this.typeInfo = (TypeInformation)Preconditions.checkNotNull(typeInfo);
            this.logicalType = (LogicalType)Preconditions.checkNotNull((Object)logicalType);
            this.expectedType = (DataType)Preconditions.checkNotNull((Object)expectedType);
        }
    }
}

